/*
 * Decompiled with CFR 0.152.
 */
package org.ahocorasick.trie;

import java.util.ArrayList;
import java.util.Collection;
import org.ahocorasick.trie.State;

public class AsciiState
extends State {
    static final int SIZE = 256;
    private State[] success = new State[256];

    private State nextState(Character character, boolean ignoreRootState) {
        State nextState = this.success[character.charValue() & 0xFF];
        if (!ignoreRootState && nextState == null && this.rootState != null) {
            nextState = this.rootState;
        }
        return nextState;
    }

    public AsciiState() {
    }

    public AsciiState(int depth) {
        super(depth);
    }

    @Override
    public State nextState(Character character) {
        return this.nextState(character, false);
    }

    @Override
    public State nextStateIgnoreRootState(Character character) {
        return this.nextState(character, true);
    }

    @Override
    public State addState(Character character) {
        State nextState = this.nextStateIgnoreRootState(character);
        if (nextState == null) {
            this.success[character.charValue()] = nextState = new AsciiState(this.depth + 1);
        }
        return nextState;
    }

    @Override
    public Collection<State> getStates() {
        ArrayList<State> stateList = new ArrayList<State>(256);
        for (State state : this.success) {
            if (state == null) continue;
            stateList.add(state);
        }
        return stateList;
    }

    @Override
    public Collection<Character> getTransitions() {
        ArrayList<Character> stateList = new ArrayList<Character>(256);
        int i = 0;
        for (State state : this.success) {
            if (state != null) {
                stateList.add(Character.valueOf((char)i));
            }
            ++i;
        }
        return stateList;
    }
}

