/*
 * Decompiled with CFR 0.152.
 */
package org.ahocorasick.trie;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public abstract class State {
    protected final int depth;
    protected final State rootState;
    private State failure = null;
    private Set<String> emits = null;

    public State() {
        this(0);
    }

    public State(int depth) {
        this.depth = depth;
        this.rootState = depth == 0 ? this : null;
    }

    public int getDepth() {
        return this.depth;
    }

    public void addEmit(String keyword) {
        if (this.emits == null) {
            this.emits = new TreeSet<String>();
        }
        this.emits.add(keyword);
    }

    public void addEmit(Collection<String> emits) {
        for (String emit : emits) {
            this.addEmit(emit);
        }
    }

    public Collection<String> emit() {
        return this.emits == null ? Collections.emptyList() : this.emits;
    }

    public State failure() {
        return this.failure;
    }

    public void setFailure(State failState) {
        this.failure = failState;
    }

    public abstract State nextState(Character var1);

    public abstract State nextStateIgnoreRootState(Character var1);

    public abstract State addState(Character var1);

    public abstract Collection<State> getStates();

    public abstract Collection<Character> getTransitions();
}

