/*
 * Decompiled with CFR 0.152.
 */
package org.ahocorasick.trie;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import org.ahocorasick.interval.IntervalTree;
import org.ahocorasick.interval.Intervalable;
import org.ahocorasick.trie.AsciiState;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.FragmentToken;
import org.ahocorasick.trie.MatchToken;
import org.ahocorasick.trie.State;
import org.ahocorasick.trie.Token;
import org.ahocorasick.trie.TrieConfig;
import org.ahocorasick.trie.UnicodeState;

public class Trie {
    private TrieConfig trieConfig;
    private State rootState;
    private boolean failureStatesConstructed = false;

    public Trie(TrieConfig trieConfig) {
        this(trieConfig, true);
    }

    public Trie(TrieConfig trieConfig, boolean ascii) {
        this.trieConfig = trieConfig;
        this.rootState = ascii ? new AsciiState() : new UnicodeState();
    }

    public Trie() {
        this(new TrieConfig());
    }

    public Trie(boolean ascii) {
        this(new TrieConfig(), ascii);
    }

    public Trie caseInsensitive() {
        this.trieConfig.setCaseInsensitive(true);
        return this;
    }

    public Trie removeOverlaps() {
        this.trieConfig.setAllowOverlaps(false);
        return this;
    }

    public Trie onlyWholeWords() {
        this.trieConfig.setOnlyWholeWords(true);
        return this;
    }

    public void addKeyword(String keyword) {
        if (keyword == null || keyword.length() == 0) {
            return;
        }
        State currentState = this.rootState;
        char[] cArray = keyword.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            currentState = currentState.addState(character);
        }
        currentState.addEmit(keyword);
    }

    public Collection<Token> tokenize(String text) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Collection<Emit> collectedEmits = this.parseText(text);
        int lastCollectedPosition = -1;
        for (Emit emit : collectedEmits) {
            if (emit.getStart() - lastCollectedPosition > 1) {
                tokens.add(this.createFragment(emit, text, lastCollectedPosition));
            }
            tokens.add(this.createMatch(emit, text));
            lastCollectedPosition = emit.getEnd();
        }
        if (text.length() - lastCollectedPosition > 1) {
            tokens.add(this.createFragment(null, text, lastCollectedPosition));
        }
        return tokens;
    }

    private Token createFragment(Emit emit, String text, int lastCollectedPosition) {
        return new FragmentToken(text.substring(lastCollectedPosition + 1, emit == null ? text.length() : emit.getStart()));
    }

    private Token createMatch(Emit emit, String text) {
        return new MatchToken(text.substring(emit.getStart(), emit.getEnd() + 1), emit);
    }

    public Collection<Emit> parseText(String text) {
        this.checkForConstructedFailureStates();
        int position = 0;
        State currentState = this.rootState;
        ArrayList<Intervalable> collectedEmits = new ArrayList<Intervalable>();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            if (this.trieConfig.isCaseInsensitive()) {
                character = Character.valueOf(Character.toLowerCase(character.charValue()));
            }
            currentState = Trie.getState(currentState, character);
            Trie.storeEmits(position, currentState, collectedEmits);
            ++position;
        }
        if (this.trieConfig.isOnlyWholeWords()) {
            this.removePartialMatches(text, collectedEmits);
        }
        if (!this.trieConfig.isAllowOverlaps()) {
            IntervalTree intervalTree = new IntervalTree(collectedEmits);
            intervalTree.removeOverlaps(collectedEmits);
        }
        return collectedEmits;
    }

    private void removePartialMatches(String searchText, List<Emit> collectedEmits) {
        long size = searchText.length();
        ArrayList<Emit> removeEmits = new ArrayList<Emit>(10);
        for (Emit emit : collectedEmits) {
            if (!(emit.getStart() != 0 && Character.isAlphabetic(searchText.charAt(emit.getStart() - 1)) || (long)(emit.getEnd() + 1) != size && Character.isAlphabetic(searchText.charAt(emit.getEnd() + 1)))) continue;
            removeEmits.add(emit);
        }
        for (Emit removeEmit : removeEmits) {
            collectedEmits.remove(removeEmit);
        }
    }

    private static State getState(State currentState, Character character) {
        State newCurrentState = currentState.nextState(character);
        while (newCurrentState == null) {
            currentState = currentState.failure();
            newCurrentState = currentState.nextState(character);
        }
        return newCurrentState;
    }

    private void checkForConstructedFailureStates() {
        if (!this.failureStatesConstructed) {
            this.constructFailureStates();
        }
    }

    private void constructFailureStates() {
        LinkedBlockingDeque<State> queue = new LinkedBlockingDeque<State>();
        for (State depthOneState : this.rootState.getStates()) {
            depthOneState.setFailure(this.rootState);
            queue.add(depthOneState);
        }
        this.failureStatesConstructed = true;
        while (!queue.isEmpty()) {
            State currentState = (State)queue.remove();
            for (Character transition : currentState.getTransitions()) {
                State targetState = currentState.nextState(transition);
                queue.add(targetState);
                State traceFailureState = currentState.failure();
                while (traceFailureState.nextState(transition) == null) {
                    traceFailureState = traceFailureState.failure();
                }
                State newFailureState = traceFailureState.nextState(transition);
                targetState.setFailure(newFailureState);
                targetState.addEmit(newFailureState.emit());
            }
        }
    }

    private static void storeEmits(int position, State currentState, List<Emit> collectedEmits) {
        Collection<String> emits = currentState.emit();
        if (emits != null && !emits.isEmpty()) {
            for (String emit : emits) {
                collectedEmits.add(new Emit(position - emit.length() + 1, position, emit));
            }
        }
    }
}

