/*
 * Decompiled with CFR 0.152.
 */
package org.ahocorasick.trie;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.ahocorasick.trie.State;

public class UnicodeState
extends State {
    private Map<Character, State> success = new TreeMap<Character, State>();

    public UnicodeState() {
    }

    public UnicodeState(int depth) {
        super(depth);
    }

    private State nextState(Character character, boolean ignoreRootState) {
        State nextState = this.success.get(character);
        if (!ignoreRootState && nextState == null && this.rootState != null) {
            nextState = this.rootState;
        }
        return nextState;
    }

    @Override
    public State nextState(Character character) {
        return this.nextState(character, false);
    }

    @Override
    public State nextStateIgnoreRootState(Character character) {
        return this.nextState(character, true);
    }

    @Override
    public State addState(Character character) {
        State nextState = this.nextStateIgnoreRootState(character);
        if (nextState == null) {
            nextState = new UnicodeState(this.depth + 1);
            this.success.put(character, nextState);
        }
        return nextState;
    }

    @Override
    public Collection<State> getStates() {
        return this.success.values();
    }

    @Override
    public Collection<Character> getTransitions() {
        return this.success.keySet();
    }
}

