/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.mservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.dataconverter.IDISchemaResultPCDataConvert;
import kd.data.idi.dataconverter.IDISchemaResultStatisticDataConvert;
import kd.data.idi.engine.SchemaExecutor;
import kd.data.idi.engine.SchemaParallelExecutor;
import kd.data.idi.engine.SchemaSearcher;
import kd.data.idi.log.EventTrackingTypeEnum;
import kd.data.idi.log.IDIEventTrackingLog;
import kd.data.idi.mservice.IDISchemaParallelService;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.Pair;
import kd.data.idi.util.SchemaExeResultHelper;

public class IDISchemaParallelServiceImpl
implements IDISchemaParallelService {
    private static final String Parallel_key = "parallel";
    private static final String End_key = "end";
    private static final Log logger = LogFactory.getLog(IDISchemaParallelServiceImpl.class);

    public String executeSchema(DynamicObject bizObj, String pageId) {
        logger.info("IDISchemaParallelServiceImpl.executeSchema(DynamicObject bizObj, String pageId). param:%s", (Object)bizObj, (Object)pageId);
        String result = this.executeSchemaCore(schemaSearcher -> schemaSearcher.match(bizObj), bizObj, pageId);
        logger.info("IDISchemaParallelServiceImpl.executeSchema(DynamicObject bizObj, String pageId). result:%s", (Object)result);
        return result;
    }

    public String executeSchema(DynamicObject bizObj, String schemaNumber, String pageId) {
        logger.info("IDISchemaParallelServiceImpl.executeSchema(DynamicObject bizObj, String schemaNumber, String pageId). param:%s", new Object[]{bizObj, schemaNumber, pageId});
        String result = this.executeSchemaCore(schemaSearcher -> schemaSearcher.match(bizObj, schemaNumber), bizObj, pageId);
        logger.info("IDISchemaParallelServiceImpl.executeSchema(DynamicObject bizObj, String schemaNumber, String pageId). result:%s", (Object)result);
        return result;
    }

    public String executeSchemaByList(DynamicObject bizObj, List<String> schemaNumbers, String pageId) {
        logger.info("IDISchemaParallelServiceImpl.executeSchemaByList(DynamicObject bizObj, List<String> schemaNumbers, String pageId). param:%s", new Object[]{bizObj, schemaNumbers, pageId});
        String result = this.executeSchemaCore(schemaSearcher -> schemaSearcher.match(bizObj, schemaNumbers), bizObj, pageId);
        logger.info("IDISchemaParallelServiceImpl.executeSchema(DynamicObject bizObj, List<String> schemaNumbers, String pageId). result:%s", (Object)result);
        return result;
    }

    private String executeSchemaCore(Function<SchemaSearcher, Object[]> searcherFunction, DynamicObject bizObj, String pageId) {
        SchemaSearcher ss = new SchemaSearcher();
        Object[] result = searcherFunction.apply(ss);
        Schema schema = (Schema)result[1];
        boolean end = true;
        String billType = bizObj.getDataEntityType().getName();
        if (schema != null) {
            long billId = (Long)bizObj.getPkValue();
            if (SchemaExeResultHelper.isRunning((Schema)schema, (long)billId, (String)billType, (String)pageId)) {
                DynamicObject schemaResultRecord = SchemaExeResultHelper.queryLastSchemaResult((Schema)schema, (Object)((Long)bizObj.getPkValue()), (String)billType, (String)pageId);
                Pair queryResult = SchemaExeResultHelper.build((DynamicObject)schemaResultRecord, (Schema)schema, (Object)((Long)bizObj.getPkValue()), (String)billType, (String)pageId);
                end = (Boolean)queryResult.getValue();
                result[0] = queryResult.getKey();
            } else {
                result[0] = new SchemaParallelExecutor().execute(schema, billType, (Long)bizObj.getPkValue(), pageId, false);
                end = false;
            }
        }
        SchemaResult schemaResult = (SchemaResult)result[0];
        IDISchemaResultPCDataConvert converter = new IDISchemaResultPCDataConvert();
        Map htmlMap = converter.convertObject(schemaResult, schema);
        htmlMap.put(Parallel_key, true);
        htmlMap.put(End_key, end);
        IDIEventTrackingLog eventTrackingLog = IDIEventTrackingLog.instance((Schema)schema, (EventTrackingTypeEnum)EventTrackingTypeEnum.LIGHT, (String)billType);
        eventTrackingLog.print();
        return IDIJSONUtils.toJsonString((Object)htmlMap);
    }

    public String querySchemaResult(DynamicObject bizObj, String pageId) {
        Map<String, Boolean> htmlMap;
        logger.info("IDISchemaParallelServiceImpl.querySchemaResult(DynamicObject bizObj, String pageId). param:%s", (Object)bizObj, (Object)pageId);
        String billType = bizObj.getDataEntityType().getName();
        DynamicObject schemaResultRecord = SchemaExeResultHelper.queryLastSchemaResult(null, (Object)((Long)bizObj.getPkValue()), (String)billType, (String)pageId);
        boolean end = true;
        if (schemaResultRecord != null) {
            long schemaId = schemaResultRecord.getLong("schema");
            DynamicObject schemaObj = QueryServiceHelper.queryOne((String)"idi_schema", (String)"id,number,name,rule_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemaId)});
            Schema schema = (Schema)IDIJSONUtils.cast((String)schemaObj.getString("rule_tag"), Schema.class);
            schema.setNumber(schemaObj.getString("number"));
            schema.setName(schemaObj.getString("name"));
            schema.setId(schemaObj.getLong("id"));
            Pair queryResult = SchemaExeResultHelper.build((DynamicObject)schemaResultRecord, (Schema)schema, (Object)((Long)bizObj.getPkValue()), (String)billType, (String)pageId);
            end = (Boolean)queryResult.getValue();
            SchemaResult schemaResult = (SchemaResult)queryResult.getKey();
            IDISchemaResultPCDataConvert converter = new IDISchemaResultPCDataConvert();
            htmlMap = converter.convertObject(schemaResult, schema);
        } else {
            htmlMap = new HashMap<String, Boolean>();
        }
        htmlMap.put(Parallel_key, true);
        htmlMap.put(End_key, end);
        String result = IDIJSONUtils.toJsonString(htmlMap);
        logger.info("IDISchemaParallelServiceImpl.querySchemaResult(DynamicObject bizObj, String pageId). result:%s", (Object)result);
        return result;
    }

    public String executeSchemaByBillId(Object billId, String billType, String pageId) {
        DynamicObject billObj = this.loadBillObjOnlyId(billId, billType);
        return this.executeSchema(billObj, pageId);
    }

    public String executeSchema(Object billId, String billType, String schemaNumber, String pageId) {
        DynamicObject billObj = this.loadBillObjOnlyId(billId, billType);
        return this.executeSchema(billObj, schemaNumber, pageId);
    }

    public String executeSchemaByList(Object billId, String billType, List<String> schemaNumbers, String pageId) {
        DynamicObject billObj = this.loadBillObjOnlyId(billId, billType);
        return this.executeSchemaByList(billObj, schemaNumbers, pageId);
    }

    public String querySchemaResult(Object billId, String billType, String pageId) {
        DynamicObject billObj = this.loadBillObjOnlyId(billId, billType);
        return this.querySchemaResult(billObj, pageId);
    }

    public String executeSchemaByList(Object billId, String billType, List<String> schemaNumbers, String pageId, Map<String, Object> extParamMap) {
        DynamicObject billObj = this.loadBillObjOnlyId(billId, billType);
        logger.info("IDISchemaParallelServiceImpl.executeSchemaByList(Object billId, String billType, List<String> schemaNumbers, String pageId, Map<String, Object> extParamMap)", new Object[]{billObj, schemaNumbers, pageId, extParamMap});
        String result = this.executeSchemaCoreByParam(schemaSearcher -> schemaSearcher.match(billObj, schemaNumbers), billObj, pageId, extParamMap);
        logger.info("IDISchemaParallelServiceImpl.executeSchema(Object billId, String billType, List<String> schemaNumbers, String pageId, Map<String, Object> extParamMap). result:%s", (Object)result);
        return result;
    }

    public String executeSchemaByBillId(Object billId, String billType, String pageId, Map<String, Object> extParamMap) {
        DynamicObject billObj = this.loadBillObjOnlyId(billId, billType);
        logger.info("IDISchemaParallelServiceImpl.executeSchema(Object billId, String billType, String pageId, Map<String, Object> extParamMap). param:%s", (Object)billObj, (Object)pageId);
        String result = this.executeSchemaCoreByParam(schemaSearcher -> schemaSearcher.match(billObj), billObj, pageId, extParamMap);
        logger.info("IDISchemaParallelServiceImpl.executeSchema(Object billId, String billType, String pageId, Map<String, Object> extParamMap). result:%s", (Object)result);
        return result;
    }

    public String executeSchema(Object billId, String billType, String schemaNumber, String pageId, Map<String, Object> extParamMap) {
        DynamicObject billObj = this.loadBillObjOnlyId(billId, billType);
        logger.info("IDISchemaParallelServiceImpl.executeSchema(Object billId, String billType, String schemaNumber, String pageId, Map<String, Object> extParamMap). param:%s", new Object[]{billObj, schemaNumber, pageId});
        String result = this.executeSchemaCoreByParam(schemaSearcher -> schemaSearcher.match(billObj, schemaNumber), billObj, pageId, extParamMap);
        logger.info("IDISchemaParallelServiceImpl.executeSchema(Object billId, String billType, String schemaNumber, String pageId, Map<String, Object> extParamMap). result:%s", (Object)result);
        return result;
    }

    public String querySchemaResult(Object billId, String billType, String pageId, Map<String, Object> extParamMap) {
        Map<String, Boolean> htmlMap;
        logger.info(String.format("IDISchemaParallelServiceImpl.querySchemaResult(Object billId %s, String billType %s, String pageId %s, Map<String, Object> extParamMap %s)", billId, billType, pageId, IDIJSONUtils.toJsonString(extParamMap)));
        DynamicObject schemaResultRecord = SchemaExeResultHelper.queryLastSchemaResult(null, (Object)billId, (String)billType, (String)pageId);
        boolean end = true;
        if (schemaResultRecord != null) {
            Boolean needHeadPopover;
            Boolean needAiAttachment;
            long schemaId = schemaResultRecord.getLong("schema");
            DynamicObject schemaObj = QueryServiceHelper.queryOne((String)"idi_schema", (String)"id,number,name,rule_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemaId)});
            Schema schema = (Schema)IDIJSONUtils.cast((String)schemaObj.getString("rule_tag"), Schema.class);
            schema.setNumber(schemaObj.getString("number"));
            schema.setName(schemaObj.getString("name"));
            schema.setId(schemaObj.getLong("id"));
            Pair queryResult = SchemaExeResultHelper.build((DynamicObject)schemaResultRecord, (Schema)schema, (Object)billId, (String)billType, (String)pageId);
            end = (Boolean)queryResult.getValue();
            SchemaResult schemaResult = (SchemaResult)queryResult.getKey();
            String filterType = (String)extParamMap.get("filterType");
            Boolean filterAI = (Boolean)extParamMap.get("filterAI");
            if (filterAI == null) {
                filterAI = Boolean.FALSE;
            }
            if ((needAiAttachment = (Boolean)extParamMap.get("needAiAttachment")) == null) {
                needAiAttachment = Boolean.FALSE;
            }
            if ((needHeadPopover = (Boolean)extParamMap.get("needAiTips")) == null) {
                needHeadPopover = Boolean.FALSE;
            }
            IDISchemaResultStatisticDataConvert converter = needAiAttachment != false ? new IDISchemaResultStatisticDataConvert(filterType, filterAI, needHeadPopover.booleanValue()) : new IDISchemaResultPCDataConvert();
            htmlMap = (Map)converter.convertObject((Object)schemaResult, (Object)schema);
        } else {
            htmlMap = new HashMap<String, Boolean>();
        }
        htmlMap.put(Parallel_key, true);
        htmlMap.put(End_key, end);
        String result = IDIJSONUtils.toJsonString(htmlMap);
        logger.info(String.format("IDISchemaParallelServiceImpl.querySchemaResult(DynamicObject bizObj, String pageId). result:%s", result));
        return result;
    }

    private String executeSchemaCoreByParam(Function<SchemaSearcher, Object[]> searcherFunction, DynamicObject bizObj, String pageId, Map<String, Object> paramMap) {
        SchemaSearcher ss = new SchemaSearcher();
        Object[] result = searcherFunction.apply(ss);
        Schema schema = (Schema)result[1];
        boolean end = true;
        String billType = bizObj.getDataEntityType().getName();
        Boolean needAiAttachment = (Boolean)paramMap.get("needAiAttachment");
        if (needAiAttachment == null) {
            needAiAttachment = false;
        }
        if (schema != null) {
            long billId = (Long)bizObj.getPkValue();
            if (SchemaExeResultHelper.isRunning((Schema)schema, (long)billId, (String)billType, (String)pageId)) {
                DynamicObject schemaResultRecord = SchemaExeResultHelper.queryLastSchemaResult((Schema)schema, (Object)((Long)bizObj.getPkValue()), (String)billType, (String)pageId);
                Pair queryResult = SchemaExeResultHelper.build((DynamicObject)schemaResultRecord, (Schema)schema, (Object)((Long)bizObj.getPkValue()), (String)billType, (String)pageId);
                end = (Boolean)queryResult.getValue();
                result[0] = queryResult.getKey();
            } else {
                Boolean needRefreshAiResult = (Boolean)paramMap.get("needRefreshAiResult");
                if (needRefreshAiResult == null) {
                    needRefreshAiResult = false;
                }
                SchemaExecutor.ExecuteParam ep = new SchemaExecutor.ExecuteParam(schema, billType, bizObj.getPkValue(), bizObj, pageId, false, needAiAttachment.booleanValue(), needRefreshAiResult.booleanValue());
                result[0] = new SchemaParallelExecutor().execute(ep);
                end = false;
            }
        }
        SchemaResult schemaResult = (SchemaResult)result[0];
        Boolean needHeadPopover = (Boolean)paramMap.get("needAiTips");
        if (needHeadPopover == null) {
            needHeadPopover = false;
        }
        IDISchemaResultStatisticDataConvert converter = needAiAttachment != false ? new IDISchemaResultStatisticDataConvert(needHeadPopover.booleanValue()) : new IDISchemaResultPCDataConvert();
        Map htmlMap = (Map)converter.convertObject((Object)schemaResult, (Object)schema);
        htmlMap.put(Parallel_key, true);
        htmlMap.put(End_key, end);
        IDIEventTrackingLog eventTrackingLog = IDIEventTrackingLog.instance((Schema)schema, (EventTrackingTypeEnum)EventTrackingTypeEnum.LIGHT, (String)billType);
        eventTrackingLog.print();
        return IDIJSONUtils.toJsonString((Object)htmlMap);
    }

    private DynamicObject loadBillObjOnlyId(Object billId, String billType) {
        return BusinessDataServiceHelper.loadSingle((Object)billId, (String)billType, (String)"id");
    }
}

