/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.data.idi.util.InvoiceParser;

public class IDISchemaUpgradeInvoiceServiceImpl
implements IUpgradeService {
    private static final String UPDATE_SQL = "update t_idi_invoice set findexfield = ? where fid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute idiRoute = DBRoute.of((String)"bdai");
        int length = 3000;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"idi_invoice");
        ArrayList<Object> idList = new ArrayList<Object>(length);
        try (DataSet dataSet = DB.queryDataSet((String)"IDISchemaUpgradeInvoiceServiceImpl.queryTrainAndPlanInvoice", (DBRoute)idiRoute, (String)"select fid from t_idi_invoice where finvoicetype in ('9', '10') and (findexfield  = ' ' or findexfield = '') ");){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    idList.add(row.get("fid"));
                }
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo(e.getMessage());
        }
        int count = idList.size();
        if (!idList.isEmpty()) {
            ArrayList<Object> batchIdList = new ArrayList<Object>(length);
            for (int i = 0; i < count; ++i) {
                batchIdList.add(idList.get(i));
                if (batchIdList.size() < length) continue;
                this.processIndexField(batchIdList, mainEntityType, result, idiRoute);
                batchIdList.clear();
            }
            if (!batchIdList.isEmpty()) {
                this.processIndexField(batchIdList, mainEntityType, result, idiRoute);
            }
        }
        if (result.isSuccess()) {
            result.setLog("total of data " + count);
        }
        return result;
    }

    private void processIndexField(List<Object> idList, MainEntityType mainEntityType, UpgradeResult result, DBRoute idiRoute) {
        try {
            if (!idList.isEmpty()) {
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)mainEntityType.getName(), (String)"invoicetype,entrykeyvalue.invoicekey,entrykeyvalue.invoicevalue", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
                ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(5);
                if (invoices != null && invoices.length > 0) {
                    for (DynamicObject invoice : invoices) {
                        String key = InvoiceParser.buildTrainAndPlanInvoiceKey((DynamicObject)invoice);
                        Object[] params = new Object[]{key, invoice.getPkValue()};
                        updateParamList.add(params);
                    }
                }
                DB.executeBatch((DBRoute)idiRoute, (String)UPDATE_SQL, updateParamList);
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo(e.getMessage());
        }
    }
}

