/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class IDIDisclaimerUtil {
    private static final String FormId_IDI_DISCLAIMER = "idi_disclaimer";
    private static final String CLOSED_CALLBACK_DISCLAIMER = "closedCallbackDisclaimer";
    private static final String KEY_PARAM_KEY = "param_key";
    private static final String KEY_PARAM_VAL = "param_val";
    private static final String KEY_PARAM_DESC = "param_desc";
    private static final String FormId_IDI_PARAM_CONFIG = "idi_param_config";
    private static final Long ID_DISCLAIMER = 1330244124133102592L;
    private static final String FormId_IDI_ACCEPT_LOG = "idi_accept_log";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_ACCEPTOR = "acceptor";
    private static final String KEY_ACCEPTTYPE = "accepttype";
    private static final String KEY_CONTENT = "content";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_MATCH_TYPE = "matchType";
    private static final String TYPE_NEWS = "news";

    public static boolean disclaimerStatus() {
        DynamicObject paramConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)ID_DISCLAIMER, (String)FormId_IDI_PARAM_CONFIG);
        return paramConfig == null || Boolean.parseBoolean(paramConfig.getString(KEY_PARAM_VAL));
    }

    public static boolean isNewsAndEnabled(Object[] ids) {
        if (ids != null && ids.length > 0) {
            Map schemas = BusinessDataServiceHelper.loadFromCache((String)"idi_schema", (String)"id,enable,rule,rule_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            for (DynamicObject schemaDo : schemas.values()) {
                String schemaConfigStr;
                boolean newsAndEnabled;
                if ("1".equals(schemaDo.getString(KEY_ENABLE)) || !(newsAndEnabled = IDIDisclaimerUtil.isNewsAndEnabled(schemaConfigStr = schemaDo.getString("rule_tag")))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNewsAndEnabled(String ruleJson) {
        JSONArray areaArray;
        JSONObject schemaConfig;
        if (StringUtils.isNotEmpty((String)ruleJson) && (schemaConfig = JSONObject.parseObject((String)ruleJson)) != null && (areaArray = schemaConfig.getJSONArray("area")) != null && !areaArray.isEmpty()) {
            for (int i = 0; i < areaArray.size(); ++i) {
                JSONObject area = areaArray.getJSONObject(i);
                JSONArray decisionArray = area.getJSONArray("decision");
                if (decisionArray == null || decisionArray.isEmpty()) continue;
                for (int k = 0; k < decisionArray.size(); ++k) {
                    JSONObject decision = decisionArray.getJSONObject(k);
                    if (!TYPE_NEWS.equalsIgnoreCase(decision.getString(KEY_MATCH_TYPE)) || !decision.getBoolean(KEY_ENABLED).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void showDisclaimer(IFormView view, AbstractFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(FormId_IDI_DISCLAIMER);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, CLOSED_CALLBACK_DISCLAIMER));
        view.showForm(parameter);
    }

    public static void acceptDisclaimer() {
        DynamicObject acceptDyo = BusinessDataServiceHelper.newDynamicObject((String)FormId_IDI_ACCEPT_LOG);
        DynamicObject paramConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)ID_DISCLAIMER, (String)FormId_IDI_PARAM_CONFIG);
        acceptDyo.set(KEY_NUMBER, paramConfig.get(KEY_PARAM_KEY));
        acceptDyo.set("acceptor_id", (Object)RequestContext.get().getCurrUserId());
        acceptDyo.set(KEY_ACCEPTTYPE, (Object)"1");
        acceptDyo.set(KEY_CONTENT, paramConfig.get(KEY_PARAM_DESC));
        paramConfig.set(KEY_PARAM_VAL, (Object)"True");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{acceptDyo});
        SaveServiceHelper.update((DynamicObject)paramConfig);
    }
}

