/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.util.StringUtils;

public class IDIStringUtils {
    public static final String defaultSplitor = ",";

    public static List<String> strSplite(String str, String spliteStr) {
        ArrayList<String> results = new ArrayList<String>(2);
        if (!StringUtils.isEmpty((String)str)) {
            if (str.contains(spliteStr)) {
                String[] numbers;
                for (String number : numbers = str.split(spliteStr)) {
                    if (StringUtils.isEmpty((String)number)) continue;
                    results.add(number);
                }
            } else {
                results.add(str);
            }
        }
        return results;
    }

    public static List<String> strSplite(String str) {
        return IDIStringUtils.strSplite(str, defaultSplitor);
    }

    public static String buildTemplateField(Long templateId, String originField) {
        return IDIStringUtils.templatePrefix(templateId) + originField;
    }

    public static String buildTemplateField(String templateIdStr, String originField) {
        return IDIStringUtils.templatePrefix(templateIdStr) + originField;
    }

    public static String templatePrefix(Long templateId) {
        return IDIStringUtils.templatePrefixNoBillObj(String.valueOf(templateId)) + "_billObj.";
    }

    public static String templatePrefix(String templateIdStr) {
        return IDIStringUtils.templatePrefixNoBillObj(templateIdStr) + "_billObj.";
    }

    public static String templatePrefixNoBillObj(String templateIdStr) {
        return "idi" + templateIdStr;
    }

    public static boolean isInteger(String value) {
        return StringUtils.isNotEmpty((String)value) && value.matches("^\\d+$");
    }

    public static LocaleString ormLocaleToLocate(OrmLocaleValue ormLocaleValue) {
        if (ormLocaleValue == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(7);
        for (String loId : ormLocaleValue.keySet()) {
            map.put(loId, ormLocaleValue.get((Object)loId));
        }
        return LocaleString.fromMap(map);
    }

    public static boolean ormLocaleIsEmpty(OrmLocaleValue ormLocaleValue) {
        return IDIStringUtils.localeIsEmpty(IDIStringUtils.ormLocaleToLocate(ormLocaleValue));
    }

    public static boolean localeIsEmpty(LocaleString localeValue) {
        if (localeValue == null || localeValue.isEmpty()) {
            return true;
        }
        boolean isEmpty = true;
        for (String loId : localeValue.keySet()) {
            String text = (String)localeValue.get((Object)loId);
            if (!StringUtils.isNotEmpty((String)text)) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }
}

