/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.util.IDIJSONUtils;

public class IDIGeneralPointDeductFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_DEDUCT_PROPORTION = "deduct_proportion";
    private static final String POINT_DEDUCT_CONFIG_VALUE = "point_deduct_config_value";
    private static final String Key_ANALYSIS_MODE = "analysis_mode";
    private static final String KEY_DEDUCT_PASS = "commonpass";
    private static final String KEY_SAVE = "save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        String deductPointConfigStr;
        super.afterCreateNewData(e);
        this.getModel().setValue("points_can_deduct", (Object)ResManager.loadKDString((String)"\u65e0\u53d1\u7968\u6570\u636e\u6216\u8005\u4e0d\u6ee1\u8db3\u53d1\u7968OCR\u6570\u636e\u7b5b\u9009\u6761\u4ef6\u3002", (String)"IDIGeneralPointDeductFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]), 0);
        this.getModel().setValue("points_can_deduct", (Object)ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"IDIGeneralPointDeductFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), 1);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if ("idi_alarm_config".equals(fsp.getParentFormId())) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("points_can_deduct", (Object)ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"IDIGeneralPointDeductFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), 0);
        }
        if (StringUtils.isNotEmpty((String)(deductPointConfigStr = (String)fsp.getCustomParam(POINT_DEDUCT_CONFIG_VALUE)))) {
            List deductionGradeConfigList = IDIJSONUtils.jsonCastToList((String)deductPointConfigStr, DeductionGradeConfig.class);
            for (int i = 0; i < deductionGradeConfigList.size(); ++i) {
                DeductionGradeConfig dgc = (DeductionGradeConfig)deductionGradeConfigList.get(i);
                this.getModel().setValue(KEY_DEDUCT_PROPORTION, (Object)dgc.getPercent(), i);
                this.getModel().setValue(KEY_DEDUCT_PASS, (Object)dgc.isPass(), i);
            }
        }
        String analysisMode = (String)this.getView().getFormShowParameter().getCustomParam(Key_ANALYSIS_MODE);
        boolean isNoScore = AnalysisMode.NOSCORE.getType().equalsIgnoreCase(analysisMode);
        this.getView().setVisible(Boolean.valueOf(!isNoScore), new String[]{KEY_DEDUCT_PROPORTION});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "save": {
                FormShowParameter fsp = this.getView().getFormShowParameter();
                ArrayList<DeductionGradeConfig> deductionGradeConfigList = new ArrayList<DeductionGradeConfig>(1);
                if ("idi_alarm_config".equals(fsp.getParentFormId())) {
                    DeductionGradeConfig noMatchStartCondition = new DeductionGradeConfig();
                    noMatchStartCondition.setSeq(1);
                    noMatchStartCondition.setItem(DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
                    noMatchStartCondition.setPercent(((Integer)this.getModel().getValue(KEY_DEDUCT_PROPORTION, 0)).intValue());
                    noMatchStartCondition.setPass(((Boolean)this.getModel().getValue(KEY_DEDUCT_PASS, 0)).booleanValue());
                    deductionGradeConfigList.add(noMatchStartCondition);
                } else {
                    DeductionGradeConfig deductionGradeconfig = new DeductionGradeConfig();
                    deductionGradeconfig.setSeq(1);
                    deductionGradeconfig.setItem(DeductionGradeConfig.DeductionGradeItem.NO_INVOICE);
                    deductionGradeconfig.setPercent(((Integer)this.getModel().getValue(KEY_DEDUCT_PROPORTION, 0)).intValue());
                    deductionGradeconfig.setPass(((Boolean)this.getModel().getValue(KEY_DEDUCT_PASS, 0)).booleanValue());
                    deductionGradeConfigList.add(deductionGradeconfig);
                    DeductionGradeConfig noMatchStartCondition = new DeductionGradeConfig();
                    noMatchStartCondition.setSeq(2);
                    noMatchStartCondition.setItem(DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
                    noMatchStartCondition.setPercent(((Integer)this.getModel().getValue(KEY_DEDUCT_PROPORTION, 1)).intValue());
                    noMatchStartCondition.setPass(((Boolean)this.getModel().getValue(KEY_DEDUCT_PASS, 1)).booleanValue());
                    deductionGradeConfigList.add(noMatchStartCondition);
                }
                this.getView().returnDataToParent((Object)IDIJSONUtils.toJsonString(deductionGradeConfigList));
                this.getView().close();
            }
        }
    }
}

