/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.idi.data.CustomInvoiceParam;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.util.IDIJSONUtils;

public class IDIInvoiceCustomFormPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String CustomParam_ENTITY_NUMBER = "entitynumber";
    private static final String CustomParam_CONFIG = "config";
    private static final String FIELD_CLIENTID = "clientid";
    private static final String FIELD_SECRET = "secret";
    private static final String FIELD_BXDKEY = "bxd_key";
    private static final String FORMID_IDI_INVOICECUSTOM = "idi_invoicecustom";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        String configStr;
        MainEntityType entityType;
        EntityTypeUtil helper;
        List cols;
        List<ComboItem> comboItems;
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        if (StringUtils.isNotEmpty((String)entityNumber) && (comboItems = this.createComboItem(entityNumber, cols = (helper = new EntityTypeUtil()).getFilterColumns((IDataEntityType)(entityType = EntityMetadataCache.getDataEntityType((String)entityNumber)), false))) != null) {
            ComboEdit clientIdEdit = (ComboEdit)this.getControl(FIELD_CLIENTID);
            clientIdEdit.setComboItems(comboItems);
            ComboEdit secretEdit = (ComboEdit)this.getControl(FIELD_SECRET);
            secretEdit.setComboItems(comboItems);
            ComboEdit bxdKeyEdit = (ComboEdit)this.getControl(FIELD_BXDKEY);
            bxdKeyEdit.setComboItems(comboItems);
        }
        if (StringUtils.isNotEmpty((String)(configStr = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_CONFIG)))) {
            CustomInvoiceParam configObj = (CustomInvoiceParam)IDIJSONUtils.cast((String)configStr, CustomInvoiceParam.class);
            this.getModel().setValue(FIELD_CLIENTID, (Object)configObj.getClientId());
            this.getModel().setValue(FIELD_SECRET, (Object)configObj.getSecret());
            this.getModel().setValue(FIELD_BXDKEY, (Object)configObj.getBxdKey());
        }
    }

    private List<ComboItem> createComboItem(String entityNumber, List<Map<String, Object>> listNodes) {
        if (listNodes == null) {
            return null;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(listNodes.size());
        for (Map<String, Object> map : listNodes) {
            int fieldType = (Integer)map.get("fieldType");
            if (fieldType != -9) continue;
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(fieldCaption);
            String value = fieldName;
            if (!StringUtils.isEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
                value = entryEntity + "." + fieldName;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(localeString);
            comboItem.setValue(value);
            list.add(comboItem);
        }
        return list;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            String clientId = (String)this.getModel().getValue(FIELD_CLIENTID);
            String secret = (String)this.getModel().getValue(FIELD_SECRET);
            String bxdKey = (String)this.getModel().getValue(FIELD_BXDKEY);
            String error = ResManager.loadKDString((String)"\u201c%s\u201d\u53c2\u6570\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7968\u636e\u68c0\u67e5\u7684\u53c2\u6570\u914d\u7f6e\u3002", (String)"IDIInvoiceCustomFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]);
            if (StringUtils.isEmpty((String)clientId)) {
                this.getView().showTipNotification(String.format(error, FIELD_CLIENTID));
                return;
            }
            if (StringUtils.isEmpty((String)secret)) {
                this.getView().showTipNotification(String.format(error, FIELD_SECRET));
                return;
            }
            if (StringUtils.isEmpty((String)bxdKey)) {
                this.getView().showTipNotification(String.format(error, FIELD_BXDKEY));
                return;
            }
            HashSet entrySet = new HashSet(2);
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
            if (StringUtils.isNotEmpty((String)entityNumber)) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                Set entries = ScriptUtils.getEntries((MainEntityType)entityType, (String)(entityNumber + "_billObj." + clientId), (String[])new String[]{entityNumber});
                entrySet.addAll(entries);
                entries = ScriptUtils.getEntries((MainEntityType)entityType, (String)(entityNumber + "_billObj." + secret), (String[])new String[]{entityNumber});
                entrySet.addAll(entries);
                entries = ScriptUtils.getEntries((MainEntityType)entityType, (String)(entityNumber + "_billObj." + bxdKey), (String[])new String[]{entityNumber});
                entrySet.addAll(entries);
            }
            if (entrySet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u5bf9\u5e94\u7684\u5b57\u6bb5\u53ea\u80fd\u6765\u6e90\u540c\u4e00\u4e2a\u5206\u5f55\u3002", (String)"IDIInvoiceCustomFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            CustomInvoiceParam customInvoiceParam = new CustomInvoiceParam();
            customInvoiceParam.setClientId(clientId);
            customInvoiceParam.setSecret(secret);
            customInvoiceParam.setBxdKey(bxdKey);
            String configStr = IDIJSONUtils.toJsonString((Object)customInvoiceParam);
            this.getView().returnDataToParent((Object)configStr);
            this.getView().close();
        }
    }

    protected static void openInvoiceCustomPage(AbstractFormPlugin plugin, String entityType, String config, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_IDI_INVOICECUSTOM);
        showParameter.getCustomParams().put(CustomParam_ENTITY_NUMBER, entityType);
        showParameter.getCustomParams().put(CustomParam_CONFIG, config);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        plugin.getView().showForm(showParameter);
    }
}

