/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;

public class IDIInvoiceParamConfigFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_FIELD_AMOUNTFIELD = "amountfield";
    private static final String KEY_FIELD_FROMDATEFIELD = "fromdatefield";
    private static final String KEY_FIELD_FROMDATE = "fromdate";
    private static final String KEY_NUMBERRANGE = "numberrange";
    private static final String KEY_DATE_MONTH = "datemonth";
    private static final String KEY_DATE_DAY = "dateday";
    private static final String KEY_SAVE = "save";
    private static final String KEY_PARAMETER_ENTITYNUMBER = "entitynumber";
    private static final String CHECKITEM_PARAMCONFIG = "checkitem_paramconfig";
    private static final String PARAMCONFIG_VALUE = "paramconfig_value";
    private static final String KEY_FIELD_SERIALNOFIELD = "serialnofield";
    private static final String KEY_PARAMETER__OnlyHeadField = "onlyheadfield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_DATE_MONTH, KEY_SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam(KEY_PARAMETER_ENTITYNUMBER);
        if (StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityTypeUtil helper = new EntityTypeUtil();
        String onlyHeadFieldStr = (String)fsp.getCustomParam(KEY_PARAMETER__OnlyHeadField);
        List cols = helper.getFilterColumns((IDataEntityType)entityType, Boolean.parseBoolean(onlyHeadFieldStr));
        boolean isUseInvoiceCloud = ParamFactory.getUseInvoiceCloud();
        IFormView view = this.getView();
        int rowIndex = (Integer)fsp.getCustomParam("rowIndex");
        if (6 == rowIndex) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_FIELD_AMOUNTFIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_FIELD_FROMDATEFIELD, KEY_FIELD_FROMDATE, KEY_NUMBERRANGE, KEY_DATE_MONTH, KEY_DATE_DAY, KEY_DATE_DAY});
            this.initAmountField(cols, entityNumber);
            this.getModel().setValue(KEY_FIELD_AMOUNTFIELD, fsp.getCustomParam("amountFieldName"));
        } else if (7 == rowIndex) {
            view.setVisible(Boolean.FALSE, new String[]{KEY_FIELD_AMOUNTFIELD, KEY_NUMBERRANGE});
            view.setVisible(Boolean.TRUE, new String[]{KEY_FIELD_FROMDATEFIELD, KEY_FIELD_FROMDATE, KEY_DATE_MONTH, KEY_DATE_DAY, KEY_DATE_DAY});
            this.initFromDateFieldCombo(cols, entityNumber);
            Long fromDateLong = (Long)fsp.getCustomParam(KEY_FIELD_FROMDATE);
            String fromDateField = (String)fsp.getCustomParam(KEY_FIELD_FROMDATEFIELD);
            this.changeCrossoneYear(fromDateLong, fromDateField);
        } else if (8 == rowIndex) {
            String numRangeOrField = (String)fsp.getCustomParam(KEY_NUMBERRANGE);
            if (isUseInvoiceCloud && IDIStringUtils.isInteger((String)numRangeOrField)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u6570\u201cisUseInvoiceCloud\u201d\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u7968\u636e\u68c0\u67e5\u3002", (String)"IDIInvoiceFormPlugin_18", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            if (isUseInvoiceCloud) {
                view.setVisible(Boolean.FALSE, new String[]{KEY_FIELD_AMOUNTFIELD, KEY_FIELD_FROMDATEFIELD, KEY_FIELD_FROMDATE, KEY_NUMBERRANGE});
                view.setVisible(Boolean.TRUE, new String[]{KEY_FIELD_SERIALNOFIELD});
                this.initSerialNoField(cols, entityNumber, entityType);
                this.getModel().setValue(KEY_FIELD_SERIALNOFIELD, (Object)numRangeOrField);
            } else {
                view.setVisible(Boolean.FALSE, new String[]{KEY_FIELD_AMOUNTFIELD, KEY_FIELD_FROMDATEFIELD, KEY_FIELD_FROMDATE, KEY_FIELD_SERIALNOFIELD});
                view.setVisible(Boolean.TRUE, new String[]{KEY_NUMBERRANGE});
                this.getModel().setValue(KEY_NUMBERRANGE, (Object)(StringUtils.isEmpty((String)numRangeOrField) ? "1" : numRangeOrField));
            }
        }
    }

    private void initSerialNoField(List<Map<String, Object>> cols, String entityNumber, MainEntityType entityType) {
        if (cols == null) {
            return;
        }
        Map entityTypeMap = entityType.getAllEntities();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        for (Map<String, Object> map : cols) {
            String type = (String)map.get("type");
            if (!"text".equals(type)) continue;
            list.add(this.processAllFilterField(map, entityNumber, entityTypeMap));
        }
        if (!list.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_FIELD_SERIALNOFIELD);
            comboEdit.setComboItems(list);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "save": {
                this.save();
            }
        }
    }

    private void save() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam(KEY_PARAMETER_ENTITYNUMBER);
        if (StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        String onlyHeadFieldStr = (String)fsp.getCustomParam(KEY_PARAMETER__OnlyHeadField);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entityType, Boolean.parseBoolean(onlyHeadFieldStr));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String amountField = (String)this.getModel().getValue(KEY_FIELD_AMOUNTFIELD);
        String fromDateField = (String)this.getModel().getValue(KEY_FIELD_FROMDATEFIELD);
        int rowIndex = (Integer)fsp.getCustomParam("rowIndex");
        if (StringUtils.isNotEmpty((String)amountField)) {
            resultMap.put(PARAMCONFIG_VALUE, amountField);
            if (cols != null) {
                for (Map map : cols) {
                    if (!((String)map.get("fieldName")).equalsIgnoreCase(amountField)) continue;
                    resultMap.put(CHECKITEM_PARAMCONFIG, map.get("fieldCaption"));
                    break;
                }
            }
        } else if (StringUtils.isNotEmpty((String)fromDateField) && this.getModel().getValue(KEY_FIELD_FROMDATE) != null) {
            HashMap<String, Object> configValueMap = new HashMap<String, Object>();
            configValueMap.put(KEY_FIELD_FROMDATEFIELD, fromDateField);
            configValueMap.put(KEY_FIELD_FROMDATE, this.getModel().getValue(KEY_FIELD_FROMDATE));
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_FIELD_FROMDATEFIELD);
            if (comboEdit != null && cols != null) {
                for (Map map : cols) {
                    if (!((String)map.get("fieldName")).equalsIgnoreCase(fromDateField)) continue;
                    resultMap.put(CHECKITEM_PARAMCONFIG, map.get("fieldCaption"));
                    resultMap.put(PARAMCONFIG_VALUE, configValueMap);
                    break;
                }
            }
        } else if (rowIndex == 8) {
            boolean isUseInvoiceCloud = ParamFactory.getUseInvoiceCloud();
            if (isUseInvoiceCloud) {
                String serialNoField = (String)this.getModel().getValue(KEY_FIELD_SERIALNOFIELD);
                if (StringUtils.isEmpty((String)serialNoField)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u661f\u6807\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u8865\u5145\u5b8c\u6574\u3002", (String)"IDIInvoiceParamConfigFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return;
                }
                ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_FIELD_SERIALNOFIELD);
                if (comboEdit != null && cols != null) {
                    Map entityTypeMap = entityType.getAllEntities();
                    for (Map map : cols) {
                        String fieldName;
                        String value = fieldName = (String)map.get("fieldName");
                        String entryEntity = (String)map.get("entryEntity");
                        if (!StringUtils.isEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
                            EntityType subEntity = (EntityType)entityTypeMap.get(entryEntity);
                            String string = value = subEntity instanceof SubEntryType ? subEntity.getParent().getName() + "." + entryEntity + "." + fieldName : entryEntity + "." + fieldName;
                        }
                        if (!value.equalsIgnoreCase(serialNoField)) continue;
                        resultMap.put(CHECKITEM_PARAMCONFIG, map.get("fieldCaption"));
                        resultMap.put(PARAMCONFIG_VALUE, serialNoField);
                        break;
                    }
                }
            } else {
                String numRange = this.getModel().getValue(KEY_NUMBERRANGE).toString();
                resultMap.put(CHECKITEM_PARAMCONFIG, String.format(ResManager.loadKDString((String)"\u8fde\u53f7\u8303\u56f4\uff1a%s", (String)"IDIInvoiceParamConfigFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]), numRange));
                resultMap.put(PARAMCONFIG_VALUE, numRange);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u661f\u6807\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u8865\u5145\u5b8c\u6574\u3002", (String)"IDIInvoiceParamConfigFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)IDIJSONUtils.toJsonString(resultMap));
        this.getView().close();
    }

    private void initAmountField(List<Map<String, Object>> cols, String entityNumber) {
        if (cols == null) {
            return;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        for (Map<String, Object> map : cols) {
            String type = (String)map.get("type");
            if (!"number".equals(type)) continue;
            list.add(this.processFilterField(map, entityNumber));
        }
        if (!list.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_FIELD_AMOUNTFIELD);
            comboEdit.setComboItems(list);
        }
    }

    private ComboItem processAllFilterField(Map<String, Object> map, String entityNumber, Map<String, EntityType> entityTypeMap) {
        String entryEntity = (String)map.get("entryEntity");
        String fieldName = (String)map.get("fieldName");
        String fieldCaption = (String)map.get("fieldCaption");
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue(fieldCaption);
        String value = fieldName;
        EntityType subEntityType = entityTypeMap.get(entryEntity);
        if (!StringUtils.isEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
            value = subEntityType instanceof SubEntryType ? subEntityType.getParent().getName() + "." + entryEntity + "." + fieldName : entryEntity + "." + fieldName;
        }
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(localeString);
        comboItem.setValue(value);
        return comboItem;
    }

    private ComboItem processFilterField(Map<String, Object> map, String entityNumber) {
        String entryEntity = (String)map.get("entryEntity");
        String fieldName = (String)map.get("fieldName");
        String fieldCaption = (String)map.get("fieldCaption");
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue(fieldCaption);
        String value = fieldName;
        if (!StringUtils.isEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
            value = entryEntity + "." + fieldName;
        }
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(localeString);
        comboItem.setValue(value);
        return comboItem;
    }

    private void initFromDateFieldCombo(List<Map<String, Object>> cols, String entityNumber) {
        if (cols == null) {
            return;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        for (Map<String, Object> map : cols) {
            String type = (String)map.get("type");
            if (!"datetime".equals(type) && !"date".equals(type)) continue;
            list.add(this.processFilterField(map, entityNumber));
        }
        if (!list.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_FIELD_FROMDATEFIELD);
            comboEdit.setComboItems(list);
        }
    }

    private void changeCrossoneYear(Long fromDateLong, String fromDateField) {
        if (fromDateLong != null) {
            this.getModel().setValue(KEY_FIELD_FROMDATE, (Object)new Date(fromDateLong));
        }
        this.getModel().setValue(KEY_FIELD_FROMDATEFIELD, (Object)fromDateField);
    }
}

