/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AlarmConfig;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.Area;
import kd.data.idi.data.BillControlTypeEnum;
import kd.data.idi.data.BillFlowConfig;
import kd.data.idi.data.BillInfo;
import kd.data.idi.data.BudgetConfig;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.FasindexConfig;
import kd.data.idi.data.GeneralLedger;
import kd.data.idi.data.GradeItem;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.InvoiceConfig;
import kd.data.idi.data.KeywordConfig;
import kd.data.idi.data.LinkUpBillConfig;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.NewsConfig;
import kd.data.idi.data.Relation;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SourceEntityType;
import kd.data.idi.data.StatisticsConfig;
import kd.data.idi.data.TimeLine;
import kd.data.idi.data.attachment.AIAttachmentConfig;
import kd.data.idi.data.attachment.AttachmentConfig;
import kd.data.idi.decision.model.ExtDecisionInfo;
import kd.data.idi.decision.service.DecisionTypeExtInfoService;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.formplugin.IDIConditionEdit;
import kd.data.idi.formplugin.IDIMoveDecisionFormPlugin;
import kd.data.idi.util.ExpressionTranslator;
import kd.data.idi.util.IDIDisclaimerUtil;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;
import kd.data.idi.util.TranFormulaHelper;

public class IDISchemaFormPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener,
SelectRowsEventListener {
    private static final String ActionId_GRADECONFIG = "gradeconfig";
    private static final String ActionId_SET_ALARM = "setAlarm";
    private static final String ActionId_SET_FUTURE = "setFuture";
    private static final String ActionId_SET_GENAL = "setGeneralLedger";
    private static final String ActionId_SET_NEWS = "setNews";
    private static final String ActionId_SET_RULE = "setRule";
    private static final String ActionId_SET_START_CONDITION = "setStartCondition";
    private static final String ActionId_SET_KEYWORD = "setKeyWord";
    private static final String ActionId_SET_INVOICE = "setInvoice";
    private static final String ActionId_SET_BUDGET = "setBudget";
    private static final String ActionId_SET_ENABLE = "setEnable";
    private static final String ActionId_SET_BILL_FLOW = "setBillFlow";
    private static final String ActionId_SET_STATISTICS = "setStatistics";
    private static final String ActionId_SET_FASINDEX = "setFasindex";
    private static final String ActionId_CHANGE_SOURCENUMBER = "CHANGE_SOURCE_NUMBER_CALLBACK";
    private static final String CustomParam_BILL_ID = "billId";
    private static final String CustomParam_BILL_NAME = "billName";
    private static final String CustomParam_DETAIL_CONFIG = "detailConfig";
    private static final String CustomParam_ENTITY_NUMBER = "entitynumber";
    private static final String CustomParam_FORMULA = "formula";
    private static final String CustomParam_FRONTEND_CONFIG = "rule_frontend_config";
    private static final String CustomParam_GRADE_LIST_CONTENT = "gradeListContent";
    private static final String CustomParam_ISCOPY = "iscopy";
    private static final String CustParamKey_ONLYVIEW = "onlyview";
    private static final String CustomParam_MATCH_BILL = "matchBill";
    private static final String CustomParam_SHOW_WITHOUTLUB = "isShowWithoutLUB_config";
    private static final String FormId_IDI_ALARM_CONFIG = "idi_alarm_config";
    private static final String FormId_IDI_CONDITION_CONFIG = "idi_condition_config";
    private static final String FormId_IDI_CONDITION_EDIT = "idi_condition_edit";
    private static final String FormId_IDI_FUTURE = "idi_future_config";
    private static final String FormId_IDI_GENERAL_LEDGER = "idi_general_ledger_config";
    private static final String FormId_IDI_GRADE_CONFIG_FORM = "idi_grade_config_form";
    private static final String FormId_IDI_NEWS_CONFIG = "idi_news_config";
    private static final String FormId_IDI_KEYWORD_CONFIG = "idi_keyword_config";
    private static final String FormId_IDI_INVOICE_CONFIG = "idi_invoice_config";
    private static final String FormId_IDI_BUDGET_CONFIG = "idi_budget_config";
    private static final String FormId_IDI_BILLFLOW_CONFIG = "idi_billflow_config";
    private static final String FormId_IDI_STATISTICS_CONFIG = "idi_statistics_config";
    private static final String FormId_IDI_FASINDEX_CONFIG = "idi_fasindex_config";
    private static final String Key_ANALYSIS_MODE = "analysis_mode";
    private static final String Key_BAR_C = "bar_c";
    private static final String Key_BAR_MAIN = "bar_main";
    private static final String Key_BILL_ID = "bill_id";
    private static final String Key_BTNSAVE = "btnsave";
    private static final String Key_CREATETIME = "createtime";
    private static final String Key_CREATOR = "creator";
    private static final String Key_C_BTNADD = "c_btnadd";
    private static final String Key_C_DECISION_JSON = "c_decision_json";
    private static final String Key_C_ID = "c_id";
    private static final String Key_C_NAME = "c_name";
    private static final String Key_C_PANEL = "c_panel";
    private static final String Key_DECISIONREMARK = "decisionremark";
    private static final String Key_IS_ENABLE = "is_enable";
    private static final String Key_DESC = "desc";
    private static final String Key_MULTIDESC = "multidesc";
    private static final String Key_D_BTNADD = "d_btnadd";
    private static final String Key_D_NAME = "d_name";
    private static final String Key_D_REMARKS = "d_remarks";
    private static final String Key_D_MULTIREMARKS = "d_multiremarks";
    private static final String Key_D_SELECTED_CATEGORY = "d_selected_category";
    private static final String Key_ENABLE = "enable";
    private static final String Key_FRONTEND_CONFIG = "frontendconfig";
    private static final String Key_GRADECONFIG = "gradeconfig";
    private static final String Key_GRADECONFIGJSON = "gradeconfigjson";
    private static final String Key_ISSHOW_SWITCH = "isshow_switch";
    private static final String Key_MATCH_BILL = "match_bill";
    private static final String Key_NAME = "name";
    private static final String Key_NUMBER = "number";
    private static final String Key_RULE_TAG = "rule_tag";
    private static final String Key_SOURCEENTITYNUMBER = "sourceentitynumber";
    private static final String Key_START_CONDITION = "start_condition";
    private static final String Key_START_CONDITION_JSON = "start_condition_json";
    private static final String Key_STATUS = "status";
    private static final String Key_ORDER = "order";
    private static final String Key_ISPRESET = "ispreset";
    private static final String Key_HIGHLIGHT = "highlight";
    private static final String CLOSED_CALLBACK_DISCLAIMER = "closedCallbackDisclaimer";
    private static final String Key_D_START_CONDITION = "d_start_condition";
    private static final String Key_D_START_CONDITIONDISPLAY = "d_start_conditiondisplay";
    private static final String CustomParam_D_START_CONDITION_JSON = "startConditionJson";
    private static final String Key_PAGE_KEYWORDMODIFY = "keyword_modify";
    private static final String Key_LINKUPBILLCONFIG_JSON = "linkupbillconfig_json";
    private static final String CustomParam_LINKUPBILLCONFIG = "linkupbillconfig";
    private static final String CustomParam_CONFIG = "config";
    private static final String CustomParam_BILLTYPE = "billType";
    private static final String[] PROPS_ARRAY = new String[]{"sourceentitynumber", "enable", "desc", "analysis_mode", "order", "ispreset", "highlight"};
    private static final String[] PROPS_2_ARRAY = new String[]{"number", "name", "sourceentitynumber", "desc", "enable", "analysis_mode", "order", "ispreset", "highlight", "multidesc"};
    private static final String CustomParam_ANALYSISMODE = "analysisModel";
    private static final String FORMID_IDI_CHECKATTACHMENT = "idi_checkattachment";
    private static final Log logger = LogFactory.getLog(IDISchemaFormPlugin.class);
    private static final DecisionTypeExtInfoService decisionExtInfoService = new DecisionTypeExtInfoService();
    private static final ThreadLocal<HashSet<String>> decisionTypeSetTL = new ThreadLocal();
    private static final String KEY_C_DECISIONCOUNT = "decisioncount";
    private static final String ACTIONID_SET_MOVEDECISION = "movedecision";
    private static final String KEY_C_DECIISONSCRIPT = "deciisonscript";
    private static final String KEY_C_AREASTARTCONDITION = "areastartcondition";
    private static final String KEY_C_AREASTARTCONDITION_JSON = "areastartconditionjson";
    private static final String CustParamKey_OnlyHeadField = "onlyheadfield";
    private static final String ActionId_SET_AREACONDITION = "setAreaStartCondition";
    private static final String ActionId_SET_DECISIONCONDITION = "setDecisionStartCondition";
    private static final String ActionId_SET_CHECKAIATTACHEMNT = "setCheckAIAttachemnt";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{Key_BAR_MAIN, Key_BAR_C, "bar_d"});
        EntryGrid categoryPanel = (EntryGrid)this.getView().getControl(Key_C_PANEL);
        categoryPanel.addSelectRowsListener((SelectRowsEventListener)this);
        this.getModel().addDataModelChangeListener((IDataModelChangeListener)this);
        this.addClickListeners(new String[]{"detailconfig", "gradeconfig", Key_START_CONDITION, KEY_C_AREASTARTCONDITION, Key_D_START_CONDITIONDISPLAY});
        EntryGrid decisionPanel = (EntryGrid)this.getView().getControl("d_panel");
        decisionPanel.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        block19: {
            int index;
            block17: {
                block18: {
                    MainEntityType billType;
                    DynamicObject idiSchema;
                    super.afterCreateNewData(e);
                    Long billId = (Long)this.getView().getFormShowParameter().getCustomParam(CustomParam_BILL_ID);
                    if (billId == null) break block17;
                    Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam(CustomParam_ISCOPY);
                    if (isCopy == null) {
                        isCopy = Boolean.FALSE;
                    }
                    if ((idiSchema = BusinessDataServiceHelper.loadSingle((Object)billId, (DynamicObjectType)(billType = EntityMetadataCache.getDataEntityType((String)"idi_schema")))) == null) break block18;
                    if (isCopy.booleanValue()) {
                        String[] copyStr = ResManager.loadKDString((String)"(\u590d\u5236)", (String)"IDISchemaFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]);
                        Object o = idiSchema.get(Key_NAME);
                        if (o instanceof ILocaleString) {
                            ILocaleString name = (ILocaleString)o;
                            name.setLocaleValue(name.getLocaleValue() + (String)copyStr);
                            this.getModel().setValue(Key_NAME, (Object)name);
                        } else {
                            this.getModel().setValue(Key_NAME, (Object)(o + (String)copyStr));
                        }
                    } else {
                        this.checkSchemaMutex(billId);
                        this.getModel().setValue(Key_BILL_ID, (Object)billId);
                        for (String prop : new String[]{Key_NUMBER, Key_NAME}) {
                            this.getModel().setValue(prop, idiSchema.get(prop));
                        }
                    }
                    for (String prop : PROPS_ARRAY) {
                        this.getModel().setValue(prop, idiSchema.get(prop));
                        if (!Key_ISPRESET.equals(prop) || !isCopy.booleanValue()) continue;
                        this.getModel().setValue(Key_ISPRESET, (Object)Boolean.FALSE);
                    }
                    String multiDesc = idiSchema.getString(Key_MULTIDESC);
                    this.getModel().setValue(Key_MULTIDESC, StringUtils.isNotEmpty((String)multiDesc) ? idiSchema.getLocaleString(Key_MULTIDESC) : new LocaleString(Lang.zh_CN.toString(), idiSchema.getString(Key_DESC)));
                    String ruleJson = idiSchema.getString(Key_RULE_TAG);
                    if (StringUtils.isBlank((String)ruleJson)) break block19;
                    this.getModel().deleteEntryData(Key_C_PANEL);
                    this.getModel().deleteEntryData("d_panel");
                    Schema schema = (Schema)IDIJSONUtils.cast((String)ruleJson, Schema.class);
                    List<Area> areaList = schema.getArea();
                    List gradeItemList = schema.getGrade();
                    if (areaList == null) {
                        areaList = Collections.emptyList();
                    }
                    if (gradeItemList == null || gradeItemList.isEmpty()) {
                        gradeItemList = Collections.emptyList();
                        this.getModel().setValue("gradeconfig", null);
                    } else {
                        this.getModel().setValue("gradeconfig", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    }
                    this.getModel().setValue(Key_GRADECONFIGJSON, (Object)IDIJSONUtils.toJsonString(gradeItemList));
                    if (schema.getStartCondition() != null) {
                        this.getModel().setValue(Key_START_CONDITION_JSON, (Object)IDIJSONUtils.toJsonString((Object)schema.getStartCondition()));
                        this.getModel().setValue(Key_START_CONDITION, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDISchemaFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), this.getExprDesc(schema.getStartCondition())));
                    }
                    for (Area area : areaList) {
                        int row = this.getModel().createNewEntryRow(Key_C_PANEL);
                        this.getModel().setValue(Key_C_ID, (Object)(StringUtils.isEmpty((String)area.getPk()) ? Uuid16.create().toString() : area.getPk()), row);
                        this.getModel().setValue(Key_C_NAME, (Object)area.getLocaleTitle(), row);
                        List decisionList = area.getDecision();
                        this.getModel().setValue(Key_C_DECISION_JSON, (Object)IDIJSONUtils.toJsonString((Object)decisionList), row);
                        this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)(CollectionUtils.isNotEmpty((Collection)decisionList) ? decisionList.size() : 0), row);
                        IDICondition areaStartCondition = area.getStartCondition();
                        if (areaStartCondition == null) continue;
                        this.getModel().setValue(KEY_C_AREASTARTCONDITION, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDISchemaFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), areaStartCondition.getExprTran()), row);
                        this.getModel().setValue(KEY_C_AREASTARTCONDITION_JSON, (Object)IDIJSONUtils.toJsonString((Object)areaStartCondition), row);
                    }
                    if (!areaList.isEmpty()) {
                        this.updateDecisionPanel(0);
                    }
                    if (!AnalysisMode.NOSCORE.getType().equals(schema.getAnalysisMode())) break block19;
                    this.getView().setVisible(Boolean.FALSE, new String[]{Key_DECISIONREMARK});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"gradeconfig"});
                    break block19;
                }
                int rowCount = this.getModel().getEntryRowCount(Key_C_PANEL);
                for (int index2 = 0; index2 < rowCount; ++index2) {
                    this.getModel().setValue(Key_C_ID, (Object)Uuid16.create().toString(), index2);
                }
                rowCount = this.getModel().getEntryRowCount("d_panel");
                for (int index2 = 0; index2 < rowCount; ++index2) {
                    this.getModel().setValue("d_id", (Object)Uuid16.create().toString(), index2);
                }
                break block19;
            }
            int rowCount = this.getModel().getEntryRowCount(Key_C_PANEL);
            for (index = 0; index < rowCount; ++index) {
                this.getModel().setValue(Key_C_ID, (Object)Uuid16.create().toString(), index);
            }
            rowCount = this.getModel().getEntryRowCount("d_panel");
            for (index = 0; index < rowCount; ++index) {
                this.getModel().setValue("d_id", (Object)Uuid16.create().toString(), index);
            }
        }
    }

    private void checkSchemaMutex(Long billId) {
        Boolean onlyView = (Boolean)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ONLYVIEW);
        if (onlyView == null || !onlyView.booleanValue()) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put("MUTEX_ENTITY_KEY", "idi_schema");
            pageCache.put("MUTEX_OBJ_ID", String.valueOf(billId));
            pageCache.put("MUTEX_OPER_KEY", "modify");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{Key_BTNSAVE});
        }
    }

    private String getExprDesc(IDICondition condition) {
        String handDesc = "";
        if (condition != null && StringUtils.isEmpty((String)(handDesc = condition.getDescription().toString()))) {
            handDesc = StringUtils.isNotEmpty((String)condition.getExprTran()) ? condition.getExprTran() : condition.getExpression();
        }
        return handDesc;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.refreshMatchTypeCombo();
    }

    public void afterBindData(EventObject e) {
        DynamicObject sourceNumberObj;
        int rowCount;
        Object isPreset;
        super.afterBindData(e);
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam(CustomParam_ISCOPY);
        if ((isCopy == null || !isCopy.booleanValue()) && (isPreset = this.getModel().getValue(Key_ISPRESET)) != null && ((Boolean)isPreset).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{Key_BTNSAVE});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u68c0\u67e5\u65b9\u6848\u4e0d\u5141\u8bb8\u4fee\u6539\u3002\u5982\u9700\u4fee\u6539\uff0c\u8bf7\u5148\u590d\u5236\u68c0\u67e5\u65b9\u6848\u3002", (String)"IDISchemaFormPlugin_31", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
        if ((rowCount = this.getModel().getEntryRowCount(Key_C_PANEL)) > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(Key_C_PANEL);
            entryGrid.selectRows(0);
        }
        if ((sourceNumberObj = this.getModel().getDataEntity().getDynamicObject(Key_SOURCEENTITYNUMBER)) != null) {
            this.getPageCache().put(Key_SOURCEENTITYNUMBER, (String)sourceNumberObj.getPkValue());
        }
        try {
            BillEntityType sourceBill = this.getSourceBillType();
            String conditionJson = (String)this.getModel().getValue(Key_START_CONDITION_JSON);
            if (StringUtils.isNotEmpty((String)conditionJson) && sourceBill != null) {
                IDICondition formulaObj = TranFormulaHelper.deserialize((String)conditionJson);
                IDICondition idiCondition = TranFormulaHelper.tranFormula((IDICondition)formulaObj, (String)sourceBill.getName(), (FormShowParameter)new FormShowParameter());
                this.getModel().setValue(Key_START_CONDITION, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDISchemaFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), this.getExprDesc(idiCondition)));
                this.getView().updateView("fieldsetpanelap");
            }
        }
        catch (Exception ignore) {
            SchemaExecutorLogger.info((String)("IDI multi-language exception" + Arrays.toString(ignore.getStackTrace())), (Object[])new Object[0]);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey = ((FormOperate)e.getSource()).getOperateKey();
        if ("copyentryrow".equalsIgnoreCase(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("d_panel");
            int[] selectIndexes = entryGrid.getSelectRows();
            int decisionCountLimit = ParamFactory.getNumbClassification();
            int dRowCount = this.getModel().getEntryRowCount("d_panel");
            if (selectIndexes != null && selectIndexes.length > 0 && decisionCountLimit < dRowCount + selectIndexes.length) {
                String errorMesg = ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u201c%1$s\u201d\u5206\u7c7b\u6700\u591a\u652f\u6301\u914d\u7f6e%2$s\u4e2a\u68c0\u67e5\u9879\u3002", (String)"IDISchemaFormPlugin_33", (String)"data-idi-formplugin", (Object[])new Object[0]);
                int cIndex = this.getModel().getEntryCurrentRowIndex(Key_C_PANEL);
                String areaName = this.getModel().getValue(Key_C_NAME, cIndex).toString();
                String msg = String.format(errorMesg, areaName, decisionCountLimit);
                this.getView().showTipNotification(msg);
                e.setCancel(true);
            }
        } else if ("newentry".equalsIgnoreCase(operateKey)) {
            int decisionCountLimit = ParamFactory.getNumbClassification();
            int dRowCount = this.getModel().getEntryRowCount("d_panel");
            if (dRowCount >= decisionCountLimit) {
                String errorMesg = ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff0c\u201c%1$s\u201d\u5206\u7c7b\u6700\u591a\u652f\u6301\u914d\u7f6e%2$s\u4e2a\u68c0\u67e5\u9879\u3002", (String)"IDISchemaFormPlugin_34", (String)"data-idi-formplugin", (Object[])new Object[0]);
                int cIndex = this.getModel().getEntryCurrentRowIndex(Key_C_PANEL);
                String areaName = this.getModel().getValue(Key_C_NAME, cIndex).toString();
                String msg = String.format(errorMesg, areaName, decisionCountLimit);
                this.getView().showTipNotification(msg);
                e.setCancel(true);
            }
        } else if ("move".equalsIgnoreCase(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("d_panel");
            int[] selectIndexes = entryGrid.getSelectRows();
            if (selectIndexes == null || selectIndexes.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u68c0\u67e5\u9879\u201d\u3002", (String)"IDISchemaFormPlugin_32", (String)"data-idi-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            IDIMoveDecisionFormPlugin.openF7(this, ACTIONID_SET_MOVEDECISION);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        int dRowCount;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("copyentryrow".equalsIgnoreCase(operateKey)) {
            dRowCount = this.getModel().getEntryRowCount("d_panel");
            EntryGrid entryGrid = (EntryGrid)this.getControl("d_panel");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null) {
                int rowIndex = dRowCount - 1;
                String matchType = (String)this.getModel().getValue("match_type", rowIndex);
                this.setEnable(matchType, rowIndex);
                this.getModel().setValue("d_id", (Object)Uuid16.create().toString(), rowIndex);
                this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)dRowCount);
            } else {
                for (int i = 1; i <= selectRows.length; ++i) {
                    int rowIndex = dRowCount - i;
                    String matchType = (String)this.getModel().getValue("match_type", rowIndex);
                    this.setEnable(matchType, rowIndex);
                    this.getModel().setValue("d_id", (Object)Uuid16.create().toString(), rowIndex);
                    this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)dRowCount);
                }
            }
        } else if ("c_deleteentry".equals(operateKey)) {
            this.updateDecisionPanel();
        } else if ("newentry".equalsIgnoreCase(operateKey)) {
            dRowCount = this.getModel().getEntryRowCount("d_panel");
            int rowIndex = dRowCount - 1;
            this.getModel().setValue("d_id", (Object)Uuid16.create().toString(), rowIndex);
            this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)dRowCount);
        } else if ("d_deleteentry".equalsIgnoreCase(operateKey)) {
            dRowCount = this.getModel().getEntryRowCount("d_panel");
            this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)dRowCount);
        }
        if ("copyentryrow".equalsIgnoreCase(operateKey) || "newentry".equalsIgnoreCase(operateKey) || "d_deleteentry".equalsIgnoreCase(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("d_panel");
            int[] selectRows = entryGrid.getSelectRows();
            this.setDecisionSelect(selectRows == null ? 0 : selectRows.length);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "setRule": {
                this.dealRuleReturnData(returnData);
                break;
            }
            case "setFuture": {
                this.dealFutureData(returnData);
                break;
            }
            case "setStatistics": 
            case "setAlarm": 
            case "setNews": 
            case "setGeneralLedger": 
            case "setInvoice": 
            case "setBudget": 
            case "setBillFlow": 
            case "setFasindex": {
                this.dealReturnData(returnData);
                break;
            }
            case "setKeyWord": {
                this.dealKeyWordData(returnData);
                break;
            }
            case "gradeconfig": {
                this.dealReturnGradeConfig(returnData);
                break;
            }
            case "setStartCondition": {
                this.dealReturnStartCondition(returnData);
                break;
            }
            case "closedCallbackDisclaimer": {
                if (Boolean.parseBoolean(returnData)) {
                    this.save();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u63a5\u53d7\u514d\u8d23\u58f0\u660e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u65b0\u95fb\u7c7b\u68c0\u67e5\u9879\u3002", (String)"IDISchemaFormPlugin_22", (String)"data-idi-formplugin", (Object[])new Object[0]));
                break;
            }
            case "idi_checkattachment": 
            case "setCheckAIAttachemnt": {
                this.dealAttachmentReturnData(returnData);
                break;
            }
            case "movedecision": {
                this.dealMoveDecision(returnData);
                break;
            }
            case "setAreaStartCondition": {
                this.dealAreaStartCondition(returnData);
                break;
            }
            case "setDecisionStartCondition": {
                this.dealDecisionStartCondition(returnData);
                break;
            }
        }
    }

    private void dealMoveDecision(String result) {
        if (StringUtils.isNotEmpty((String)result)) {
            int currentEntryIndex = this.getModel().getEntryCurrentRowIndex(Key_C_PANEL);
            int rowCount = this.getModel().getEntryRowCount(Key_C_PANEL);
            for (int i = 0; i < rowCount; ++i) {
                String areaId;
                if (i == currentEntryIndex || !result.equalsIgnoreCase(areaId = (String)this.getModel().getValue(Key_C_ID, i))) continue;
                EntryGrid entryGrid = (EntryGrid)this.getControl("d_panel");
                int[] selectIndexes = entryGrid.getSelectRows();
                String tartDecisionListStr = (String)this.getModel().getValue(Key_C_DECISION_JSON, i);
                List<Decision> tartDecisionList = StringUtils.isEmpty((String)tartDecisionListStr) ? new ArrayList(2) : IDIJSONUtils.jsonCastToList((String)tartDecisionListStr, Decision.class);
                DynamicObjectCollection decisionData = this.getModel().getEntryEntity("d_panel");
                for (int selectIndex : selectIndexes) {
                    DynamicObject data = (DynamicObject)decisionData.get(selectIndex);
                    Decision decision = this.createDecision(data);
                    tartDecisionList.add(decision);
                }
                this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)tartDecisionList.size(), i);
                int oldCount = (Integer)this.getModel().getValue(KEY_C_DECISIONCOUNT, currentEntryIndex);
                this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)(oldCount - selectIndexes.length), currentEntryIndex);
                this.getModel().setValue(Key_C_DECISION_JSON, (Object)IDIJSONUtils.toJsonString(tartDecisionList), i);
                this.getModel().deleteEntryRows("d_panel", selectIndexes);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u6210\u529f\u3002", (String)"IDISchemaFormPlugin_36", (String)"data-idi-formplugin", (Object[])new Object[0]));
                int[] newSelRow = entryGrid.getSelectRows();
                this.setDecisionSelect(newSelRow == null ? 0 : newSelRow.length);
                break;
            }
        }
    }

    private void dealFutureData(String result) {
        int currentEntryRow = this.getModel().getEntryCurrentRowIndex("d_panel");
        if (StringUtils.isNotEmpty((String)result)) {
            Map config = (Map)IDIJSONUtils.cast((String)result, Map.class);
            this.getModel().setValue("detailconfig_json", (Object)IDIJSONUtils.toJsonString(config.get(CustomParam_CONFIG)), currentEntryRow);
            this.getModel().setValue("detailconfig", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]), currentEntryRow);
            Object confVal = config.get(CustomParam_BILLTYPE);
            if (confVal != null) {
                this.getModel().setValue(Key_MATCH_BILL, confVal, currentEntryRow);
            }
        }
    }

    private void dealKeyWordData(String result) {
        int currentEntryRow = this.getModel().getEntryCurrentRowIndex("d_panel");
        if (StringUtils.isNotEmpty((String)result)) {
            this.getModel().setValue("detailconfig_json", (Object)result, currentEntryRow);
            this.getModel().setValue("detailconfig", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]), currentEntryRow);
            String billIdStr = (String)this.getModel().getValue(Key_BILL_ID);
            if (!StringUtils.isEmpty((String)billIdStr)) {
                this.getPageCache().put(Key_PAGE_KEYWORDMODIFY, "true");
            }
        }
    }

    private void dealReturnStartCondition(String conditionJson) {
        if (StringUtils.isNotEmpty((String)conditionJson)) {
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class);
            if (condition == null) {
                this.getModel().setValue(Key_START_CONDITION, (Object)"");
                this.getModel().setValue(Key_START_CONDITION_JSON, (Object)"");
            } else {
                String exprTran = this.getExprDesc(condition);
                this.getModel().setValue(Key_START_CONDITION, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDISchemaFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), exprTran));
                this.getModel().setValue(Key_START_CONDITION_JSON, (Object)conditionJson);
            }
        }
    }

    private void dealAttachmentReturnData(String result) {
        if (StringUtils.isNotEmpty((String)result)) {
            IDataModel model = this.getModel();
            int currentEntryRow = model.getEntryCurrentRowIndex("d_panel");
            model.setValue("detailconfig_json", (Object)result, currentEntryRow);
            model.setValue("detailconfig", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]), currentEntryRow);
        }
    }

    private void dealRuleReturnData(String result) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int currentEntryRow = model.getEntryCurrentRowIndex("d_panel");
        if (StringUtils.isNotEmpty((String)result)) {
            Map config = (Map)IDIJSONUtils.cast((String)result, Map.class);
            model.setValue("detailconfig_json", (Object)IDIJSONUtils.toJsonString(config.get("ruleList")), currentEntryRow);
            model.setValue(Key_FRONTEND_CONFIG, (Object)IDIJSONUtils.toJsonString(config.get("frontEndConfig")), currentEntryRow);
            model.setValue(Key_ISSHOW_SWITCH, config.get("isshowWithoutLUB"), currentEntryRow);
            model.setValue(Key_D_START_CONDITION, config.get(CustomParam_D_START_CONDITION_JSON), currentEntryRow);
            Object configVal = config.get(CustomParam_LINKUPBILLCONFIG);
            model.setValue(Key_LINKUPBILLCONFIG_JSON, (Object)(configVal != null ? IDIJSONUtils.toJsonString(configVal) : ""), currentEntryRow);
            Object matchBill = config.get(CustomParam_MATCH_BILL);
            model.setValue(Key_MATCH_BILL, matchBill, currentEntryRow);
            LinkUpBillConfig linkupbillconfig = (LinkUpBillConfig)IDIJSONUtils.cast((String)IDIJSONUtils.toJsonString(configVal), LinkUpBillConfig.class);
            Relation relation = linkupbillconfig.getRelation();
            if (Relation.SELF != relation && Relation.CUSTOM != relation) {
                model.setValue("controltype", (Object)BillControlTypeEnum.NOCONTROL.getType(), currentEntryRow);
                view.setEnable(Boolean.FALSE, currentEntryRow, new String[]{"controltype"});
            } else {
                view.setEnable(Boolean.TRUE, currentEntryRow, new String[]{"controltype"});
            }
            model.setValue("detailconfig", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]), currentEntryRow);
        }
    }

    private void dealReturnGradeConfig(String result) {
        if (StringUtils.isNotEmpty((String)result)) {
            List gradeItemList = IDIJSONUtils.jsonCastToList((String)result, GradeItem.class);
            if (gradeItemList.isEmpty()) {
                this.getModel().setValue(Key_GRADECONFIGJSON, null);
                this.getModel().setValue("gradeconfig", null);
            } else {
                this.getModel().setValue(Key_GRADECONFIGJSON, (Object)result);
                this.getModel().setValue("gradeconfig", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void dealReturnData(String result) {
        int currentEntryRow = this.getModel().getEntryCurrentRowIndex("d_panel");
        if (StringUtils.isNotEmpty((String)result)) {
            this.getModel().setValue("detailconfig_json", (Object)result, currentEntryRow);
            this.getModel().setValue("detailconfig", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]), currentEntryRow);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "c_btnadd": {
                BillEntityType billEntityType = this.getSourceBillType();
                if (billEntityType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6e90\u5355\u201d\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"IDISchemaFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return;
                }
                int row = this.getModel().createNewEntryRow(Key_C_PANEL);
                this.getModel().setValue(Key_C_DECISION_JSON, (Object)"", row);
                this.getModel().setValue(Key_C_ID, (Object)Uuid16.create().toString(), row);
                break;
            }
            case "btnsave": {
                this.save();
                break;
            }
        }
    }

    private boolean preSaveVerity() {
        String msg;
        int totalMark = 0;
        DynamicObjectCollection collection = this.getModel().getEntryEntity(Key_C_PANEL);
        HashSet<String> decisionTypeNums = new HashSet<String>(16);
        boolean hasMarkItem = false;
        int i = 0;
        int numbAll = ParamFactory.getNumbAll();
        int numbClassification = ParamFactory.getNumbClassification();
        HashMap<String, Integer> areaOverLimitMap = new HashMap<String, Integer>(collection.size());
        ArrayList<Integer> list = new ArrayList<Integer>(collection.size());
        int count = 0;
        boolean hasDecision = false;
        boolean schemaHasEnableDecision = false;
        for (DynamicObject obj : collection) {
            String areaName = obj.getLocaleString(Key_C_NAME).toString();
            boolean areaNameEmpty = StringUtils.isEmpty((String)areaName);
            boolean decisionEmpty = false;
            boolean decisionNotIntegrity = false;
            String decisionName = null;
            String decisionJson = obj.getString(Key_C_DECISION_JSON);
            if (StringUtils.isNotEmpty((String)decisionJson)) {
                DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(Key_SOURCEENTITYNUMBER);
                String pkValue = (String)dynamicObject.getPkValue();
                boolean supportLogisticsInformation = true;
                SourceEntityType sourceEntityType = SourceEntityType.convertFromSourceEntityType((String)pkValue);
                List decisionList = IDIJSONUtils.jsonCastToList((String)decisionJson, Decision.class);
                int total = 0;
                if (decisionList != null && !decisionList.isEmpty()) {
                    count += decisionList.size();
                    if (decisionList.size() > numbClassification) {
                        areaOverLimitMap.put(areaName, decisionList.size());
                    }
                    for (Decision decision : decisionList) {
                        if (!MatchType.containsType((String)decision.getMatchType())) {
                            ExtDecisionInfo extDecisionInfo = decisionExtInfoService.queryByMatchType(decision.getMatchType());
                            if (extDecisionInfo != null && extDecisionInfo.isEnable()) {
                                decisionTypeNums.add(extDecisionInfo.getNumber());
                            } else {
                                String errorMsgTemplate = ResManager.loadKDString((String)"\u68c0\u67e5\u9879\uff08%s\uff09\u5bf9\u5e94\u7684\u68c0\u67e5\u9879\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"IDISchemaFormPlugin_26", (String)"data-idi-formplugin", (Object[])new Object[0]);
                                this.getView().showTipNotification(String.format(errorMsgTemplate, decision.getName()));
                                return false;
                            }
                        }
                        if (decision.getMark() > 0 && !decision.isEnabled()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u88ab\u7981\u7528\u7684\u68c0\u67e5\u9879\u5360\u7528\u65b9\u6848\u5206\u6570\uff0c\u8bf7\u5c06\u68c0\u67e5\u9879\u5206\u6570\u91cd\u65b0\u5206\u914d\u540e\u518d\u4fdd\u5b58\u3002", (String)"IDISchemaFormPlugin_21", (String)"data-idi-formplugin", (Object[])new Object[0]));
                            return false;
                        }
                        if (MatchType.LINKUP_BILL.getType().equalsIgnoreCase(decision.getMatchType()) || MatchType.ALARM.getType().equalsIgnoreCase(decision.getMatchType()) || MatchType.KEYWORD.getType().equalsIgnoreCase(decision.getMatchType()) || MatchType.INVOICE.getType().equalsIgnoreCase(decision.getMatchType()) || MatchType.ATTACHMENT.getType().equalsIgnoreCase(decision.getMatchType()) || MatchType.AIATTACHMENT.getType().equalsIgnoreCase(decision.getMatchType()) || !MatchType.containsType((String)decision.getMatchType())) {
                            hasMarkItem = true;
                        }
                        if (supportLogisticsInformation && MatchType.LOGISTICSINFORMATION.getType().equalsIgnoreCase(decision.getMatchType()) && sourceEntityType == null) {
                            supportLogisticsInformation = false;
                        }
                        if (!decision.dataIntegrity() || !decision.validate()) {
                            if (decisionName == null) {
                                decisionName = decision.getName() == null ? "" : decision.getName();
                            }
                            decisionNotIntegrity = true;
                        } else {
                            hasDecision = true;
                        }
                        total += decision.getMark();
                        if (!decision.isEnabled()) continue;
                        schemaHasEnableDecision = true;
                    }
                } else {
                    decisionEmpty = true;
                }
                totalMark += total;
                if (areaNameEmpty) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5206\u7c7b\u540d\u201d\u3002", (String)"IDISchemaFormPlugin_16", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (decisionNotIntegrity) {
                    String message = ResManager.loadKDString((String)"\u5206\u7c7b\u201d%1$s\u201c\u6709\u68c0\u67e5\u9879\u201c%2$s\u201d\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"IDISchemaFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(String.format(message, areaName, decisionName));
                    return false;
                }
                if (!supportLogisticsInformation) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6e90\u5355\u6682\u4e0d\u652f\u6301\u67e5\u8be2\u7269\u6d41\u4fe1\u606f\u3002", (String)"IDISchemaFormPlugin_19", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                decisionEmpty = true;
            }
            if (areaNameEmpty && decisionEmpty) {
                list.add(i);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(Key_C_PANEL);
            int[] selectRows = grid.getEntryState().getSelectedRows();
            int curIndex = selectRows.length == 1 ? selectRows[0] : -1;
            int[] delIndex = new int[list.size()];
            boolean d_delete = false;
            for (i = 0; i < list.size(); ++i) {
                delIndex[i] = (Integer)list.get(i);
                if (curIndex != delIndex[i]) continue;
                d_delete = true;
            }
            this.getModel().deleteEntryRows(Key_C_PANEL, delIndex);
            if (d_delete) {
                this.getModel().deleteEntryData("d_panel");
            }
        }
        String analysisMode = (String)this.getModel().getValue(Key_ANALYSIS_MODE);
        if (AnalysisMode.SCORE.getType().equals(analysisMode)) {
            if (hasMarkItem && totalMark > 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u603b\u5206\u5df2\u8d85\u8fc7100\u5206\uff0c\u8bf7\u91cd\u65b0\u5206\u914d\u3002", (String)"IDISchemaFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (hasMarkItem && totalMark < 100) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u603b\u5206\u4e3a%d\u5206\uff0c\u6682\u4e0d\u6ee1100\u5206\uff0c\u8bf7\u91cd\u65b0\u5206\u914d\u3002", (String)"IDISchemaFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]), totalMark));
                return false;
            }
            if (!hasMarkItem && totalMark != 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u8bc4\u5206\u9879\uff0c\u603b\u5206\u4e3a0\uff0c\u8bf7\u91cd\u65b0\u5206\u914d\u3002", (String)"IDISchemaFormPlugin_13", (String)"data-idi-formplugin", (Object[])new Object[0]), totalMark));
                return false;
            }
            String gradeConfigJson = (String)this.getModel().getValue(Key_GRADECONFIGJSON);
            if (hasMarkItem && (StringUtils.isEmpty((String)gradeConfigJson) || "[]".equals(gradeConfigJson))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u603b\u5206\u914d\u7f6e\u201d\u3002", (String)"IDISchemaFormPlugin_15", (String)"data-idi-formplugin", (Object[])new Object[0]), totalMark));
                return false;
            }
        }
        if (count > numbAll) {
            msg = ResManager.loadKDString((String)"\u65b9\u6848\u7684\u68c0\u67e5\u9879\u6570\u91cf\u4e3a%1$d\u4e2a\uff0c\u5df2\u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u6570\u91cf%2$d\u4e2a\u3002", (String)"IDISchemaFormPlugin_27", (String)"data-idi-formplugin", (Object[])new Object[0]);
            msg = String.format(msg, count, numbAll);
            this.getView().showTipNotification(msg);
            return false;
        }
        if (!areaOverLimitMap.isEmpty()) {
            boolean onlyOne = areaOverLimitMap.size() == 1;
            Set limitEntrySet = areaOverLimitMap.entrySet();
            if (onlyOne) {
                Map.Entry entry = limitEntrySet.iterator().next();
                String areaName = (String)entry.getKey();
                String msg2 = ResManager.loadKDString((String)"\u5206\u7c7b\uff08%1$s\uff09\u4e0b\u7684\u68c0\u67e5\u9879\u6570\u91cf\u4e3a%2$d\u4e2a\uff0c\u5df2\u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u6570\u91cf%3$d\u4e2a\u3002", (String)"IDISchemaFormPlugin_28", (String)"data-idi-formplugin", (Object[])new Object[0]);
                msg2 = String.format(msg2, areaName, entry.getValue(), numbClassification);
                this.getView().showTipNotification(msg2);
            } else {
                String msg3 = ResManager.loadKDString((String)"\u4ee5\u4e0b\u5206\u7c7b\u7684\u68c0\u67e5\u9879\u6570\u91cf\u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u6570\u91cf%d\u4e2a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff1a", (String)"IDISchemaFormPlugin_29", (String)"data-idi-formplugin", (Object[])new Object[0]);
                msg3 = String.format(msg3, numbClassification);
                StringBuilder sb = new StringBuilder();
                String errmsg = ResManager.loadKDString((String)"\u5206\u7c7b\uff1a%1$s\uff0c%2$d\u4e2a\uff1b", (String)"IDISchemaFormPlugin_30", (String)"data-idi-formplugin", (Object[])new Object[0]);
                for (Map.Entry stringIntegerEntry : limitEntrySet) {
                    String areaName = (String)stringIntegerEntry.getKey();
                    int num = (Integer)stringIntegerEntry.getValue();
                    String err = String.format(errmsg, areaName, num);
                    sb.append(err).append("\\r\\n");
                }
                this.getView().showMessage(msg3, sb.toString(), MessageTypes.Default);
            }
            return false;
        }
        if (!decisionTypeNums.isEmpty()) {
            decisionTypeSetTL.set(decisionTypeNums);
        }
        if (hasDecision && !schemaHasEnableDecision) {
            msg = ResManager.loadKDString((String)"\u65b9\u6848\u7684\u6240\u6709\u68c0\u67e5\u9879\u90fd\u88ab\u7981\u7528\uff0c\u8bf7\u81f3\u5c11\u542f\u7528\u4e00\u4e2a\u68c0\u67e5\u9879\u3002", (String)"IDISchemaFormPlugin_35", (String)"data-idi-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void save() {
        OperationResult opResult;
        DynamicObject idiSchema;
        boolean exists;
        this.saveDecisionToCategory();
        if (!this.preSaveVerity()) {
            return;
        }
        String number = (String)this.getModel().getValue(Key_NUMBER);
        String billIdStr = (String)this.getModel().getValue(Key_BILL_ID);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(Key_NUMBER, "=", (Object)number));
        if (StringUtils.isNotEmpty((String)billIdStr)) {
            filters.add(new QFilter("id", "!=", (Object)Long.valueOf(billIdStr)));
        }
        if (exists = QueryServiceHelper.exists((String)"idi_schema", (QFilter[])filters.toArray(new QFilter[0]))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u65b9\u6848\u7f16\u53f7\u201d\u91cd\u590d\u3002", (String)"IDISchemaFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        RequestContext requestContext = RequestContext.get();
        if (StringUtils.isBlank((String)billIdStr)) {
            idiSchema = BusinessDataServiceHelper.newDynamicObject((String)"idi_schema");
            idiSchema.set(Key_STATUS, (Object)BillStatus.C);
            idiSchema.set(Key_CREATOR, (Object)requestContext.getCurrUserId());
            idiSchema.set(Key_CREATETIME, (Object)new Date());
            this.getModel().setValue(Key_ENABLE, (Object)"0");
            long[] lArray = DBServiceHelper.genLongIds((String)"idi_schema", (int)1);
            idiSchema.set("id", (Object)lArray[0]);
        } else {
            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])new Object[]{Long.valueOf(billIdStr)}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"idi_schema"));
            if (dynamicObjectArray == null || dynamicObjectArray.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u65b9\u6848\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"IDISchemaFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            idiSchema = dynamicObjectArray[0];
            idiSchema.set(Key_STATUS, (Object)BillStatus.C);
        }
        for (String string : PROPS_2_ARRAY) {
            Object val = this.getModel().getValue(string);
            if (val instanceof Boolean) {
                val = (Boolean)val != false ? 1 : 0;
            }
            idiSchema.set(string, val);
        }
        idiSchema.set(Key_DESC, (Object)"");
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(Key_C_PANEL);
        Schema schemaData = new Schema();
        schemaData.setAnalysisMode((String)this.getModel().getValue(Key_ANALYSIS_MODE));
        schemaData.setHighLight(((Boolean)this.getModel().getValue(Key_HIGHLIGHT)).booleanValue());
        ArrayList<Area> areaList = new ArrayList<Area>();
        boolean bl = false;
        for (DynamicObject data : dynamicObjectCollection) {
            void var10_18;
            Area area = new Area();
            area.setLocaleTitle(IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)data.getLocaleString(Key_C_NAME))));
            String decisionJson = data.getString(Key_C_DECISION_JSON);
            if (!StringUtils.isEmpty((String)decisionJson)) {
                List decisionList = IDIJSONUtils.jsonCastToList((String)decisionJson, Decision.class);
                area.setDecision(decisionList);
                this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)(CollectionUtils.isNotEmpty((Collection)decisionList) ? decisionList.size() : 0), (int)var10_18);
            } else {
                this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)0, (int)var10_18);
            }
            area.setPk(data.getString(Key_C_ID));
            String conditionJson = data.getString(KEY_C_AREASTARTCONDITION_JSON);
            if (!StringUtils.isEmpty((String)conditionJson)) {
                IDICondition areaStartCondition = (IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class);
                area.setStartCondition(areaStartCondition);
            }
            areaList.add(area);
            ++var10_18;
        }
        schemaData.setArea(areaList);
        List gradeItemList = null;
        String gradeConfigJson = (String)this.getModel().getValue(Key_GRADECONFIGJSON);
        if (StringUtils.isNotEmpty((String)gradeConfigJson)) {
            gradeItemList = IDIJSONUtils.jsonCastToList((String)gradeConfigJson, GradeItem.class);
        }
        schemaData.setGrade(gradeItemList);
        IDICondition startCondition = null;
        String startConditionJson = (String)this.getModel().getValue(Key_START_CONDITION_JSON);
        if (StringUtils.isNotEmpty((String)startConditionJson)) {
            startCondition = (IDICondition)IDIJSONUtils.cast((String)startConditionJson, IDICondition.class);
        }
        schemaData.setStartCondition(startCondition);
        String ruleJson = IDIJSONUtils.toJsonString((Object)schemaData);
        if (IDIDisclaimerUtil.isNewsAndEnabled((String)ruleJson) && !IDIDisclaimerUtil.disclaimerStatus()) {
            IDIDisclaimerUtil.showDisclaimer((IFormView)this.getView(), (AbstractFormPlugin)this);
            return;
        }
        idiSchema.set(Key_RULE_TAG, (Object)ruleJson);
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        HashSet<String> decisionTypeNums = decisionTypeSetTL.get();
        if (decisionTypeNums != null) {
            decisionTypeSetTL.remove();
            operateOption.setVariableValue(idiSchema.getString(Key_NUMBER) + ".decisionTypeNums", SerializationUtils.toJsonString(decisionTypeNums));
        }
        if ((opResult = operationService.localInvokeOperation("save", new DynamicObject[]{idiSchema}, operateOption)).isSuccess()) {
            this.getModel().setValue(Key_BILL_ID, idiSchema.getPkValue());
            this.notifyListViewChanged();
            this.getView().getModel().setDataChanged(false);
            long userId = Long.parseLong(RequestContext.get().getUserId());
            if ("0".equalsIgnoreCase(idiSchema.getString(Key_ENABLE)) && PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"idi", (String)"idi_schema", (String)"4730fc5d000000ac")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u9a6c\u4e0a\u542f\u7528\uff1f", (String)"IDISchemaFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ActionId_SET_ENABLE, this.getPluginName()), null, String.valueOf(idiSchema.getPkValue()));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"IDISchemaFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showOperationResult(opResult);
        }
    }

    private void notifyListViewChanged() {
        IFormView pView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (pView instanceof IListView) {
            IPageCache pageCache = (IPageCache)pView.getService(IPageCache.class);
            pageCache.put("listdatachanged", "1");
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "detailconfig": {
                int currentRow = this.getModel().getEntryCurrentRowIndex("d_panel");
                String matchType = (String)this.getModel().getValue("match_type", currentRow);
                if (StringUtils.isEmpty((String)matchType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u68c0\u67e5\u9879\u7c7b\u578b\u201d\u3002", (String)"IDISchemaFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillEntityType sourceBill = this.getSourceBillType();
                if (sourceBill == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6e90\u5355\u201d\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"IDISchemaFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillEntityType matchBill = this.getMatchBillType(currentRow);
                if (MatchType.NEWS.getType().equalsIgnoreCase(matchType)) {
                    this.showNewsForm(sourceBill);
                    break;
                }
                if (MatchType.ALARM.getType().equalsIgnoreCase(matchType)) {
                    this.showAlarmForm(sourceBill);
                    break;
                }
                if (MatchType.GENERALLEDGER.getType().equalsIgnoreCase(matchType)) {
                    this.showGeneralLedger(sourceBill);
                    break;
                }
                if (MatchType.FUTURE.getType().equalsIgnoreCase(matchType)) {
                    this.showFutureForm(matchBill);
                    break;
                }
                if (MatchType.KEYWORD.getType().equalsIgnoreCase(matchType)) {
                    this.showKeyWordForm(sourceBill);
                    break;
                }
                if (MatchType.INVOICE.getType().equalsIgnoreCase(matchType)) {
                    this.showInvoiceForm(sourceBill);
                    break;
                }
                if (MatchType.BUDGET.getType().equalsIgnoreCase(matchType)) {
                    this.showBudgetForm(sourceBill);
                    break;
                }
                if (MatchType.BILLFLOW.getType().equalsIgnoreCase(matchType)) {
                    this.showBillflowKeyNodeForm(sourceBill);
                    break;
                }
                if (MatchType.LOGISTICSINFORMATION.getType().equalsIgnoreCase(matchType)) break;
                if (MatchType.STATISTICS.getType().equalsIgnoreCase(matchType)) {
                    this.showStatisticsForm(sourceBill);
                    break;
                }
                if (MatchType.FASINDEX.getType().equalsIgnoreCase(matchType)) {
                    this.showFasindexForm(sourceBill);
                    break;
                }
                if (MatchType.ATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                    this.showCheckAttachment(sourceBill);
                    break;
                }
                if (MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                    this.showCheckAIAttachment(sourceBill);
                    break;
                }
                if (!MatchType.containsType((String)matchType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u68c0\u67e5\u9879\u7c7b\u578b\u4e0d\u652f\u6301\u8be6\u60c5\u914d\u7f6e\u3002", (String)"IDISchemaFormPlugin_25", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showRuleForm(matchBill, sourceBill);
                break;
            }
            case "gradeconfig": {
                this.showGradeForm();
                break;
            }
            case "start_condition": {
                this.showStartConditionForm();
                break;
            }
            case "areastartcondition": {
                this.showAreaStartCondition();
                break;
            }
            case "d_start_conditiondisplay": {
                this.showDecisionStartCondition();
            }
        }
    }

    private void showForm(String formId, Map<String, Object> customParam, String closeCallBackActionID) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCaption(this.getConfigFormCaption(formId));
        showParameter.setCustomParams(customParam);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackActionID));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showFormAboutBillType(String formId, String closeCallBackActionID, BillEntityType sourceBill, boolean needAnalysisMode, boolean needBillName) {
        if (sourceBill == null) {
            return;
        }
        IDataModel model = this.getModel();
        int currentEntityRow = model.getEntryCurrentRowIndex("d_panel");
        String rules = (String)model.getValue("detailconfig_json", currentEntityRow);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(CustomParam_ENTITY_NUMBER, sourceBill.getName());
        customParams.put(CustomParam_DETAIL_CONFIG, rules);
        customParams.put(Key_IS_ENABLE, model.getValue(Key_IS_ENABLE, currentEntityRow));
        if (needAnalysisMode) {
            customParams.put(Key_ANALYSIS_MODE, model.getValue(Key_ANALYSIS_MODE));
        }
        if (needBillName) {
            customParams.put(CustomParam_BILL_NAME, sourceBill.getDisplayName().toString());
        }
        this.showForm(formId, customParams, closeCallBackActionID);
    }

    private void showStatisticsForm(BillEntityType sourceBill) {
        this.showFormAboutBillType(FormId_IDI_STATISTICS_CONFIG, ActionId_SET_STATISTICS, sourceBill, false, false);
    }

    private void showFasindexForm(BillEntityType sourceBill) {
        this.showFormAboutBillType(FormId_IDI_FASINDEX_CONFIG, ActionId_SET_FASINDEX, sourceBill, false, false);
    }

    private void showStartConditionForm() {
        BillEntityType sourceBill = this.getSourceBillType();
        if (sourceBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6e90\u5355\u201d\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"IDISchemaFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String conditionJson = (String)this.getModel().getValue(Key_START_CONDITION_JSON);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(CustomParam_FORMULA, conditionJson);
        customParams.put(CustomParam_ENTITY_NUMBER, sourceBill.getName());
        this.showForm(FormId_IDI_CONDITION_EDIT, customParams, ActionId_SET_START_CONDITION);
    }

    private void showDecisionStartCondition() {
        BillEntityType sourceBill = this.getSourceBillType();
        if (sourceBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6e90\u5355\u201d\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"IDISchemaFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        int currentRow = this.getModel().getEntryCurrentRowIndex("d_panel");
        String matchType = (String)this.getModel().getValue("match_type", currentRow);
        if (StringUtils.isEmpty((String)matchType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u68c0\u67e5\u9879\u7c7b\u578b\u201d\u3002", (String)"IDISchemaFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!MatchType.containsType((String)matchType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u68c0\u67e5\u9879\u7c7b\u578b\u4e0d\u652f\u6301\u914d\u7f6e\u201c\u542f\u52a8\u6761\u4ef6\u201d\u3002", (String)"IDISchemaFormPlugin_38", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String conditionJson = (String)this.getModel().getValue(Key_D_START_CONDITION, this.getModel().getEntryCurrentRowIndex("d_panel"));
        IDIConditionEdit.openCondition(conditionJson, sourceBill.getName(), ActionId_SET_DECISIONCONDITION, this);
    }

    private void showAreaStartCondition() {
        BillEntityType sourceBill = this.getSourceBillType();
        if (sourceBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6e90\u5355\u201d\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"IDISchemaFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String conditionJson = (String)this.getModel().getValue(KEY_C_AREASTARTCONDITION_JSON, this.getModel().getEntryCurrentRowIndex(Key_C_PANEL));
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(CustomParam_FORMULA, conditionJson);
        customParams.put(CustomParam_ENTITY_NUMBER, sourceBill.getName());
        customParams.put(CustParamKey_OnlyHeadField, Boolean.TRUE.toString());
        this.showForm(FormId_IDI_CONDITION_EDIT, customParams, ActionId_SET_AREACONDITION);
    }

    private void showGradeForm() {
        String gradeConfigJson = (String)this.getModel().getValue(Key_GRADECONFIGJSON);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(CustomParam_GRADE_LIST_CONTENT, gradeConfigJson);
        this.showForm(FormId_IDI_GRADE_CONFIG_FORM, customParams, "gradeconfig");
    }

    private String getConfigFormCaption(String formId) {
        if (FormId_IDI_CONDITION_EDIT.equals(formId)) {
            return ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6", (String)"IDISchemaFormPlugin_23", (String)"data-idi-formplugin", (Object[])new Object[0]);
        }
        if (FormId_IDI_GRADE_CONFIG_FORM.equals(formId)) {
            return ResManager.loadKDString((String)"\u603b\u5206\u914d\u7f6e", (String)"IDISchemaFormPlugin_24", (String)"data-idi-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u8be6\u60c5\u914d\u7f6e", (String)"IDISchemaFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]);
    }

    private void showNewsForm(BillEntityType sourceBill) {
        this.showFormAboutBillType(FormId_IDI_NEWS_CONFIG, ActionId_SET_NEWS, sourceBill, false, true);
    }

    private void showAlarmForm(BillEntityType sourceBill) {
        this.showFormAboutBillType(FormId_IDI_ALARM_CONFIG, ActionId_SET_ALARM, sourceBill, true, false);
    }

    private void showGeneralLedger(BillEntityType sourceBill) {
        this.showFormAboutBillType(FormId_IDI_GENERAL_LEDGER, ActionId_SET_GENAL, sourceBill, false, false);
    }

    private void showFutureForm(BillEntityType matchBill) {
        int currentEntityRow = this.getModel().getEntryCurrentRowIndex("d_panel");
        String rules = (String)this.getModel().getValue("detailconfig_json", currentEntityRow);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        if (matchBill != null) {
            customParams.put(CustomParam_ENTITY_NUMBER, matchBill.getName());
        }
        customParams.put(CustomParam_DETAIL_CONFIG, rules);
        this.showForm(FormId_IDI_FUTURE, customParams, ActionId_SET_FUTURE);
    }

    private void showKeyWordForm(BillEntityType sourceBill) {
        this.showFormAboutBillType(FormId_IDI_KEYWORD_CONFIG, ActionId_SET_KEYWORD, sourceBill, false, false);
    }

    private void showInvoiceForm(BillEntityType sourceBill) {
        this.showFormAboutBillType(FormId_IDI_INVOICE_CONFIG, ActionId_SET_INVOICE, sourceBill, true, false);
    }

    private void showBillflowKeyNodeForm(BillEntityType sourceBill) {
        this.showFormAboutBillType(FormId_IDI_BILLFLOW_CONFIG, ActionId_SET_BILL_FLOW, sourceBill, false, true);
    }

    private void showBudgetForm(BillEntityType sourceBill) {
        this.showFormAboutBillType(FormId_IDI_BUDGET_CONFIG, ActionId_SET_BUDGET, sourceBill, false, false);
    }

    private void showRuleForm(BillEntityType billEntityType, BillEntityType sourceBillEntityType) {
        int currentEntityRow = this.getModel().getEntryCurrentRowIndex("d_panel");
        String rules = (String)this.getModel().getValue("detailconfig_json", currentEntityRow);
        String frontEndConfig = (String)this.getModel().getValue(Key_FRONTEND_CONFIG, currentEntityRow);
        String isShowWithoutLUB = (String)this.getModel().getValue(Key_ISSHOW_SWITCH, currentEntityRow);
        String linkupBillConfigJson = (String)this.getModel().getValue(Key_LINKUPBILLCONFIG_JSON, currentEntityRow);
        String dStartConditionJson = (String)this.getModel().getValue(Key_D_START_CONDITION, currentEntityRow);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        if (billEntityType != null) {
            customParams.put(CustomParam_MATCH_BILL, billEntityType.getName());
        }
        customParams.put(CustomParam_DETAIL_CONFIG, rules);
        customParams.put(CustomParam_FRONTEND_CONFIG, frontEndConfig);
        customParams.put(CustomParam_SHOW_WITHOUTLUB, isShowWithoutLUB);
        customParams.put(CustomParam_D_START_CONDITION_JSON, dStartConditionJson);
        customParams.put(CustomParam_ENTITY_NUMBER, sourceBillEntityType.getName());
        customParams.put(CustomParam_LINKUPBILLCONFIG, linkupBillConfigJson);
        String analysisMode = (String)this.getModel().getValue(Key_ANALYSIS_MODE);
        customParams.put(CustomParam_ANALYSISMODE, analysisMode);
        this.showForm(FormId_IDI_CONDITION_CONFIG, customParams, ActionId_SET_RULE);
    }

    private BillEntityType getMatchBillType(int row) {
        DynamicObject target = (DynamicObject)this.getModel().getValue(Key_MATCH_BILL, row);
        if (target == null) {
            return null;
        }
        String entityNumber = (String)target.getPkValue();
        return (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
    }

    private BillEntityType getSourceBillType() {
        DynamicObject target = (DynamicObject)this.getModel().getValue(Key_SOURCEENTITYNUMBER);
        if (target == null) {
            return null;
        }
        String entityNumber = (String)target.getPkValue();
        return (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
    }

    private BillInfo genBillInfo(DynamicObject target) {
        if (target == null) {
            return null;
        }
        String entityNumber = (String)target.getPkValue();
        MainEntityType tgtMainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        BillInfo billInfo = new BillInfo();
        billInfo.setEntityNumber(entityNumber);
        billInfo.setBillDisplayName(tgtMainType.getDisplayName().toString());
        return billInfo;
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        Control ctl = (Control)evt.getSource();
        if (Key_C_PANEL.equals(ctl.getKey())) {
            List rows = evt.getOldRows();
            if (rows != null && rows.size() == 1) {
                this.saveDecisionToCategory((Integer)rows.get(0));
            }
            if ((rows = evt.getNewRows()) != null && rows.size() == 1) {
                Integer selectedCategory = (Integer)rows.get(0);
                this.updateDecisionPanel(selectedCategory);
            }
        } else if ("d_panel".equals(ctl.getKey())) {
            List rows = evt.getNewRows();
            int count = CollectionUtils.isEmpty((Collection)rows) ? 0 : rows.size();
            this.setDecisionSelect(count);
        }
    }

    private void setDecisionSelect(int count) {
        Label label = (Label)this.getControl(KEY_C_DECIISONSCRIPT);
        String mesg = ResManager.loadKDString((String)"\u9009\u4e2d%d\u6761\u6570\u636e", (String)"IDISchemaFormPlugin_37", (String)"data-idi-formplugin", (Object[])new Object[0]);
        mesg = String.format(mesg, count);
        label.setText(mesg);
    }

    private void saveDecisionToCategory() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(Key_C_PANEL);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows.length == 1) {
            this.saveDecisionToCategory(selectRows[0]);
        }
    }

    private void saveDecisionToCategory(int categoryRow) {
        DynamicObjectCollection decisionData = this.getModel().getEntryEntity("d_panel");
        ArrayList<Decision> dataList = new ArrayList<Decision>();
        for (int i = 0; i < decisionData.size(); ++i) {
            DynamicObject data = (DynamicObject)decisionData.get(i);
            Decision decision = this.createDecision(data);
            if (!decision.isNull()) {
                dataList.add(decision);
                continue;
            }
            logger.warn("\u68c0\u67e5\u9879\u6570\u636e\u4e3a\u7a7a\uff0c\u81ea\u52a8\u5220\u9664\u3002\u5e8f\u53f7\u4e3a\uff1a{}", (Object)i);
        }
        logger.info("\u4fdd\u5b58\u68c0\u67e5\u9879\u5206\u7c7b\u6570\u636e\uff0c\u5206\u7c7b\u5e8f\u53f7\uff1a" + categoryRow + "\uff0c\u884c\u6570\uff1a" + dataList.size());
        this.getModel().setValue(Key_C_DECISION_JSON, (Object)IDIJSONUtils.toJsonString(dataList), categoryRow);
        this.getModel().setValue(KEY_C_DECISIONCOUNT, (Object)dataList.size(), categoryRow);
    }

    private Decision createDecision(DynamicObject data) {
        Decision decision = new Decision();
        decision.setName(data.getString("d_multiname"));
        decision.setLocaleName(IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)data.getLocaleString("d_multiname"))));
        decision.setMark(data.getInt(Key_DECISIONREMARK));
        decision.setEnabled(data.getBoolean(Key_IS_ENABLE));
        decision.setMatchBill(this.genBillInfo(data.getDynamicObject(Key_MATCH_BILL)));
        decision.setRemarks(data.getString(Key_D_MULTIREMARKS));
        decision.setLocaleRemarks(IDIStringUtils.ormLocaleToLocate((OrmLocaleValue)((OrmLocaleValue)data.getLocaleString(Key_D_MULTIREMARKS))));
        String matchType = data.getString("match_type");
        decision.setMatchType(matchType);
        String detailConfig = data.getString("detailconfig_json");
        String frontEndConfig = data.getString(Key_FRONTEND_CONFIG);
        String isShowWithoutLUB = data.getString(Key_ISSHOW_SWITCH);
        String startConditionJson = data.getString(Key_D_START_CONDITION);
        IDICondition decisionStartCondition = StringUtils.isEmpty((String)startConditionJson) ? null : (IDICondition)IDIJSONUtils.cast((String)startConditionJson, IDICondition.class);
        String linkupbillconfigJson = data.getString(Key_LINKUPBILLCONFIG_JSON);
        String controlType = data.getString("controltype");
        BillControlTypeEnum controlTypeEnum = BillControlTypeEnum.convert((String)controlType);
        decision.setBillControl(controlTypeEnum);
        decision.setPk(data.getString("d_id"));
        if (StringUtils.isNotEmpty((String)detailConfig)) {
            if (MatchType.ALARM.getType().equalsIgnoreCase(matchType)) {
                AlarmConfig alarmConfig = (AlarmConfig)IDIJSONUtils.cast((String)detailConfig, AlarmConfig.class);
                alarmConfig.setStartCondition(decisionStartCondition);
                decision.setAlarm(alarmConfig);
            } else if (MatchType.NEWS.getType().equalsIgnoreCase(matchType)) {
                decision.setNews((NewsConfig)IDIJSONUtils.cast((String)detailConfig, NewsConfig.class));
                decision.setStartCondition(decisionStartCondition);
            } else if (MatchType.GENERALLEDGER.getType().equalsIgnoreCase(matchType)) {
                GeneralLedger generalLedger = (GeneralLedger)IDIJSONUtils.cast((String)detailConfig, GeneralLedger.class);
                generalLedger.setStartCondition(decisionStartCondition);
                decision.setGeneralLedger(generalLedger);
            } else if (MatchType.FUTURE.getType().equalsIgnoreCase(matchType)) {
                decision.setTimeLine((TimeLine)IDIJSONUtils.cast((String)detailConfig, TimeLine.class));
                decision.setStartCondition(decisionStartCondition);
            } else if (MatchType.KEYWORD.getType().equalsIgnoreCase(matchType)) {
                KeywordConfig keywordConfig = (KeywordConfig)IDIJSONUtils.cast((String)detailConfig, KeywordConfig.class);
                keywordConfig.setStartCondition(decisionStartCondition);
                decision.setKeywordConfig(keywordConfig);
            } else if (MatchType.INVOICE.getType().equalsIgnoreCase(matchType)) {
                InvoiceConfig invoiceConfig = (InvoiceConfig)IDIJSONUtils.cast((String)detailConfig, InvoiceConfig.class);
                invoiceConfig.setStartCondition(decisionStartCondition);
                decision.setInvoiceConfig(invoiceConfig);
            } else if (MatchType.BUDGET.getType().equalsIgnoreCase(matchType)) {
                decision.setBudgetConfig((BudgetConfig)IDIJSONUtils.cast((String)detailConfig, BudgetConfig.class));
            } else if (MatchType.BILLFLOW.getType().equalsIgnoreCase(matchType)) {
                decision.setBillFlowConfig((BillFlowConfig)IDIJSONUtils.cast((String)detailConfig, BillFlowConfig.class));
                decision.setStartCondition(decisionStartCondition);
            } else if (MatchType.STATISTICS.getType().equalsIgnoreCase(matchType)) {
                decision.setStatisticsConfig((StatisticsConfig)IDIJSONUtils.cast((String)detailConfig, StatisticsConfig.class));
                decision.setStartCondition(decisionStartCondition);
            } else if (MatchType.FASINDEX.getType().equalsIgnoreCase(matchType)) {
                decision.setFasindexConfig((FasindexConfig)IDIJSONUtils.cast((String)detailConfig, FasindexConfig.class));
            } else if (MatchType.ATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                AttachmentConfig attachmentConfig = (AttachmentConfig)IDIJSONUtils.cast((String)detailConfig, AttachmentConfig.class);
                attachmentConfig.setStartCondition(decisionStartCondition);
                decision.setAttachmentConfig(attachmentConfig);
            } else if (MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                AIAttachmentConfig aiAttachmentConfig = (AIAttachmentConfig)IDIJSONUtils.cast((String)detailConfig, AIAttachmentConfig.class);
                aiAttachmentConfig.setStartCondition(decisionStartCondition);
                decision.setAiAttachmentConfig(aiAttachmentConfig);
            } else if (MatchType.containsType((String)matchType)) {
                decision.setRules(IDIJSONUtils.jsonCastToList((String)detailConfig, DecisionRule.class));
                decision.setFrontEndConfig((DecisionFrontEndConfig)IDIJSONUtils.cast((String)frontEndConfig, DecisionFrontEndConfig.class));
                decision.setShowWithoutLUB(Boolean.parseBoolean(isShowWithoutLUB));
                decision.setStartCondition(decisionStartCondition);
                decision.setLinkUpBillConfig((LinkUpBillConfig)IDIJSONUtils.cast((String)linkupbillconfigJson, LinkUpBillConfig.class));
            }
        } else if (MatchType.LOGISTICSINFORMATION.getType().equalsIgnoreCase(matchType)) {
            decision.setStartCondition(decisionStartCondition);
        }
        return decision;
    }

    private void updateDecisionPanel() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(Key_C_PANEL);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows.length >= 1) {
            this.updateDecisionPanel(selectRows[0]);
        } else {
            this.getModel().setValue(Key_D_SELECTED_CATEGORY, null);
            this.getModel().deleteEntryData("d_panel");
        }
    }

    private void updateDecisionPanel(int selectedCategory) {
        List decisionList;
        String srcEntityNum;
        IDataModel model = this.getModel();
        String categoryId = (String)model.getValue(Key_C_ID, selectedCategory);
        String decisionJson = (String)model.getValue(Key_C_DECISION_JSON, selectedCategory);
        Object oldSelectedCategory = model.getValue(Key_D_SELECTED_CATEGORY);
        DynamicObject sourceNumberObj = this.getModel().getDataEntity().getDynamicObject(Key_SOURCEENTITYNUMBER);
        String string = srcEntityNum = sourceNumberObj != null ? (String)sourceNumberObj.getPkValue() : null;
        if (Objects.equals(categoryId, oldSelectedCategory)) {
            return;
        }
        model.beginInit();
        model.setValue(Key_D_SELECTED_CATEGORY, (Object)categoryId);
        model.deleteEntryData("d_panel");
        if (!StringUtils.isEmpty((String)decisionJson) && (decisionList = IDIJSONUtils.jsonCastToList((String)decisionJson, Decision.class)) != null && !decisionList.isEmpty()) {
            int decisionListSize = decisionList.size();
            model.batchCreateNewEntryRow("d_panel", decisionListSize);
            for (int row = 0; row < decisionListSize; ++row) {
                Decision decision = (Decision)decisionList.get(row);
                BillInfo matchBill = decision.getMatchBill();
                IDICondition startCondition = decision.getStartCondition();
                this.getModel().setValue("controltype", (Object)(decision.getBillControl() == null ? BillControlTypeEnum.NOCONTROL.getType() : decision.getBillControl().getType()), row);
                this.setEnable(decision.getMatchType(), row);
                this.getModel().setValue("d_multiname", (Object)decision.getLocaleName(), row);
                if (matchBill != null) {
                    this.getModel().setValue(Key_MATCH_BILL, (Object)matchBill.getEntityNumber(), row);
                }
                this.getModel().setValue("match_type", (Object)decision.getMatchType(), row);
                Object ruleObj = null;
                if (MatchType.ALARM.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getAlarm();
                    if (ruleObj != null) {
                        startCondition = decision.getAlarm().getStartCondition();
                    }
                } else if (MatchType.NEWS.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getNews();
                } else if (MatchType.GENERALLEDGER.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getGeneralLedger();
                    if (ruleObj != null) {
                        startCondition = decision.getGeneralLedger().getStartCondition();
                    }
                } else if (MatchType.FUTURE.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getTimeLine();
                } else if (MatchType.LINKUP_BILL.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getRules();
                    DecisionFrontEndConfig frontendConfig = decision.getFrontEndConfig();
                    if (frontendConfig == null) {
                        this.getModel().setValue(Key_FRONTEND_CONFIG, (Object)"", row);
                    } else {
                        this.getModel().setValue(Key_FRONTEND_CONFIG, (Object)IDIJSONUtils.toJsonString((Object)frontendConfig), row);
                    }
                    boolean isShow = decision.isShowWithoutLUB();
                    this.getModel().setValue(Key_ISSHOW_SWITCH, (Object)String.valueOf(isShow), row);
                    LinkUpBillConfig linkUpBillConfig = decision.getLinkUpBillConfig();
                    if (linkUpBillConfig == null) {
                        this.getModel().setValue(Key_LINKUPBILLCONFIG_JSON, (Object)"", row);
                    } else {
                        this.getModel().setValue(Key_LINKUPBILLCONFIG_JSON, (Object)IDIJSONUtils.toJsonString((Object)linkUpBillConfig), row);
                        if (Relation.SELF != linkUpBillConfig.getRelation() && Relation.CUSTOM != linkUpBillConfig.getRelation()) {
                            this.getModel().setValue("controltype", (Object)BillControlTypeEnum.NOCONTROL.getType(), row);
                            this.getView().setEnable(Boolean.FALSE, row, new String[]{"controltype"});
                        }
                    }
                } else if (MatchType.KEYWORD.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getKeywordConfig();
                    if (ruleObj != null) {
                        startCondition = decision.getKeywordConfig().getStartCondition();
                    }
                } else if (MatchType.INVOICE.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getInvoiceConfig();
                    if (ruleObj != null) {
                        startCondition = decision.getInvoiceConfig().getStartCondition();
                    }
                } else if (MatchType.BUDGET.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getBudgetConfig();
                } else if (MatchType.BILLFLOW.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getBillFlowConfig();
                } else if (MatchType.STATISTICS.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getStatisticsConfig();
                } else if (MatchType.FASINDEX.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getFasindexConfig();
                } else if (MatchType.ATTACHMENT.getType().equalsIgnoreCase(decision.getMatchType())) {
                    ruleObj = decision.getAttachmentConfig();
                    if (ruleObj != null) {
                        startCondition = decision.getAttachmentConfig().getStartCondition();
                    }
                } else if (MatchType.AIATTACHMENT.getType().equalsIgnoreCase(decision.getMatchType()) && (ruleObj = decision.getAiAttachmentConfig()) != null) {
                    startCondition = decision.getAiAttachmentConfig().getStartCondition();
                }
                if (startCondition == null) {
                    this.getModel().setValue(Key_D_START_CONDITION, (Object)"", row);
                } else {
                    ExpressionTranslator.tranFilterCondition((IDICondition)startCondition, (String)srcEntityNum, (String)srcEntityNum, (String)"", (Object)Boolean.FALSE, (boolean)false, (String)"");
                    this.getModel().setValue(Key_D_START_CONDITION, (Object)IDIJSONUtils.toJsonString((Object)startCondition), row);
                    this.getModel().setValue(Key_D_START_CONDITIONDISPLAY, (Object)this.getExprDesc(startCondition), row);
                }
                if (ruleObj == null) {
                    this.getModel().setValue("detailconfig_json", (Object)"", row);
                } else {
                    this.getModel().setValue("detailconfig_json", (Object)IDIJSONUtils.toJsonString((Object)ruleObj), row);
                    model.setValue("detailconfig", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"IDISchemaFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]), row);
                }
                this.getModel().setValue(Key_DECISIONREMARK, (Object)decision.getMark(), row);
                this.getModel().setValue(Key_IS_ENABLE, (Object)decision.isEnabled(), row);
                this.getModel().setValue("d_id", (Object)(StringUtils.isEmpty((String)decision.getPk()) ? Uuid16.create().toString() : decision.getPk()), row);
                this.getModel().setValue(Key_D_MULTIREMARKS, (Object)decision.getLocaleRemarks(), row);
            }
        }
        model.endInit();
        this.getView().updateView("d_panel");
        this.setDecisionSelect(0);
    }

    private void setNull(int rowIndex) {
        this.getModel().setValue(Key_DECISIONREMARK, (Object)0, rowIndex);
        this.getModel().setValue(Key_MATCH_BILL, null, rowIndex);
        this.getModel().setValue("detailconfig_json", (Object)"", rowIndex);
        this.getModel().setValue(Key_D_START_CONDITION, (Object)"", rowIndex);
        this.getModel().setValue(Key_LINKUPBILLCONFIG_JSON, (Object)"", rowIndex);
    }

    private void changeField(String matchType, int rowIndex) {
        this.setEnable(matchType, rowIndex);
        this.setNull(rowIndex);
    }

    private void setEnable(String matchType, int rowIndex) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (MatchType.NEWS.getType().equalsIgnoreCase(matchType) || MatchType.GENERALLEDGER.getType().equalsIgnoreCase(matchType) || MatchType.BUDGET.getType().equalsIgnoreCase(matchType) || MatchType.LOGISTICSINFORMATION.getType().equalsIgnoreCase(matchType) || MatchType.BILLFLOW.getType().equalsIgnoreCase(matchType) || MatchType.STATISTICS.getType().equalsIgnoreCase(matchType) || MatchType.FASINDEX.getType().equalsIgnoreCase(matchType)) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{Key_DECISIONREMARK, Key_MATCH_BILL, "controltype"});
            model.setValue("controltype", (Object)BillControlTypeEnum.NOCONTROL.getType(), rowIndex);
        } else if (MatchType.ALARM.getType().equalsIgnoreCase(matchType)) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{Key_MATCH_BILL});
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{Key_DECISIONREMARK, "controltype"});
        } else if (MatchType.FUTURE.getType().equalsIgnoreCase(matchType)) {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{Key_MATCH_BILL});
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{Key_DECISIONREMARK, "controltype"});
            model.setValue("controltype", (Object)BillControlTypeEnum.NOCONTROL.getType(), rowIndex);
        } else if (MatchType.KEYWORD.getType().equalsIgnoreCase(matchType) || MatchType.INVOICE.getType().equalsIgnoreCase(matchType)) {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"controltype"});
        } else if (MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"controltype"});
            model.setValue("controltype", (Object)BillControlTypeEnum.NOCONTROL.getType(), rowIndex);
        } else {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{Key_DECISIONREMARK, Key_MATCH_BILL, "controltype"});
        }
        view.setEnable(Boolean.valueOf(MatchType.containsType((String)matchType) && !MatchType.BUDGET.getType().equalsIgnoreCase(matchType) && !MatchType.FASINDEX.getType().equalsIgnoreCase(matchType)), rowIndex, new String[]{Key_D_START_CONDITIONDISPLAY});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if ("match_type".equalsIgnoreCase(propertyName)) {
            ChangeData[] changeData = e.getChangeSet();
            if (changeData.length > 0) {
                String newMatchType = (String)changeData[0].getNewValue();
                int rowIndex = changeData[0].getRowIndex();
                if (!StringUtils.isEmpty((String)newMatchType)) {
                    this.changeField(newMatchType, changeData[0].getRowIndex());
                }
                this.getModel().setValue("detailconfig_json", (Object)"", rowIndex);
                this.getModel().setValue(Key_FRONTEND_CONFIG, (Object)"", rowIndex);
                this.getModel().setValue(Key_D_START_CONDITION, (Object)"", rowIndex);
                this.getModel().setValue(Key_LINKUPBILLCONFIG_JSON, (Object)"", rowIndex);
            }
        } else if (Key_SOURCEENTITYNUMBER.equalsIgnoreCase(propertyName)) {
            if (e.getChangeSet()[0].getOldValue() == null && e.getChangeSet()[0].getNewValue() != null) {
                DynamicObject currentSourceObj = this.getModel().getDataEntity().getDynamicObject(Key_SOURCEENTITYNUMBER);
                this.getPageCache().put(Key_SOURCEENTITYNUMBER, currentSourceObj == null ? "" : (String)currentSourceObj.getPkValue());
                this.refreshMatchTypeCombo();
            } else {
                String editType = this.getPageCache().get("editType");
                if (!"system".equalsIgnoreCase(editType)) {
                    String message = ResManager.loadKDString((String)"\u4fee\u6539\u6e90\u5355\u540e\uff0c\u539f\u65b9\u6848\u7684\u914d\u7f6e\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\u3002\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"IDISchemaFormPlugin_20", (String)"data-idi-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(message, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ActionId_CHANGE_SOURCENUMBER, (IFormPlugin)this));
                }
            }
            this.getPageCache().put("editType", "user");
        } else if (Key_ANALYSIS_MODE.equals(propertyName)) {
            ChangeData[] changeData = e.getChangeSet();
            this.changeAnalysisMode((String)changeData[0].getNewValue());
        } else if (Key_START_CONDITION.equals(propertyName)) {
            String startConditionStr = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isEmpty((String)startConditionStr)) {
                this.getModel().setValue(Key_START_CONDITION_JSON, (Object)"");
            }
        } else if (KEY_C_AREASTARTCONDITION.equals(propertyName)) {
            String areaStartConditionStr = (String)e.getChangeSet()[0].getNewValue();
            int currentEntryRow = this.getModel().getEntryCurrentRowIndex(Key_C_PANEL);
            if (StringUtils.isEmpty((String)areaStartConditionStr)) {
                this.getModel().setValue(KEY_C_AREASTARTCONDITION_JSON, (Object)"", currentEntryRow);
            }
        } else if (Key_D_START_CONDITIONDISPLAY.equals(propertyName)) {
            String decisionStartConditionStr = (String)e.getChangeSet()[0].getNewValue();
            int currentEntryRow = this.getModel().getEntryCurrentRowIndex("d_panel");
            if (StringUtils.isEmpty((String)decisionStartConditionStr)) {
                this.getModel().setValue(Key_D_START_CONDITION, (Object)"", currentEntryRow);
            }
        } else if ("detailconfig".equals(propertyName)) {
            String decisionConfigStr = (String)e.getChangeSet()[0].getNewValue();
            int currentEntryRow = this.getModel().getEntryCurrentRowIndex("d_panel");
            if (StringUtils.isEmpty((String)decisionConfigStr)) {
                this.getModel().setValue("detailconfig_json", (Object)"", currentEntryRow);
                this.getModel().setValue(Key_FRONTEND_CONFIG, (Object)"", currentEntryRow);
                this.getModel().setValue(Key_LINKUPBILLCONFIG_JSON, (Object)"", currentEntryRow);
                this.getModel().setValue(Key_D_START_CONDITIONDISPLAY, (Object)"", currentEntryRow);
            }
        }
    }

    private void changeAnalysisMode(String analysisMode) {
        if (AnalysisMode.NOSCORE.getType().equals(analysisMode)) {
            IDataModel dataModel = this.getModel();
            this.processCurrentAreaForAnalysisModel(dataModel);
            this.processOtherAreaForAnalysisModel(dataModel);
            this.getView().setVisible(Boolean.FALSE, new String[]{Key_DECISIONREMARK});
            dataModel.setValue(Key_GRADECONFIGJSON, null);
            dataModel.setValue("gradeconfig", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"gradeconfig"});
        } else if (AnalysisMode.SCORE.getType().equals(analysisMode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{Key_DECISIONREMARK});
            this.getView().setEnable(Boolean.TRUE, new String[]{"gradeconfig"});
        }
    }

    private void processCurrentAreaForAnalysisModel(IDataModel dataModel) {
        int rowCount = dataModel.getEntryRowCount("d_panel");
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                String detailConfig;
                String matchType = (String)dataModel.getValue("match_type", i);
                if (MatchType.LINKUP_BILL.getType().equals(matchType)) {
                    String linkupBillConfigJson;
                    detailConfig = (String)dataModel.getValue("detailconfig_json", i);
                    if (StringUtils.isNotEmpty((String)detailConfig)) {
                        List ruleList = IDIJSONUtils.jsonCastToList((String)detailConfig, DecisionRule.class);
                        if (ruleList != null) {
                            for (DecisionRule rule : ruleList) {
                                rule.setCheckVote(false);
                                rule.setDeductionGradePercent(0);
                            }
                        }
                        dataModel.setValue("detailconfig_json", (Object)IDIJSONUtils.toJsonString((Object)ruleList), i);
                    }
                    if (StringUtils.isNotEmpty((String)(linkupBillConfigJson = (String)dataModel.getValue(Key_LINKUPBILLCONFIG_JSON, i)))) {
                        LinkUpBillConfig linkUpBillConfig = (LinkUpBillConfig)IDIJSONUtils.cast((String)linkupBillConfigJson, LinkUpBillConfig.class);
                        linkUpBillConfig.setDeductionGradeConfigList(Collections.emptyList());
                        dataModel.setValue(Key_LINKUPBILLCONFIG_JSON, (Object)IDIJSONUtils.toJsonString((Object)linkUpBillConfig), i);
                    }
                } else if (MatchType.ALARM.getType().equals(matchType) && StringUtils.isNotEmpty((String)(detailConfig = (String)dataModel.getValue("detailconfig_json", i)))) {
                    AlarmConfig alarmConfig = (AlarmConfig)IDIJSONUtils.cast((String)detailConfig, AlarmConfig.class);
                    alarmConfig.setCheckVote(false);
                    dataModel.setValue("detailconfig_json", (Object)IDIJSONUtils.toJsonString((Object)alarmConfig), i);
                }
                dataModel.setValue(Key_DECISIONREMARK, (Object)0, i);
            }
        }
    }

    private void processOtherAreaForAnalysisModel(IDataModel dataModel) {
        int areaCount = dataModel.getEntryRowCount(Key_C_PANEL);
        if (areaCount > 0) {
            int areaIndex = dataModel.getEntryCurrentRowIndex(Key_C_PANEL);
            for (int i = 0; i < areaCount; ++i) {
                String decisionJson;
                if (i == areaIndex || !StringUtils.isNotEmpty((String)(decisionJson = (String)this.getModel().getValue(Key_C_DECISION_JSON, i)))) continue;
                List decisionList = IDIJSONUtils.jsonCastToList((String)decisionJson, Decision.class);
                for (Decision decision : decisionList) {
                    if (MatchType.LINKUP_BILL.getType().equals(decision.getMatchType())) {
                        List ruleList = decision.getRules();
                        if (ruleList != null && !ruleList.isEmpty()) {
                            for (DecisionRule rule : ruleList) {
                                rule.setDeductionGradePercent(0);
                                rule.setCheckVote(false);
                            }
                        }
                        LinkUpBillConfig linkUpBillConfig = decision.getLinkUpBillConfig();
                        linkUpBillConfig.setDeductionGradeConfigList(Collections.emptyList());
                    } else if (MatchType.ALARM.getType().equals(decision.getMatchType())) {
                        decision.getAlarm().setCheckVote(false);
                    }
                    decision.setMark(0);
                }
                decisionJson = IDIJSONUtils.toJsonString((Object)decisionList);
                this.getModel().setValue(Key_C_DECISION_JSON, (Object)decisionJson, i);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxResult) {
            String billIdStr;
            OperationResult enableResult;
            if (ActionId_CHANGE_SOURCENUMBER.equalsIgnoreCase(actionId)) {
                DynamicObject currentSourceObj = this.getModel().getDataEntity().getDynamicObject(Key_SOURCEENTITYNUMBER);
                this.getPageCache().put(Key_SOURCEENTITYNUMBER, currentSourceObj == null ? "" : (String)currentSourceObj.getPkValue());
                this.getModel().setValue(Key_START_CONDITION, null);
                this.getModel().deleteEntryData(Key_C_PANEL);
                this.getModel().deleteEntryData("d_panel");
                this.refreshMatchTypeCombo();
            } else if (ActionId_SET_ENABLE.equalsIgnoreCase(actionId) && (enableResult = OperationServiceHelper.executeOperate((String)Key_ENABLE, (String)"idi_schema", (Object[])new Object[]{billIdStr = messageBoxClosedEvent.getCustomVaule()}, (OperateOption)OperateOption.create())) != null && enableResult.isSuccess()) {
                this.getModel().setValue(Key_ENABLE, (Object)"1");
                this.getView().getModel().setDataChanged(false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"IDISchemaFormPlugin_17", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        } else if (ActionId_CHANGE_SOURCENUMBER.equalsIgnoreCase(actionId)) {
            this.getPageCache().put("editType", "system");
            this.getModel().setValue(Key_SOURCEENTITYNUMBER, (Object)this.getPageCache().get(Key_SOURCEENTITYNUMBER));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u9700\u624b\u52a8\u542f\u7528\u3002", (String)"IDISchemaFormPlugin_18", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String version = LicenseServiceHelper.getProductVersion();
        if (!"1.0".equals(version)) {
            LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_IDI");
            boolean hasLicense = checkResult.getHasLicense();
            e.setCancel(!hasLicense);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        EntryGrid entryGrid;
        int[] selectedRow;
        if (Key_D_BTNADD.equals(evt.getItemKey()) && (selectedRow = (entryGrid = (EntryGrid)this.getView().getControl(Key_C_PANEL)).getSelectRows()).length == 0) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7c7b\u3002", (String)"IDISchemaFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
    }

    private void showCheckAttachment(BillEntityType sourceBill) {
        String analysisMode = (String)this.getModel().getValue(Key_ANALYSIS_MODE);
        this.showFormAboutBillType(FORMID_IDI_CHECKATTACHMENT, FORMID_IDI_CHECKATTACHMENT, sourceBill, AnalysisMode.SCORE.getType().equals(analysisMode), true);
    }

    private void showCheckAIAttachment(BillEntityType sourceBill) {
        String analysisMode = (String)this.getModel().getValue(Key_ANALYSIS_MODE);
        this.showFormAboutBillType("idi_checkaiattachment", ActionId_SET_CHECKAIATTACHEMNT, sourceBill, AnalysisMode.SCORE.getType().equals(analysisMode), true);
    }

    private void refreshMatchTypeCombo() {
        ComboEdit matchTypeCe = (ComboEdit)this.getControl("match_type");
        if (matchTypeCe != null) {
            DynamicObject sourceNumberObj = this.getModel().getDataEntity().getDynamicObject(Key_SOURCEENTITYNUMBER);
            String srcEntityNum = sourceNumberObj != null ? (String)sourceNumberObj.getPkValue() : null;
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(this.buildBaseDecisionTypeCombos());
            if (srcEntityNum != null) {
                List extInfos = decisionExtInfoService.findAvailableExtInfo(srcEntityNum);
                for (ExtDecisionInfo extInfo : extInfos) {
                    comboItems.add(new ComboItem(new LocaleString(extInfo.getName()), String.valueOf(extInfo.getId())));
                }
            }
            matchTypeCe.setComboItems(comboItems);
        }
    }

    private List<ComboItem> buildBaseDecisionTypeCombos() {
        return Arrays.stream(MatchType.values()).filter(MatchType::isEnable).map(matchType -> new ComboItem(new LocaleString(matchType.getName()), matchType.getType())).collect(Collectors.toList());
    }

    private void dealAreaStartCondition(String result) {
        this.dealEntryStartCondition(result, Key_C_PANEL, KEY_C_AREASTARTCONDITION, KEY_C_AREASTARTCONDITION_JSON);
    }

    private void dealDecisionStartCondition(String result) {
        this.dealEntryStartCondition(result, "d_panel", Key_D_START_CONDITIONDISPLAY, Key_D_START_CONDITION);
    }

    private void dealEntryStartCondition(String result, String entryName, String startConditionDisplayField, String startConditionField) {
        int currentEntryRow = this.getModel().getEntryCurrentRowIndex(entryName);
        if (StringUtils.isNotEmpty((String)result)) {
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)result, IDICondition.class);
            if (condition == null) {
                this.getModel().setValue(startConditionField, (Object)"", currentEntryRow);
                this.getModel().setValue(startConditionDisplayField, (Object)"", currentEntryRow);
            } else {
                String exprTran = this.getExprDesc(condition);
                this.getModel().setValue(startConditionDisplayField, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDISchemaFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), exprTran), currentEntryRow);
                this.getModel().setValue(startConditionField, (Object)result, currentEntryRow);
            }
        }
    }
}

