/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.nio.charset.StandardCharsets;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.data.idi.export.schema.SchemaExportBuilder;
import kd.data.idi.export.schema.SchemaImportParser;

public class SchemaExImportPlugin
extends AbstractListPlugin
implements UploadListener {
    private static final DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private static final Log logger = LogFactory.getLog(SchemaExImportPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        if (!this.checkPermission("3N/DXHVZMCPJ").booleanValue()) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u51b3\u7b56\u65b9\u6848\u201d\u7684\u201c\u5bfc\u5165\u6570\u636e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SchemaExImportPlugin_0", (String)"data-idi-core", (Object[])new Object[0]));
            return;
        }
        Object[] urls = evt.getUrls();
        String url = (String)urls[0];
        OperationResult save = SchemaImportParser.create((String)url).executeSave();
        if (save.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6210\u529f\u3002", (String)"SchemaExImportPlugin_1", (String)"data-idi-core", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(save);
        }
    }

    public void afterUpload(UploadEvent evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if ("schemaexport".equals(operate.getOperateKey())) {
            if (!this.checkPermission("3N/DZ+1EYTQB").booleanValue()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u51b3\u7b56\u65b9\u6848\u201d\u7684\u201c\u5bfc\u51fa\u6570\u636e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SchemaExImportPlugin_2", (String)"data-idi-core", (Object[])new Object[0]));
                return;
            }
            try {
                Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
                String url = this.exportSysDynamicObjectFile(primaryKeyValues);
                this.getView().download(url);
            }
            catch (Exception ex) {
                logger.info("schema export error", (Object)ex);
                this.getView().showTipNotification(ex.getMessage());
                args.setCancel(true);
            }
        }
    }

    private Boolean checkPermission(String perItemId) {
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String appPk = AppMetadataCache.getAppInfo((String)appId).getId();
        return PermissionServiceHelper.checkPermission((Long)currUserId, (String)appPk, (String)"idi_schema", (String)perItemId);
    }

    public String exportSysDynamicObjectFile(Object[] primaryKeyValues) {
        SchemaExportBuilder exportBuilder = new SchemaExportBuilder(primaryKeyValues);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(exportBuilder.getExportFileName(), exportBuilder.build().getBytes(StandardCharsets.UTF_8), 60);
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntityMap = new HashMap<String, String>(3);
        refEntityMap.put("appId", "idi");
        refEntityMap.put("entityNum", "idi_schema");
        refEntityMap.put("permissionItemId", "3N/DZ+1EYTQB");
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntityMap), 7200);
        return url;
    }
}

