/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PerRecordSplit {
    private final BalanceTB bal;
    private final int targetPeriod;
    private final Set<String> yearCols;
    private final String periodCol;
    private final String endPeriodCol;
    private final String modifyTimeCol;
    private int batchSize = 200;

    PerRecordSplit(BalanceTB bal, int targetPeriod) {
        this.bal = bal;
        this.targetPeriod = targetPeriod;
        this.periodCol = bal.getPeriodCol();
        this.endPeriodCol = bal.getEndPeriodCol();
        this.modifyTimeCol = bal.getModifyTimeCol();
        this.yearCols = bal.getColsByDataType(BizDataType.YEAR_IN, BizDataType.YEAR_OUT);
    }

    void doSplitByIds(Collection<?> balIds) {
        List<String> keycols = this.getKeycols(this.bal, balIds);
        this.doSplitByKeycols(keycols);
    }

    public long doSplitTask(long from, long to) {
        QFilter fs = new QFilter("id", ">=", (Object)from).and("id", "<", (Object)to).and(this.endPeriodCol, "=", (Object)999999);
        ArrayList<Long> ids = new ArrayList<Long>(8);
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"doSplitTask", (String)this.bal.getName(), (String)"id", (QFilter[])fs.toArray(), null).orderBy(new String[]{"id ASC"});){
            int idx = data.getRowMeta().getFieldIndex("id");
            for (Row row : data) {
                ids.add(row.getLong(idx));
            }
        }
        ArrayList<Long> batchIds = new ArrayList<Long>(this.batchSize);
        long lastId = 0L;
        for (Long id : ids) {
            batchIds.add(id);
            if (batchIds.size() < this.batchSize) continue;
            this.doSplitByIds(batchIds);
            lastId = (Long)batchIds.get(batchIds.size() - 1);
            batchIds.clear();
        }
        if (!batchIds.isEmpty()) {
            this.doSplitByIds(batchIds);
            lastId = (Long)batchIds.get(batchIds.size() - 1);
        }
        return lastId;
    }

    private List<String> getKeycols(BalanceTB bal, Collection<?> balIds) {
        ArrayList<String> keycols = new ArrayList<String>(balIds.size());
        QFilter fs = new QFilter("id", "in", balIds).and(this.endPeriodCol, "=", (Object)999999);
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"getKeycols", (String)bal.getName(), (String)"keycol", (QFilter[])fs.toArray(), null);){
            for (Row row : data) {
                keycols.add(row.getString("keycol"));
            }
        }
        return keycols;
    }

    void doSplitByKeycols(List<String> keycols) {
        HashSet<String> keyset = new HashSet<String>(keycols);
        QFilter fs = new QFilter(this.periodCol, "<=", (Object)this.targetPeriod).and(this.endPeriodCol, ">", (Object)this.targetPeriod).and("keycol", "in", keycols);
        String cols = "id,keycol," + this.periodCol + "," + this.endPeriodCol;
        DynamicObjectCollection datas = QueryServiceHelper.query((String)this.bal.getName(), (String)cols, (QFilter[])fs.toArray());
        ArrayList<Object> ids4Split = new ArrayList<Object>(8);
        for (DynamicObject data : datas) {
            int period = data.getInt(this.periodCol);
            int endPeriod = data.getInt(this.endPeriodCol);
            if (period == this.targetPeriod) {
                keyset.remove(data.getString("keycol"));
                continue;
            }
            if (period >= this.targetPeriod || endPeriod <= this.targetPeriod) continue;
            ids4Split.add(data.get("id"));
        }
        if (keyset.isEmpty()) {
            return;
        }
        this.buildNewRecord(ids4Split);
    }

    private void buildNewRecord(List<Object> ids) {
        int i;
        if (ids.isEmpty()) {
            return;
        }
        Date now = new Date();
        Set<String> cols = this.bal.getAllTypeCols();
        cols.add("id");
        cols.add("keycol");
        QFilter fs = new QFilter("id", "in", ids);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.bal.getName());
        ArrayList<DynamicObject> oldRecords = new ArrayList<DynamicObject>(ids.size());
        ArrayList<DynamicObject> newRecords = new ArrayList<DynamicObject>(ids.size());
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)"buildNewRecord", (String)this.bal.getName(), (String)String.join((CharSequence)",", cols), (QFilter[])fs.toArray(), null);){
            Set<String> initQtyCols = this.bal.getColsByDataType(BizDataType.INIT);
            for (Row data : datas) {
                int period = data.getInteger(this.periodCol);
                int endperiod = data.getInteger(this.endPeriodCol);
                DynamicObject oldRecord = BusinessDataServiceHelper.newDynamicObject((String)this.bal.getName());
                DynamicObject newRecord = BusinessDataServiceHelper.newDynamicObject((String)this.bal.getName());
                for (String col : cols) {
                    oldRecord.set(col, data.get(col));
                    newRecord.set(col, data.get(col));
                }
                oldRecords.add(oldRecord);
                newRecords.add(newRecord);
                oldRecord.set(this.modifyTimeCol, (Object)now);
                oldRecord.set(this.periodCol, (Object)period);
                oldRecord.set(this.endPeriodCol, (Object)this.targetPeriod);
                newRecord.set(this.modifyTimeCol, (Object)now);
                newRecord.set(this.periodCol, (Object)this.targetPeriod);
                newRecord.set(this.endPeriodCol, (Object)endperiod);
                for (String qtyCol : initQtyCols) {
                    Object qty = data.get(qtyCol + "_bal");
                    newRecord.set(qtyCol, qty);
                    newRecord.set(qtyCol + "_in", (Object)BigDecimal.ZERO);
                    newRecord.set(qtyCol + "_out", (Object)BigDecimal.ZERO);
                    newRecord.set(qtyCol + "_bal", qty);
                }
            }
        }
        this.handleYearCols(oldRecords, newRecords);
        long[] newIds = DB.genGlobalLongIds((int)oldRecords.size());
        for (i = 0; i < newIds.length; ++i) {
            ((DynamicObject)oldRecords.get(i)).set("id", (Object)newIds[i]);
        }
        newIds = DB.genGlobalLongIds((int)newRecords.size());
        for (i = 0; i < newIds.length; ++i) {
            ((DynamicObject)newRecords.get(i)).set("id", (Object)newIds[i]);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])ids.toArray());
                SaveServiceHelper.save((DynamicObject[])oldRecords.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])newRecords.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void handleYearCols(List<DynamicObject> oldRecords, List<DynamicObject> newRecords) {
        if (this.yearCols.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> resultData = new ArrayList<DynamicObject>(8);
        int len = newRecords.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject oldRecord = oldRecords.get(i);
            DynamicObject newRecord = newRecords.get(i);
            int oldPeriod = oldRecord.getInt(this.periodCol);
            if (!this.isNotSameYear(oldPeriod, this.targetPeriod)) continue;
            int newEndPeriod = newRecord.getInt(this.endPeriodCol);
            if (this.isNotSameYear(this.targetPeriod, newEndPeriod)) {
                for (String yearCol : this.yearCols) {
                    newRecord.set(yearCol, (Object)BigDecimal.ZERO);
                }
                continue;
            }
            resultData.add(newRecord);
        }
        if (resultData.isEmpty()) {
            return;
        }
        this.handleYearColsFromDB(resultData);
    }

    private void handleYearColsFromDB(List<DynamicObject> resultData) {
        ArrayList<String> keycols = new ArrayList<String>(resultData.size());
        HashSet<Integer> periods = new HashSet<Integer>(8);
        for (DynamicObject data : resultData) {
            keycols.add(data.getString("keycol"));
            periods.add(data.getInt(this.endPeriodCol));
        }
        QFilter fs = new QFilter("keycol", "in", keycols);
        fs.and(this.periodCol, "in", periods);
        String cols = String.join((CharSequence)",", this.yearCols);
        cols = cols + ",keycol";
        cols = cols + "," + this.periodCol;
        DynamicObjectCollection balRecords = QueryServiceHelper.query((String)this.bal.getName(), (String)cols, (QFilter[])fs.toArray());
        HashMap<String, DynamicObject> balRecordMap = new HashMap<String, DynamicObject>(resultData.size());
        for (DynamicObject record : balRecords) {
            balRecordMap.put(record.getString("keycol") + record.getInt(this.periodCol), record);
        }
        for (DynamicObject data : resultData) {
            String key = data.getString("keycol") + data.getInt(this.endPeriodCol);
            DynamicObject dataFromDB = (DynamicObject)balRecordMap.get(key);
            if (dataFromDB == null) {
                for (String yearCol : this.yearCols) {
                    data.set(yearCol, (Object)BigDecimal.ZERO);
                }
                continue;
            }
            for (String yearCol : this.yearCols) {
                data.set(yearCol, (Object)dataFromDB.getBigDecimal(yearCol));
            }
        }
    }

    private boolean isNotSameYear(int periodValue, int otherPeriodValue) {
        return periodValue / 100 != otherPeriodValue / 100;
    }
}

