/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import kd.bos.bal.business.archive.RecordSplitUtil;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.sparse.SparseDataLoader;
import kd.bos.bal.common.BalUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

class RecordSplit {
    private long fromId;
    private long toId;
    private QFilter otherFs;
    private final BalanceTB bal;
    private final BalConfig cfg;
    private final DynamicObject taskInfo;
    private String taskMode;
    private final Date limitDate;
    private final long limitId;
    private final Long lastSuccessId;
    private final int ver;

    public RecordSplit(DynamicObject taskInfo) {
        String balName = taskInfo.getString("parenttask.bal.id");
        this.ver = taskInfo.getInt("parenttask.ver");
        this.bal = BalanceTB.getBalanceTB(balName);
        this.cfg = BalConfig.loadBalConfig(balName);
        this.fromId = taskInfo.getLong("fromid");
        this.toId = taskInfo.getLong("toid");
        this.lastSuccessId = taskInfo.getLong("lastsuccessid");
        this.taskInfo = taskInfo;
        this.limitDate = BalUtil.getDateByDays(this.cfg.getArchiveLimitDay());
        this.limitId = BalUtil.getIdByDate(this.limitDate);
    }

    public void setTaskMode(String taskMode) {
        this.taskMode = taskMode;
    }

    public void split() {
        if (!this.bal.isRealBal()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5373\u65f6\u4f59\u989d\u7c7b\u578b\u7684\u4f59\u989d\u8868\u624d\u80fd\u8fd0\u884c\u4efb\u52a1\u3002", (String)"RecordSplit_1", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
        this.checkColList();
        TreeSet<Long> allIds = this.getAllIds();
        TreeSet<Long> batchIds = new TreeSet<Long>();
        int batch = this.cfg.getRecordSplitBatch();
        for (Long id : allIds) {
            batchIds.add(id);
            if (batchIds.size() < batch) continue;
            this.split(batchIds);
            this.setLastSuccessId(batchIds.last());
            batchIds.clear();
        }
        if (!batchIds.isEmpty()) {
            this.split(batchIds);
            this.setLastSuccessId(batchIds.last());
        }
    }

    private void checkColList() {
        List<String> balColList;
        List<String> taskColList = RecordSplitUtil.queryColList(this.bal.getName(), this.ver);
        if (!RecordSplitUtil.checkColList(taskColList, balColList = this.bal.getColList4RecordSplit())) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4f7f\u7528\u7684\u5b57\u6bb5\u7ec4\u5408\u4e0e\u4f59\u989d\u8868\u4e2d\u7684\u5b57\u6bb5\u7ec4\u5408\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u53d1\u5e03\u4efb\u52a1\u3002", (String)"RecordSplit_0", (String)"bos-biz-balance", (Object[])new Object[0]);
            msg = msg + " taskColList=" + taskColList + ", balColList=" + balColList;
            throw new KDBizException(msg);
        }
    }

    private void setLastSuccessId(Object lastId) {
        this.taskInfo.set("lastsuccessid", lastId);
    }

    public void split(TreeSet<Long> balIds) {
        RecordSplitUtil.archiveZeroRecord(this.ver, this.bal, new ArrayList<Long>(balIds), this.cfg.isAutoRepair4Archive());
    }

    private TreeSet<Long> getAllIds() {
        this.handleFs();
        this.setParam2Task();
        return new SparseDataLoader(this.taskInfo, this.fromId, this.toId).setOtherFs(this.otherFs).getAllIds();
    }

    private void handleFs() {
        String col;
        if ("B".equals(this.taskMode)) {
            long l = this.fromId = this.lastSuccessId > this.fromId ? this.lastSuccessId : this.fromId;
        }
        if (this.limitId < this.toId) {
            this.toId = this.limitId;
        }
        if ((col = this.bal.getModifyTimeCol()) != null) {
            this.appendFs(new QFilter(col, "<", (Object)this.limitDate).or(col, "is null", null));
        }
        this.appendFs(RecordSplitUtil.buildOccQtyFs(this.bal));
        this.appendFs(this.parseBalFs());
    }

    private QFilter parseBalFs() {
        DynamicObject info = QueryServiceHelper.queryOne((String)"bal_record_split", (String)"balfsinfo_tag", (QFilter[])new QFilter("id", "=", (Object)this.taskInfo.getLong("parenttask.id")).toArray());
        if (info == null) {
            return null;
        }
        return this.parseFs(this.taskInfo.getString("parenttask.bal.id"), info.getString("balfsinfo_tag"));
    }

    private QFilter parseFs(String entity, String fsInfo) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{entity, fsInfo})) {
            return null;
        }
        FilterCondition confition = (FilterCondition)SerializationUtils.fromJsonString((String)fsInfo, FilterCondition.class);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entity);
        FilterBuilder builder = new FilterBuilder(type, confition);
        builder.buildFilter();
        return builder.getQFilter();
    }

    private void appendFs(QFilter fs) {
        if (fs != null) {
            this.otherFs = this.otherFs == null ? fs : this.otherFs.and(fs);
        }
    }

    private void setParam2Task() {
        String msg = String.format("ver = %s, fromId=%s, toId=%s, limitId=%s, limitDate=%s, otherFs = [%s]", this.ver, this.fromId, this.toId, this.limitId, this.limitDate, this.otherFs);
        this.taskInfo.set("param_tag", (Object)msg);
    }
}

