/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bal.business.sparse.SparseSeq;
import kd.bos.bal.business.sparse.SparseSeqParam;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;

class RecordSplitTask
implements Callable<String> {
    private static final ThreadLocal<AtomicInteger> TASK_COUNT = new ThreadLocal();
    private final AtomicInteger taskCount;
    private final DynamicObject parentTask;
    private final SparseSeqParam sparseSeqParam;

    private String buildTaskNo(NumberFormat mat) {
        return this.parentTask.getString("taskno") + "_" + mat.format(this.taskCount.getAndIncrement());
    }

    public RecordSplitTask(DynamicObject parentTask, SparseSeqParam sparseSeqParam) {
        AtomicInteger taskCount = TASK_COUNT.get();
        if (taskCount == null) {
            taskCount = new AtomicInteger(1);
            TASK_COUNT.set(taskCount);
        }
        this.taskCount = taskCount;
        this.parentTask = parentTask;
        this.sparseSeqParam = sparseSeqParam;
    }

    private String buildMsgAppId() {
        String entity = this.parentTask.getString("bal.id");
        return MetadataServiceHelper.getDataEntityType((String)entity).getAppId();
    }

    @Override
    public String call() throws Exception {
        String traceId = "";
        try (SparseSeq sparseSeq = null;){
            traceId = TraceIdUtil.getCurrentTraceIdString();
            DecimalFormat mat = new DecimalFormat("000000");
            long userId = RequestContext.getOrCreate().getCurrUserId();
            Date now = new Date();
            sparseSeq = SparseSeq.getSparseSeq(this.sparseSeqParam);
            ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(1000);
            long sparseSeqId = sparseSeq.getId();
            String msgAppId = this.buildMsgAppId();
            while (sparseSeq.hasNext()) {
                long[] idRange = sparseSeq.next();
                DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"bal_record_split_task");
                task.set("taskno", (Object)this.buildTaskNo(mat));
                task.set("msgappid", (Object)msgAppId);
                task.set("managertraceid", (Object)traceId);
                task.set("parenttask", this.parentTask.getPkValue());
                task.set("sparseseq", (Object)sparseSeqId);
                task.set("fromid", (Object)idRange[0]);
                task.set("toid", (Object)idRange[1]);
                task.set("status", (Object)"A");
                task.set("creater", (Object)userId);
                task.set("createdate", (Object)now);
                tasks.add(task);
                if (tasks.size() < 1000) continue;
                this.saveTasks(tasks);
                tasks.clear();
            }
            if (!tasks.isEmpty()) {
                this.saveTasks(tasks);
            }
        }
        return null;
    }

    private void saveTasks(List<DynamicObject> tasks) {
        try (TXHandle tx = TX.requiresNew((String)"saveTasks");){
            SaveServiceHelper.save((DynamicObject[])tasks.toArray(new DynamicObject[0]));
        }
    }
}

