/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.bal.business.archive.RecordRevert;
import kd.bos.bal.business.archive.RecordSplit;
import kd.bos.bal.business.archive.RecordSplitTask;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalSparseTaskHandle;
import kd.bos.bal.business.sparse.SparseSeqParam;
import kd.bos.bal.common.BalTaskUtil;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;

class RecordSplitTaskHandle
extends BalSparseTaskHandle {
    protected RecordSplitTaskHandle() {
        super("bal_record_split", "bal_record_split_task", "2");
    }

    @Override
    protected void handleTaskMsg(TaskMsg msg, DynamicObject taskInfo) {
        String taskType;
        String opResult = taskInfo.getString("parenttask.opresult");
        if ("D".equals(opResult)) {
            taskInfo.set("status", (Object)"E");
            String showMsg = ResManager.loadKDString((String)"\u7236\u4efb\u52a1\u5df2\u624b\u5de5\u7ec8\u6b62\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u64cd\u4f5c\u3002", (String)"RecordSplitTaskHandle_0", (String)"bos-biz-balance", (Object[])new Object[0]);
            taskInfo.set("errormsg_tag", (Object)showMsg);
            return;
        }
        switch (taskType = taskInfo.getString("parenttask.tasktype")) {
            case "1": {
                this.recordSplit(taskInfo, msg);
                break;
            }
            case "2": {
                this.recordRevert(taskInfo, msg);
                break;
            }
        }
    }

    private void recordRevert(DynamicObject taskInfo, TaskMsg msg) {
        RecordRevert handle = new RecordRevert(taskInfo);
        handle.setTaskMode(msg.getMode());
        handle.revert();
        taskInfo.set("status", (Object)"F");
    }

    private void recordSplit(DynamicObject taskInfo, TaskMsg msg) {
        RecordSplit handle = new RecordSplit(taskInfo);
        handle.setTaskMode(msg.getMode());
        handle.split();
        taskInfo.set("status", (Object)"F");
    }

    @Override
    protected void addTask(DynamicObject parentTask) {
        String type;
        switch (type = parentTask.getString("tasktype")) {
            case "1": {
                this.addRecordSplitTask(parentTask);
                break;
            }
            case "2": {
                this.addRecordRevertTask(parentTask);
            }
        }
    }

    private void addRecordRevertTask(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        BalanceTB balTb = BalanceTB.getBalanceTB(balName);
        String colBackTb = balTb.getColBackTb();
        ArrayList<SparseSeqParam> params = new ArrayList<SparseSeqParam>(1);
        params.add(new SparseSeqParam(balTb.getDbRoute(), colBackTb, colBackTb, "fid"));
        this.buildTaskBySeqParam(parentTask, params);
    }

    private void addRecordSplitTask(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)balName);
        String[] tbs = BalTaskUtil.getXdbs(type.getAlias(), DBRoute.of((String)type.getDBRouteKey()));
        ArrayList<SparseSeqParam> params = new ArrayList<SparseSeqParam>(tbs.length);
        for (String table : tbs) {
            params.add(new SparseSeqParam(balName, table));
        }
        this.buildTaskBySeqParam(parentTask, params);
    }

    private void buildTaskBySeqParam(DynamicObject parentTask, List<SparseSeqParam> params) {
        this.setLimitInfo(parentTask, params);
        ArrayList<Callable<String>> tasks = new ArrayList<Callable<String>>(params.size());
        for (SparseSeqParam param : params) {
            tasks.add(new RecordSplitTask(parentTask, param));
        }
        this.buildTask(tasks);
    }

    private void setLimitInfo(DynamicObject parentTask, List<SparseSeqParam> params) {
        String taskType = parentTask.getString("tasktype");
        if ("1".equals(taskType)) {
            String balName = parentTask.getString("bal.id");
            BalConfig cfg = BalConfig.loadBalConfig(balName);
            long limitId = BalUtil.getIdByDays(cfg.getArchiveLimitDay());
            for (SparseSeqParam param : params) {
                param.setMaxLimit(limitId);
            }
        }
    }
}

