/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.algo.DataSet;
import kd.bos.bal.business.archive.SpDataSplit;
import kd.bos.bal.business.archive.SpDataSplitTask;
import kd.bos.bal.business.archive.SpDataSplitUtil;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalSparseTaskHandle;
import kd.bos.bal.business.sparse.SparseSeqParam;
import kd.bos.bal.common.BalTaskUtil;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

class SpDataSplitTaskHandle
extends BalSparseTaskHandle {
    SpDataSplitTaskHandle() {
        super("bal_spdata_split", "bal_spdata_split_task", "3");
    }

    @Override
    protected void handleTaskMsg(TaskMsg msg, DynamicObject taskInfo) {
        SpDataSplit handle = new SpDataSplit(taskInfo);
        handle.setTaskMode(msg.getMode());
        handle.split();
        taskInfo.set("status", (Object)"F");
    }

    @Override
    protected void checkTask(DynamicObject taskInfo) {
        this.checkLimitId(taskInfo);
    }

    private void checkLimitId(DynamicObject taskInfo) {
        Date timePoint;
        String balId = taskInfo.getString("bal.id");
        BalConfig config = BalConfig.loadBalConfig(balId);
        int limitDay = config.getSpDataSpiltLimitDay();
        Date limitDate = BalUtil.getDateByDays(limitDay);
        if (limitDate.before(timePoint = taskInfo.getDate("timepoint"))) {
            throw new KDBizException(ResManager.loadKDString((String)"ID\u5206\u754c\u70b9\u8d85\u51fa\u4e86\u53c2\u6570\u914d\u7f6e\uff0c\u65f6\u95f4\u5206\u754c\u70b9\u4e0d\u80fd\u5927\u4e8e\uff1a{0}\u3002", (String)"SpDataSplitTaskHandle_0", (String)"bos-biz-balance", (Object[])new Object[]{limitDate}));
        }
        taskInfo.set("idpoint", (Object)BalUtil.getIdByDate(timePoint));
    }

    @Override
    protected void addTask(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)balName);
        String[] tbs = BalTaskUtil.getXdbs(type.getAlias(), DBRoute.of((String)type.getDBRouteKey()));
        ArrayList<SparseSeqParam> params = new ArrayList<SparseSeqParam>(tbs.length);
        for (String table : tbs) {
            params.add(new SparseSeqParam(balName, table));
        }
        this.appendKBTableData(balName, params);
        HashSet<String> bills = new HashSet<String>(tbs.length);
        String billName = parentTask.getString("bill.id");
        if (StringUtils.isNotBlank((CharSequence)billName)) {
            bills.add(billName);
        } else {
            List<UpdateRule> rules = UpdateRuleCache.getUpdateRuleByBal(balName);
            for (UpdateRule rule : rules) {
                bills.add(rule.getEntityNumber());
            }
        }
        for (String bill : bills) {
            this.buildTaskBySeqParam(parentTask, params, bill);
        }
    }

    private void appendKBTableData(String balName, List<SparseSeqParam> params) {
        BalanceTB balanceTB = BalanceTB.getBalanceTB(balName);
        if (balanceTB.isRealBal()) {
            String kbTB = balanceTB.getColBackTb();
            String sql = "SELECT TOP 1 FKEYCOL FROM " + kbTB;
            try (DataSet data = DB.queryDataSet((String)"appendKBTableData", (DBRoute)balanceTB.getDbRoute(), (String)sql);){
                if (data.hasNext()) {
                    params.add(new SparseSeqParam(balanceTB.getDbRoute(), kbTB, kbTB, "fid"));
                }
            }
        }
    }

    private void buildTaskBySeqParam(DynamicObject parentTask, List<SparseSeqParam> params, String bill) {
        SpDataSplitUtil.addOrUpdateLimitId(parentTask, bill);
        ArrayList<Callable<String>> tasks = new ArrayList<Callable<String>>(params.size());
        for (SparseSeqParam param : params) {
            tasks.add(new SpDataSplitTask(parentTask, param, bill));
        }
        this.buildTask(tasks);
    }
}

