/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import java.util.Iterator;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.bal.business.consumer.IdxInfo;

class AsyncTxMsgReduceGroup
extends ReduceGroupFunctionWithCollector {
    private RowMeta rowMeta;
    private int idIdx;
    private int idsDelIdx;

    public AsyncTxMsgReduceGroup(RowMeta rowMeta, IdxInfo idxInfo) {
        this.rowMeta = rowMeta;
        this.idIdx = idxInfo.idIdx;
        this.idsDelIdx = idxInfo.idsDelIdx;
    }

    public void reduce(Iterator<Row> it, Collector ct) {
        StringBuilder idsDel = new StringBuilder();
        long resultId = 0L;
        Object[] result = null;
        while (it.hasNext()) {
            long delId;
            Row row = it.next();
            if (result == null) {
                result = RowUtil.toArray((Row)row);
                resultId = row.getLong(this.idIdx);
                continue;
            }
            long rowId = row.getLong(this.idIdx);
            if (rowId > resultId) {
                result = RowUtil.toArray((Row)row);
                delId = resultId;
                resultId = rowId;
            } else {
                delId = rowId;
            }
            if (idsDel.length() > 0) {
                idsDel.append(',');
            }
            idsDel.append(delId);
        }
        if (result != null) {
            result[this.idsDelIdx] = idsDel.toString();
            ct.collect(result);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

