/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bal.business.consumer.BalSemaphore;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;

class BalMsgUtil {
    private static final Map<String, BalSemaphore> SEMAPHORES = new HashMap<String, BalSemaphore>();

    BalMsgUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BalSemaphore getOrCreate(String key) {
        BalSemaphore semaphore = SEMAPHORES.get(key);
        if (semaphore == null) {
            Map<String, BalSemaphore> map = SEMAPHORES;
            synchronized (map) {
                semaphore = SEMAPHORES.computeIfAbsent(key, k -> new BalSemaphore());
            }
        }
        return semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rePublish(Object param, String queueName) {
        int times;
        JSONObject json = JSON.parseObject((String)((String)param));
        Integer jsonTime = json.getInteger("times");
        int n = times = jsonTime == null ? 0 : jsonTime;
        if (times > 3 || times < 0) {
            return;
        }
        BalLogUtil.info("BalMsgUtil.rePublish start : queueName={},time={},param={}", queueName, times, param);
        String appId = json.getString("appid");
        json.put("times", (Object)(++times));
        try (MessagePublisher publisher = null;){
            publisher = MQFactory.get().createPartitionPublisher("bal_queue", queueName, PartitionStrategy.APP_ID);
            publisher.publish((Object)json, appId);
        }
    }
}

