/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class BalSemaphore
implements AutoCloseable {
    private final AtomicInteger counter;
    private final ConcurrentHashMap<Long, Boolean> threadFlags = new ConcurrentHashMap();

    public BalSemaphore() {
        this.counter = new AtomicInteger(0);
    }

    public boolean acquire(int limit) {
        if (limit <= 0) {
            return false;
        }
        if (this.threadFlags.put(Thread.currentThread().getId(), Boolean.TRUE) == null) {
            return this.counter.incrementAndGet() <= limit;
        }
        return true;
    }

    public int getCurrentCount() {
        return this.counter.get();
    }

    @Override
    public void close() {
        if (this.threadFlags.remove(Thread.currentThread().getId()) != null) {
            this.counter.decrementAndGet();
        }
    }
}

