/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import com.alibaba.fastjson.JSON;
import java.util.concurrent.RejectedExecutionException;
import kd.bos.bal.business.consumer.BalTxNotifyTask;
import kd.bos.bal.business.consumer.NotifyMsg;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalPoolUtil;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.threads.DynamicExecutorService;
import org.apache.commons.lang3.StringUtils;

public class BalTxNotifyConsumer
implements MessageConsumer {
    private NotifyMsg buildNotifyMsg(Object param) {
        if (param instanceof String) {
            try {
                NotifyMsg info = (NotifyMsg)JSON.parseObject((String)((String)param), NotifyMsg.class);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{info.getDbKey(), info.getAppId()})) {
                    return info;
                }
                throw new RuntimeException("MsgInfo parse illegal");
            }
            catch (Throwable e) {
                BalLogUtil.saveError("BalTxNotifyConsumer", String.valueOf(param), "buildNotifyMsg", e);
            }
        } else {
            BalLogUtil.info("BalTxNotifyConsumer.buildNotifyMsg illegal param = " + (param == null ? "null" : param.getClass().getName()), new Object[0]);
        }
        return null;
    }

    public void mockMsg(String jsonMsg) {
        BalLogUtil.info("BalTxNotifyConsumer.mockMsg start", new Object[0]);
        this.onMessage(jsonMsg, "", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object param, String messageId, boolean resend, MessageAcker acker) {
        NotifyMsg info = null;
        try {
            BalLogUtil.info("BalTxNotifyConsumer.onMessage start: " + param, new Object[0]);
            info = this.buildNotifyMsg(param);
            if (info == null) {
                return;
            }
            this.executeTask(info);
            BalLogUtil.info("BalTxNotifyConsumer.onMessage end", new Object[0]);
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalTxNotifyConsumer", String.valueOf(info == null ? "null" : info), "onMessage", e);
        }
        finally {
            if (acker != null) {
                acker.ack(messageId);
            }
        }
    }

    private void executeTask(NotifyMsg info) {
        BalConfig config = BalConfig.loadBalConfig(info.getBal());
        if (info.isPartAsyncMsg()) {
            if (config.getTxMsgSemaphore() <= 0) {
                BalLogUtil.warn("BalTxNotifyConsumer.executeTask TxMsgSemaphore <= 0", new Object[0]);
                return;
            }
        } else if (config.getReUpdateMsgSemaphore() <= 0) {
            BalLogUtil.warn("BalTxNotifyConsumer.executeTask ReUpdateMsgSemaphore <= 0", new Object[0]);
            return;
        }
        DynamicExecutorService exec = BalPoolUtil.getNotifyExecutor();
        BalTxNotifyTask task = new BalTxNotifyTask(info);
        try {
            exec.execute((Runnable)task);
        }
        catch (RejectedExecutionException e) {
            exec = BalPoolUtil.getNotifyExecutor(info.getDLockKey(), true);
            exec.execute((Runnable)task);
        }
    }
}

