/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;

public class NotifyMsg
implements Serializable {
    private static final long serialVersionUID = -5008072344421915209L;
    private String dbKey;
    private String appId;
    private String bal;
    private boolean partAsyncMsg;
    private AtomicInteger counter;
    private volatile long time;

    public NotifyMsg(String dbKey, String appId, String bal, boolean partAsyncMsg) {
        this.dbKey = dbKey;
        this.appId = appId;
        this.bal = bal;
        this.partAsyncMsg = partAsyncMsg;
    }

    public String getDLockKey() {
        return this.bal + "_" + this.dbKey + (this.partAsyncMsg ? "_part" : "_all");
    }

    public boolean isOverTime(long ms) {
        return System.currentTimeMillis() - this.time > ms;
    }

    public void setTime() {
        this.time = System.currentTimeMillis();
    }

    public NotifyMsg setCounter(AtomicInteger counter) {
        this.counter = counter;
        return this;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public static Collection<NotifyMsg> buildNotifyMsg(DynamicObject[] occDbInfos) {
        HashSet<NotifyMsg> msgs = new HashSet<NotifyMsg>(8);
        try {
            HashMap<String, String> balAppMap = new HashMap<String, String>(8);
            for (DynamicObject data : occDbInfos) {
                String db = data.getString("db");
                String app = data.getString("app");
                String bal = data.getString("bal.id");
                String type = data.getString("type");
                if ("2".equals(type)) {
                    msgs.add(new NotifyMsg(db, app, bal, true));
                    balAppMap.put(bal, app);
                    continue;
                }
                if (!"1".equals(type)) continue;
                msgs.add(new NotifyMsg(db, app, bal, false));
            }
            for (Map.Entry entry : balAppMap.entrySet()) {
                MainEntityType balType = MetadataServiceHelper.getDataEntityType((String)((String)entry.getKey()));
                msgs.add(new NotifyMsg(balType.getDBRouteKey(), (String)entry.getValue(), (String)entry.getKey(), true));
            }
        }
        catch (Exception e) {
            BalLogUtil.saveError("NotifyMsg", null, "buildNotifyMsg", e);
        }
        return msgs;
    }

    public String getDbKey() {
        return this.dbKey;
    }

    public void setDbKey(String dbKey) {
        this.dbKey = dbKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getBal() {
        return this.bal;
    }

    public boolean isPartAsyncMsg() {
        return this.partAsyncMsg;
    }

    public String toString() {
        return "NotifyMsg{dbKey='" + this.dbKey + '\'' + ", appId='" + this.appId + '\'' + ", bal='" + this.bal + '\'' + ", partAsyncMsg=" + this.partAsyncMsg + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotifyMsg notifyMsg = (NotifyMsg)o;
        return this.partAsyncMsg == notifyMsg.partAsyncMsg && Objects.equals(this.dbKey, notifyMsg.dbKey) && Objects.equals(this.appId, notifyMsg.appId) && Objects.equals(this.bal, notifyMsg.bal);
    }

    public int hashCode() {
        return Objects.hash(this.dbKey, this.appId, this.bal, this.partAsyncMsg);
    }
}

