/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalPoolUtil;
import kd.bos.bal.common.BalTaskUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class BalSparseTaskHandle {
    protected final String taskEntity;
    protected final String subTaskEntity;
    protected final String taskGroup;

    protected BalSparseTaskHandle(String taskEntity, String subTaskEntity, String taskGroup) {
        this.taskEntity = taskEntity;
        this.subTaskEntity = subTaskEntity;
        this.taskGroup = taskGroup;
    }

    private void doBuildTask(DynamicObject taskInfo) {
        try {
            this.addTask(taskInfo);
        }
        catch (Throwable e) {
            this.delTask(taskInfo);
            throw e;
        }
        this.publishTask(taskInfo);
    }

    public void buildTask(DynamicObject taskInfo) {
        try {
            String key = this.taskEntity + "_" + taskInfo.getPkValue();
            try (DLock lock = DLock.create((String)key);){
                if (lock.tryLock()) {
                    this.checkTask(taskInfo);
                    this.setTaskUpdating(taskInfo);
                    this.doBuildTask(taskInfo);
                } else {
                    BalLogUtil.info("BalSparseTaskHandle.buildTask tryLock failed : key = " + key, new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            try (TXHandle tx = TX.requiresNew();){
                taskInfo.set("errorinfo_tag", (Object)BalLogUtil.parseMsg(e, 1600));
                if (!"B".equals(taskInfo.getString("opresult"))) {
                    taskInfo.set("opresult", (Object)"C");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
            }
        }
    }

    protected void checkTask(DynamicObject taskInfo) {
    }

    private void setTaskUpdating(DynamicObject taskInfo) {
        taskInfo.set("opresult", (Object)"A");
        taskInfo.set("errorinfo_tag", null);
        taskInfo.set("traceid", (Object)TraceIdUtil.getCurrentTraceIdString());
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumerTask(TaskMsg msg) {
        DynamicObject taskInfo;
        block19: {
            taskInfo = null;
            taskInfo = BusinessDataServiceHelper.loadSingle((Object)msg.getTaskId(), (String)this.subTaskEntity);
            if (taskInfo != null) break block19;
            BalLogUtil.info("TaskMsg not exsist:" + msg, new Object[0]);
            this.consume4finally(msg, taskInfo);
            return;
        }
        try {
            String lockKey = this.getLockKey4Consumer(msg, taskInfo);
            try (DLock lock = DLock.create((String)lockKey);){
                if (lock.tryLock()) {
                    taskInfo.set("tasktraceid", (Object)TraceIdUtil.getCurrentTraceIdString());
                    taskInfo.set("errormsg_tag", null);
                    taskInfo.set("param_tag", null);
                    this.handleTaskMsg(msg, taskInfo);
                } else {
                    String errorMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u4efb\u52a1\u5df2\u88ab\u4ed6\u4eba\u53d1\u8d77\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u5237\u65b0\u7ed3\u679c\u6216\u51e0\u5206\u949f\u540e\u91cd\u8bd5\u3002", (String)"BalSparseTaskHandle_0", (String)"bos-biz-balance", (Object[])new Object[0]);
                    taskInfo.set("errormsg_tag", (Object)("DLock=" + lockKey + errorMsg));
                    taskInfo.set("status", (Object)"E");
                    BalLogUtil.info("BalSparseTaskHandle getlock faild : " + lockKey, new Object[0]);
                }
            }
            this.consume4finally(msg, taskInfo);
        }
        catch (Throwable e) {
            try {
                this.consume4Error(e, msg, taskInfo);
                this.consume4finally(msg, taskInfo);
            }
            catch (Throwable throwable) {
                this.consume4finally(msg, taskInfo);
                throw throwable;
            }
        }
    }

    protected void consume4Error(Throwable e, TaskMsg msg, DynamicObject taskInfo) {
        BalLogUtil.error("BalSparseTaskHandle.onMessage error", e);
        if (taskInfo != null) {
            taskInfo.set("status", (Object)"E");
            taskInfo.set("errormsg_tag", (Object)BalLogUtil.parseMsg(e, 1600));
        }
    }

    protected void consume4finally(TaskMsg msg, DynamicObject taskInfo) {
        if (taskInfo != null) {
            try (TXHandle tx = TX.requiresNew();){
                taskInfo.set("runstatus", (Object)"2");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
            }
        }
    }

    protected String getLockKey4Consumer(TaskMsg msg, DynamicObject taskInfo) {
        return this.subTaskEntity + "_" + msg.getTaskId();
    }

    protected abstract void handleTaskMsg(TaskMsg var1, DynamicObject var2);

    protected abstract void addTask(DynamicObject var1);

    private void delTask(DynamicObject taskInfo) {
        MainEntityType task = MetadataServiceHelper.getDataEntityType((String)this.subTaskEntity);
        String tb = task.getAlias();
        String parentTaskCol = task.findProperty("parenttask").getAlias();
        String sql = "DELETE FROM " + tb + " WHERE " + parentTaskCol + "=" + taskInfo.getLong("id");
        taskInfo.set("opresult", (Object)"C");
        try (TXHandle tx = TX.requiresNew((String)"updateSubTaskStatus");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)task.getDBRouteKey()), (String)sql);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void publishTask(DynamicObject taskInfo) {
        ArrayList<TaskMsg> msgs = new ArrayList<TaskMsg>(16);
        long parentTaskId = taskInfo.getLong("id");
        QFilter fs = new QFilter("parenttask", "=", (Object)parentTaskId);
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"publishTask", (String)this.subTaskEntity, (String)"id,msgappid", (QFilter[])fs.toArray(), null);){
            for (Row row : data) {
                String msgAppId = row.getString("msgappid");
                if (!StringUtils.isNotBlank((CharSequence)msgAppId)) continue;
                msgs.add(new TaskMsg(msgAppId, row.getLong("id"), null).setTaskGroup(this.taskGroup));
            }
        }
        BalTaskUtil.publishTasks(msgs);
        this.updateSubTaskStatus(taskInfo);
        this.markTaskBusy(msgs);
    }

    private void markTaskBusy(List<TaskMsg> msgs) {
        List ids = msgs.stream().filter(t -> !t.isPubSuccess()).map(TaskMsg::getTaskId).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            MainEntityType task = MetadataServiceHelper.getDataEntityType((String)this.subTaskEntity);
            String tb = task.getAlias();
            String statusCol = task.findProperty("status").getAlias();
            String runStatusCol = task.findProperty("runstatus").getAlias();
            String sql = "UPDATE " + tb + " SET " + runStatusCol + "='3' WHERE FID " + QFUtil.getIdsFilter(ids) + " AND " + statusCol + "='A' ";
            try (TXHandle tx = TX.requiresNew((String)"markTaskBusy");){
                try {
                    DB.execute((DBRoute)DBRoute.of((String)task.getDBRouteKey()), (String)sql);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private void updateSubTaskStatus(DynamicObject taskInfo) {
        MainEntityType task = MetadataServiceHelper.getDataEntityType((String)this.subTaskEntity);
        String tb = task.getAlias();
        String statusCol = task.findProperty("status").getAlias();
        String runStatusCol = task.findProperty("runstatus").getAlias();
        String parentTaskCol = task.findProperty("parenttask").getAlias();
        String sql = "UPDATE " + tb + " SET " + statusCol + "='B'," + runStatusCol + "='1' WHERE " + parentTaskCol + "=" + taskInfo.getLong("id") + " AND " + statusCol + "='A' ";
        taskInfo.set("opresult", (Object)"B");
        try (TXHandle tx = TX.requiresNew((String)"updateSubTaskStatus");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)task.getDBRouteKey()), (String)sql);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    protected void buildTask(List<Callable<String>> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        ArrayList<Future<String>> results = new ArrayList<Future<String>>(tasks.size());
        for (Callable<String> task : tasks) {
            results.add(BalPoolUtil.submitByOtherExecutor(task));
        }
        Throwable t = null;
        for (Future future : results) {
            try {
                future.get(30L, TimeUnit.MINUTES);
            }
            catch (Throwable e) {
                BalLogUtil.error("BalSparseTaskHandle.buildTask error", e);
                t = e;
            }
        }
        if (t != null) {
            throw new RuntimeException("BalSparseTaskHandle.buildTask error", t);
        }
    }
}

