/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.business.core.BalManager;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.TxInfo;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.db.tx.CommitListener;

class BalTxListener
implements CommitListener {
    private UpdateCtx ctx;

    BalTxListener(UpdateCtx ctx) {
        this.ctx = ctx;
    }

    public void onRollbacked() {
        boolean rollBackOver = this.ctx.isRollBackOver();
        BalLogUtil.info("BalTxListener.onRollbacked start: isRollBackOver = " + rollBackOver, new Object[0]);
        if (!rollBackOver) {
            BalManager.doRollBackData(this.ctx);
        }
    }

    public void onCommitted() {
        try {
            this.tryMarkSpDataReadable();
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalTxListener", null, "onCommitted", e);
        }
    }

    private void tryMarkSpDataReadable() {
        Map<Long, TxInfo> txInfo = this.ctx.getTxInfo();
        HashMap<BalanceTB, ArrayList<Long>> txMap = new HashMap<BalanceTB, ArrayList<Long>>(4);
        for (TxInfo txInfo2 : txInfo.values()) {
            if (txInfo2.isSync()) continue;
            UpdateRule rule = txInfo2.getRule();
            BalanceTB bal = rule.getBalanceTB();
            if ("2".equals(rule.getReadableType())) {
                ArrayList<Long> txs = (ArrayList<Long>)txMap.get(bal);
                if (txs == null) {
                    txs = new ArrayList<Long>(8);
                    txMap.put(bal, txs);
                }
                txs.add(txInfo2.getTxid());
                continue;
            }
            if (!"1".equals(rule.getReadableType())) continue;
            BalEngineUtil.addTx2ThreadLocal(bal.getName(), txInfo2.getTxid());
        }
        for (Map.Entry entry : txMap.entrySet()) {
            BalManager.tryMarkSpDataReadable((BalanceTB)entry.getKey(), (List)entry.getValue());
        }
    }

    public void onEnded(boolean rollbacked) {
        try {
            BalManager.publishTx(this.ctx);
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalTxListener", String.format("db=%s, appId=%s", this.ctx.getBillType().getDBRouteKey(), this.ctx.getBillType().getAppId()), "onEnded", e);
        }
    }
}

