/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;

class BalanceLog {
    private static final String T_LOG = "bal_balance_log";
    private static final String F_BILL_NAME = "billname";
    private static final String F_BILL_IDS_TAG = "billids_tag";
    private static final String F_OP = "op";
    private static final String F_TYPE = "type";
    private static final String F_USE_TIME = "usetime";
    private static final String F_START = "start";
    private static final String F_RESULT = "result";
    private static final String F_CREATER = "creater";
    private static final String F_TRACEID = "traceid";
    private static final String E = "detail";
    private static final String EF_RULE_NO = "ruleno";
    private static final String EF_SEQ = "seq";
    private static final String EF_DB_RUTE = "dbrute";
    private static final String EF_UPDATE_TYPE = "updatetype";
    private static final String EF_RULE_START = "rulestart";
    private static final String EF_RULE_USE_TIME = "ruleusetime";
    private static final String EF_SPDATA_COUNT = "spdatacount";
    private static final String EF_RULE_PLUGIN_TIME = "ruleplugintime";
    private static final String EF_RULE_MSG = "rulemsg";
    private static final String F_HEAD_MSG = "headmsg";
    private static final String EF_RULE_RESULT = "ruleresult";
    private static final String RESULT_UNEXECUTED = "2";
    private static final String RESULT_SUCCESS = "1";
    private static final String RESULT_FAIL = "0";
    private static final String RESULT_TRY_UNEXECUTED = "5";
    private static final String RESULT_TRY_SUCCESS = "3";
    private static final String RESULT_TRY_FAIL = "4";
    private static final String TYPE_UPDATE = "1";
    private static final String TYPE_ROLLBACK = "0";
    private static final String TYPE_ASYNC_TASK = "2";
    private Date start = TimeServiceHelper.now();
    private DynamicObject info;
    private Map<String, DynamicObject> detailMap;
    private Map<String, DynamicObject> reTryDetailMap;

    public BalanceLog() {
        BalLogUtil.info("BalanceLog.init", new Object[0]);
    }

    private void initLog(UpdateCtx ctx) {
        if (this.info == null) {
            this.info = BusinessDataServiceHelper.newDynamicObject((String)T_LOG);
            this.info.set(F_BILL_NAME, (Object)ctx.getEntityNumber());
            this.info.set(F_BILL_IDS_TAG, (Object)SerializationUtils.toJsonString(ctx.getBillIds()));
            this.info.set(F_OP, (Object)ctx.getOpAlias());
            this.info.set(F_TYPE, (Object)(ctx.isBizRollback() ? "0" : "1"));
            this.info.set(F_START, (Object)this.start);
            this.info.set(F_TRACEID, (Object)TraceIdUtil.getCurrentTraceIdString());
            this.info.set(F_RESULT, (Object)"1");
            this.info.set(F_CREATER, (Object)RequestContext.getOrCreate().getCurrUserId());
        }
    }

    public void startReTryLog(List<UpdateRule> rules, UpdateCtx ctx) {
        DynamicObjectCollection details = this.info.getDynamicObjectCollection(E);
        DynamicObject detail = null;
        String ruleNo = null;
        this.reTryDetailMap = new HashMap<String, DynamicObject>(rules.size());
        int seq = this.detailMap.size() + 1;
        for (UpdateRule rule : rules) {
            detail = details.addNew();
            ruleNo = rule.getId();
            this.reTryDetailMap.put(ruleNo, detail);
            detail.set(EF_SEQ, (Object)seq++);
            detail.set(EF_RULE_NO, (Object)ruleNo);
            detail.set(EF_DB_RUTE, (Object)rule.getBalanceTB().getDbRoute().getRouteKey());
            detail.set(EF_RULE_RESULT, (Object)RESULT_TRY_UNEXECUTED);
        }
    }

    public void startLog(Collection<UpdateRule> rules, UpdateCtx ctx) {
        this.initLog(ctx);
        DynamicObjectCollection details = this.info.getDynamicObjectCollection(E);
        this.detailMap = new HashMap<String, DynamicObject>(rules.size());
        int seq = 1;
        for (UpdateRule rule : rules) {
            DynamicObject detail = details.addNew();
            String ruleNo = rule.getId();
            this.detailMap.put(ruleNo, detail);
            detail.set(EF_SEQ, (Object)seq++);
            detail.set(EF_RULE_NO, (Object)ruleNo);
            detail.set(EF_DB_RUTE, (Object)rule.getBalanceTB().getDbRoute().getRouteKey());
            detail.set(EF_RULE_RESULT, (Object)"2");
            detail.set(EF_UPDATE_TYPE, (Object)rule.getBalanceTB().getUpdateType());
        }
    }

    public void startRule(UpdateRule rule) {
        this.startRule(rule, false);
    }

    public void startRule(UpdateRule rule, boolean isReTry) {
        DynamicObject entry = isReTry ? this.reTryDetailMap.get(rule.getId()) : this.detailMap.get(rule.getId());
        entry.set(EF_RULE_START, (Object)TimeServiceHelper.now());
    }

    private long getUseTime(Date start) {
        Date now = TimeServiceHelper.now();
        return now.getTime() - start.getTime();
    }

    public void setSuccess(UpdateRule rule, long pluginTime, int spDataCount) {
        this.setSuccess(rule, pluginTime, spDataCount, false);
    }

    public void setSuccess(UpdateRule rule, long pluginTime, int spDataCount, boolean isReTry) {
        DynamicObject entry = isReTry ? this.reTryDetailMap.get(rule.getId()) : this.detailMap.get(rule.getId());
        entry.set(EF_RULE_RESULT, (Object)(isReTry ? RESULT_TRY_SUCCESS : "1"));
        entry.set(EF_RULE_PLUGIN_TIME, (Object)pluginTime);
        entry.set(EF_SPDATA_COUNT, (Object)spDataCount);
        entry.set(EF_RULE_USE_TIME, (Object)this.getUseTime(entry.getDate(EF_RULE_START)));
    }

    public void setFail(UpdateRule rule, long pluginTime, int spDataCount, Throwable ex) {
        this.setFail(rule, pluginTime, spDataCount, ex, false);
    }

    public void setFail(UpdateRule rule, long pluginTime, int spDataCount, Throwable ex, boolean isReTry) {
        DynamicObject entry = isReTry ? this.reTryDetailMap.get(rule.getId()) : this.detailMap.get(rule.getId());
        entry.set(EF_RULE_RESULT, (Object)(isReTry ? RESULT_TRY_FAIL : "0"));
        entry.set(EF_RULE_PLUGIN_TIME, (Object)pluginTime);
        entry.set(EF_SPDATA_COUNT, (Object)spDataCount);
        entry.set(EF_RULE_USE_TIME, (Object)this.getUseTime(entry.getDate(EF_RULE_START)));
        entry.set(EF_RULE_MSG, (Object)BalLogUtil.parseMsg(ex, 1600));
    }

    public void setFail(UpdateCtx ctx, Throwable e) {
        this.initLog(ctx);
        this.info.set(F_RESULT, (Object)"0");
        this.info.set(F_HEAD_MSG, (Object)BalLogUtil.parseMsg(e, 1600));
    }

    public void setTypeAsyncTask() {
        if (this.info == null) {
            return;
        }
        this.info.set(F_TYPE, (Object)"2");
    }

    public void save() {
        BalLogUtil.info("BalanceLog.save", new Object[0]);
        if (this.info == null) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"BalanceLog-save");){
            try {
                this.info.set(F_USE_TIME, (Object)this.getUseTime(this.start));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.info});
            }
            catch (Throwable e) {
                tx.markRollback();
                BalLogUtil.saveError("BalanceLog", null, "save", e);
            }
        }
    }
}

