/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.business.core.SpDataReduceGroup;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.balance.BizDataType;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import org.apache.commons.lang3.StringUtils;

abstract class SpDataHandle {
    protected final BalanceTB bal;
    protected final TreeSet<Long> txIds;
    protected volatile boolean hasError;
    private final Date modifyTime;
    private final String modifyTimeCol;
    private final Set<String> coverCols;
    protected final int moveUpdateBatch;
    protected final int moveTpDataBatch;
    protected final int moveKeycolBatch;
    protected final int moveMaxQueryBatch;
    private final boolean forceSelectForUpdate;
    protected final boolean ignoreCover4Zero;
    private final boolean mergeSql;
    private String txFs;

    public SpDataHandle(BalanceTB bal, TreeSet<Long> txIds) {
        this.bal = bal;
        this.txIds = txIds;
        this.modifyTimeCol = bal.getModifyTimeCol();
        this.coverCols = bal.getCoverCols();
        this.modifyTime = new Date();
        BalConfig cfg = BalConfig.loadBalConfig(bal.getName());
        this.moveUpdateBatch = bal.isRealBal() ? cfg.getMoveUpdateRealBatch() : cfg.getMoveUpdatePerBatch();
        this.moveTpDataBatch = cfg.getMoveTpDataBatch();
        this.moveKeycolBatch = cfg.getMoveKeycolBatch();
        this.mergeSql = cfg.isMergeSql();
        this.moveMaxQueryBatch = cfg.getMoveMaxQueryBatch();
        this.ignoreCover4Zero = cfg.isIgnoreCover4Zero();
        this.forceSelectForUpdate = cfg.isForceSelectForUpdate();
    }

    protected String getTxFs() {
        if (this.txFs == null) {
            this.txFs = QFUtil.getIdsFilter(this.txIds);
        }
        return this.txFs;
    }

    protected DataSet queryTempSpData(StringBuilder whereCondition, int top) {
        Set<String> qtyCols = this.getBalQtyCols(this.bal);
        Set<String> otherCols = this.bal.getColsByDataType(BizDataType.COVER, BizDataType.PER);
        int size = qtyCols.size() + otherCols.size() + 5;
        ArrayList<String> colExprs = new ArrayList<String>(size);
        colExprs.add(this.buildColExpr("fid", "id"));
        colExprs.add(this.buildColExpr("fkeycol", "keycol"));
        colExprs.add(this.buildColExpr("fupdatetime", "updatetime"));
        colExprs.add(this.buildColExpr("fupdateruleid", "updaterule"));
        colExprs.add(this.buildColExpr("fmovetype", "movetype"));
        colExprs.add(this.buildColExpr("fcoverflag", "coverflag"));
        Map<String, String> colFieldMap = this.bal.getColFieldMap();
        for (String qtyCol : qtyCols) {
            colExprs.add(this.buildColExpr(BalanceTB.parse2SnapName(colFieldMap.get(qtyCol)), qtyCol));
        }
        for (String otherCol : otherCols) {
            colExprs.add(this.buildColExpr(colFieldMap.get(otherCol), otherCol));
        }
        StringBuilder sql = new StringBuilder();
        if (top > 0) {
            sql.append(" SELECT TOP ").append(top).append(' ');
        } else {
            sql.append(" SELECT ");
        }
        sql.append(String.join((CharSequence)",", colExprs)).append(" FROM ").append(this.bal.getTmpSnapshotTb());
        sql.append(" WHERE ").append((CharSequence)whereCondition);
        DataSet spData = DB.queryDataSet((String)"MoveSnapshotTask.queryTempSpData", (DBRoute)this.bal.getDbRoute(), (String)sql.toString());
        spData = this.transformSpData(spData);
        return spData;
    }

    private DataSet transformSpData(DataSet spData) {
        String[] stringArray;
        String[] stringArray2;
        Set<String> coverCols = this.bal.getCoverCols();
        spData = this.addCols(spData, coverCols);
        Set<String> qtyCols = this.getBalQtyCols(this.bal);
        boolean isPerBal = "period".equals(this.bal.getType());
        if (isPerBal) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "keycol";
            stringArray2 = stringArray3;
            stringArray3[1] = this.bal.getPeriodCol();
        } else {
            String[] stringArray4 = new String[1];
            stringArray2 = stringArray4;
            stringArray4[0] = "keycol";
        }
        String[] groupKeys = stringArray2;
        GroupbyDataSet groupData = spData.groupBy(groupKeys);
        spData = groupData.reduceGroup((ReduceGroupFunctionWithCollector)new SpDataReduceGroup(spData.getRowMeta(), coverCols, qtyCols, this.bal.getName()));
        if (isPerBal) {
            Set<String> initQtyCols = this.bal.getColsByDataType(BizDataType.INIT);
            ArrayList<String> exprs = new ArrayList<String>(qtyCols.size() + 2);
            ArrayList<String> names = new ArrayList<String>(qtyCols.size() + 2);
            for (String qtyCol : initQtyCols) {
                exprs.add(qtyCol + " + " + qtyCol + "_in" + " - " + qtyCol + "_out");
                names.add(qtyCol + "_bal");
            }
            Set<String> yearQtyCols = this.bal.getColsByDataType(BizDataType.YEAR_IN, BizDataType.YEAR_OUT);
            if (!yearQtyCols.isEmpty()) {
                exprs.add(this.bal.getPeriodCol() + "/100*100");
                names.add("per_year_start");
                exprs.add(this.bal.getPeriodCol() + "/100*100 + 100");
                names.add("per_year_end");
            }
            spData = spData.addFields(exprs.toArray(new String[0]), names.toArray(new String[0]));
        }
        if (isPerBal) {
            String[] stringArray5 = new String[2];
            stringArray5[0] = "keycol ASC";
            stringArray = stringArray5;
            stringArray5[1] = this.bal.getPeriodCol() + " ASC";
        } else {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = "keycol ASC";
        }
        String[] orderBy = stringArray;
        return spData.orderBy(orderBy);
    }

    private Set<String> getBalQtyCols(BalanceTB bal) {
        return bal.getColsByDataType(BizDataType.OCC, BizDataType.IN, BizDataType.INIT, BizDataType.OUT);
    }

    private DataSet addCols(DataSet spData, Set<String> coverCols) {
        int idx = 2;
        int len = coverCols.size() + idx;
        String[] exprs = new String[len];
        String[] names = new String[len];
        exprs[0] = "''";
        names[0] = "ids_move";
        exprs[1] = "''";
        names[1] = "ids_del";
        if (!coverCols.isEmpty()) {
            for (String coverCol : coverCols) {
                exprs[idx] = "'0'";
                names[idx] = BalanceTB.parseCoverFlag(coverCol);
                ++idx;
            }
        }
        spData = spData.addFields(exprs, names);
        return spData;
    }

    protected String buildColExpr(String name, String asName) {
        return name + " " + asName;
    }

    protected void batchUpdateBal(DataSet details, boolean isRollback) {
        Set<String> qtyCols = this.bal.getColsByDataType(BizDataType.OCC, BizDataType.YEAR_IN, BizDataType.YEAR_OUT, BizDataType.INIT, BizDataType.IN, BizDataType.OUT, BizDataType.BAL);
        if (isRollback) {
            details = this.negateQty(details, qtyCols);
        }
        if (this.mergeSql) {
            this.updateByMergeSql(details, qtyCols, isRollback);
        } else {
            this.updateByPartSql(details, qtyCols, isRollback);
        }
    }

    protected DataSet negateQty(DataSet details, Set<String> qtyCols) {
        String[] fields = details.getRowMeta().getFieldNames();
        ArrayList<String> cols = new ArrayList<String>(qtyCols.size());
        ArrayList<String> exprs = new ArrayList<String>(qtyCols.size());
        for (String field : fields) {
            if (!qtyCols.contains(field.toLowerCase(Locale.ENGLISH))) continue;
            cols.add(field);
            exprs.add("-" + field);
        }
        return details.updateFields(cols.toArray(new String[0]), exprs.toArray(new String[0]));
    }

    private void updateByMergeSql(DataSet details, Set<String> qtyCols, boolean isRollback) {
        Map<String, List<String>> updateSql = this.bal.getUpdateSql(isRollback);
        if (updateSql == null) {
            this.updateByPartSql(details, qtyCols, isRollback);
        } else {
            this.updateByMergeSql(updateSql, details, qtyCols);
        }
    }

    private void updateByMergeSql(Map<String, List<String>> mergedSql, DataSet details, Set<String> qtyCols) {
        HashMap<String, List<Object[]>> paramGroups = new HashMap<String, List<Object[]>>(1);
        ArrayList<String> updateSqls = new ArrayList<String>(mergedSql.keySet());
        IDInfos idInfos = new IDInfos();
        int count = 0;
        HashSet<String> keycolHints = new HashSet<String>();
        int keycolIdx = details.getRowMeta().getFieldIndex("keycol");
        for (Row row : details) {
            int hasParam = this.handleParams(mergedSql, paramGroups, qtyCols, row, 4);
            this.handleIDInfos(idInfos, row);
            keycolHints.add(row.getString(keycolIdx));
            if (hasParam <= 0 || ++count < this.moveUpdateBatch) continue;
            this.batchExecuteUpdate(updateSqls, paramGroups, idInfos, keycolHints);
            idInfos.clear();
            keycolHints.clear();
            count = 0;
        }
        this.batchExecuteUpdate(updateSqls, paramGroups, idInfos, keycolHints);
    }

    protected abstract void handleIDInfos(IDInfos var1, Row var2);

    protected abstract void batchMoveSpData(IDInfos var1);

    protected void parseIdsMove(IDInfos idInfos, Row row) {
        String ids = row.getString("ids_move");
        this.parseLongIds(idInfos.idsMove, ids);
    }

    protected void parseIdsDel(IDInfos idInfos, Row row) {
        String ids = row.getString("ids_del");
        this.parseLongIds(idInfos.idsDel, ids);
    }

    private void parseLongIds(List<Long> ids, String idsStr) {
        if (StringUtils.isNotBlank((CharSequence)idsStr)) {
            String[] idStrs;
            for (String idStr : idStrs = idsStr.split(",")) {
                ids.add(Long.valueOf(idStr));
            }
        }
    }

    private void batchExecuteUpdate(List<String> updateSqls, Map<String, List<Object[]>> paramGroups) {
        for (String sql : updateSqls) {
            List<Object[]> params = paramGroups.get(sql);
            if (params == null || params.isEmpty()) continue;
            this.executeBatch(sql, params);
            params.clear();
        }
    }

    protected void batchExecuteUpdate(List<String> updateSqls, Map<String, List<Object[]>> paramGroups, IDInfos idInfos, Set<String> keycolHints) {
        if (this.bal.isPerBal()) {
            try (ShardingHintContext hintCtx = ShardingHintContext.createAndSet((String)this.bal.getTb(), (HintCondition[])new HintCondition[]{new HintCondition("fkeycol", "in", keycolHints)});){
                hintCtx.setBatchShardingEnabled(true);
                this.batchExecuteUpdate(updateSqls, paramGroups);
            }
        } else {
            this.batchExecuteUpdate(updateSqls, paramGroups);
        }
        this.batchMoveSpData(idInfos);
    }

    protected void clearSnapshotByIds(List<Long> spDataIds) {
        BalLogUtil.info("SpDataHandle.clearSnapshotByIds: spDataIds.size = {} ,forceSelectForUpdate = {}", spDataIds.size(), this.forceSelectForUpdate);
        if (spDataIds.isEmpty()) {
            return;
        }
        this.selectForUpdate(spDataIds);
        String sql = "DELETE " + this.bal.getTmpSnapshotTb() + " WHERE FID = ? ";
        ArrayList<Object[]> params = new ArrayList<Object[]>(Math.min(spDataIds.size(), this.moveTpDataBatch));
        for (Long id : spDataIds) {
            params.add(new Object[]{id});
            if (params.size() < this.moveTpDataBatch) continue;
            this.executeBatch(sql, params);
            params.clear();
        }
        if (!params.isEmpty()) {
            this.executeBatch(sql, params);
        }
    }

    private void selectForUpdate(List<Long> spDataIds) {
        if (this.forceSelectForUpdate) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("/*dialect*/SELECT FID FROM ", new Object[0]).append(this.bal.getTmpSnapshotTb(), new Object[0]).append(" WHERE ", new Object[0]);
            sql.appendIn("fid", spDataIds.toArray());
            sql.append(" FOR UPDATE ", new Object[0]);
            DB.execute((DBRoute)this.bal.getDbRoute(), (SqlBuilder)sql);
        }
    }

    protected void deleteOrUpdateOldSpData(List<Long> spDataIds) {
        if (spDataIds.isEmpty()) {
            return;
        }
        String spTb = this.bal.getSnapshotTb();
        boolean retainSpData = !"B".equals(this.bal.getSnapshotPolicy());
        StringBuilder delOrUpdate = new StringBuilder();
        if (retainSpData) {
            delOrUpdate.append("UPDATE ").append(spTb).append(" SET ").append("fstatus").append(" = 'B' , ").append("fmovetime").append(" = NOW() WHERE FID = ? ");
        } else {
            delOrUpdate.append("DELETE ").append(spTb).append(" WHERE FID = ? ");
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(Math.min(spDataIds.size(), this.moveTpDataBatch));
        String sql = delOrUpdate.toString();
        for (Long id : spDataIds) {
            params.add(new Object[]{id});
            if (params.size() < this.moveTpDataBatch) continue;
            this.executeBatch(sql, params);
            params.clear();
        }
        if (!params.isEmpty()) {
            this.executeBatch(sql, params);
        }
    }

    protected void moveNewSpData(List<Long> idsMove) {
        if (idsMove.isEmpty()) {
            return;
        }
        if (idsMove.size() <= this.moveTpDataBatch) {
            this.moveNewSpDataOneBatch(idsMove);
        } else {
            ArrayList<Long> batchIds = new ArrayList<Long>(this.moveTpDataBatch);
            for (Long id : idsMove) {
                batchIds.add(id);
                if (batchIds.size() < this.moveTpDataBatch) continue;
                this.moveNewSpDataOneBatch(batchIds);
                batchIds.clear();
            }
            if (!batchIds.isEmpty()) {
                this.moveNewSpDataOneBatch(batchIds);
            }
        }
    }

    private void moveNewSpDataOneBatch(List<Long> idsMove) {
        String spTb = this.bal.getSnapshotTb();
        String tpTb = this.bal.getTmpSnapshotTb();
        List<String> moveCols = this.buildMoveCols();
        SqlBuilder select = new SqlBuilder();
        String cols = StringUtils.join(moveCols, (String)",");
        select.append("SELECT ", new Object[0]).append(cols, new Object[0]).append(" FROM ", new Object[0]).append(tpTb, new Object[0]);
        select.append(" WHERE ", new Object[0]).appendIn("fid", idsMove.toArray());
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO ").append(spTb).append(" (").append(cols).append(',').append("fmovetime").append(") VALUES (");
        int len = moveCols.size();
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                insert.append(',');
            }
            insert.append('?');
        }
        insert.append(",?)");
        ArrayList<Object[]> params = new ArrayList<Object[]>(idsMove.size());
        Date now = new Date();
        try (DataSet datas = DB.queryDataSet((String)"SELECT_TPDATA", (DBRoute)this.bal.getDbRoute(), (SqlBuilder)select);){
            for (Row row : datas) {
                params.add(this.buildInsertParam(row, moveCols, now));
            }
        }
        if (!params.isEmpty()) {
            this.executeBatch(insert.toString(), params);
        }
    }

    private Object[] buildInsertParam(Row row, List<String> moveCols, Date now) {
        Object[] param = new Object[moveCols.size() + 1];
        int len = moveCols.size();
        for (int i = 0; i < len; ++i) {
            param[i] = row.get(moveCols.get(i));
        }
        param[moveCols.size()] = now;
        return param;
    }

    private List<String> buildMoveCols() {
        Set<String> spCols = this.bal.getColsByDataType(BizDataType.OCC, BizDataType.IN, BizDataType.INIT, BizDataType.OUT);
        Set<String> notSpCols = this.bal.getColsByDataType(BizDataType.COVER, BizDataType.PER);
        ArrayList<String> moveCols = new ArrayList<String>(spCols.size() + notSpCols.size() + 12);
        moveCols.add("fid");
        moveCols.add("fkeycol");
        moveCols.add("fbillname");
        moveCols.add("fbillid");
        moveCols.add("fentryid");
        moveCols.add("fupdatetime");
        moveCols.add("fstatus");
        moveCols.add("fupdatetype");
        moveCols.add("fbillno");
        moveCols.add("fentryseq");
        moveCols.add("fupdateruleid");
        moveCols.add("fcreatetime");
        Map<String, String> colFieldMap = this.bal.getColFieldMap();
        for (String spCol : spCols) {
            moveCols.add(BalanceTB.parse2SnapName(colFieldMap.get(spCol)));
        }
        for (String notSpCol : notSpCols) {
            moveCols.add(colFieldMap.get(notSpCol));
        }
        return moveCols;
    }

    private void executeBatch(String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)this.bal.getDbRoute(), (String)sql, params);
    }

    private void updateByPartSql(DataSet details, Set<String> qtyCols, boolean isRollback) {
        Map<String, List<String>> updateQtySqls = this.bal.getUpdateQtySql();
        Map<String, List<String>> updateCoverSqls = isRollback ? Collections.emptyMap() : this.bal.getUpdateCoverSqls();
        Map<String, List<String>> updateModifyTimeSqls = this.bal.getUpdateModifyTimeSql();
        HashMap<String, List<Object[]>> paramGroups = new HashMap<String, List<Object[]>>(8);
        ArrayList<String> updateSqls = new ArrayList<String>(updateQtySqls.size() + updateCoverSqls.size() + 1);
        updateSqls.addAll(updateModifyTimeSqls.keySet());
        updateSqls.addAll(updateCoverSqls.keySet());
        updateSqls.addAll(updateQtySqls.keySet());
        int count = 0;
        IDInfos idInfos = new IDInfos();
        HashSet<String> keycolHints = new HashSet<String>();
        int keycolIdx = details.getRowMeta().getFieldIndex("keycol");
        for (Row row : details) {
            int hasParam = this.handleParams(updateModifyTimeSqls, paramGroups, null, row, 3);
            hasParam += this.handleParams(updateCoverSqls, paramGroups, null, row, 2);
            this.handleIDInfos(idInfos, row);
            keycolHints.add(row.getString(keycolIdx));
            if ((hasParam += this.handleParams(updateQtySqls, paramGroups, qtyCols, row, 1)) <= 0 || ++count < this.moveUpdateBatch) continue;
            this.batchExecuteUpdate(updateSqls, paramGroups, idInfos, keycolHints);
            idInfos.clear();
            keycolHints.clear();
            count = 0;
        }
        this.batchExecuteUpdate(updateSqls, paramGroups, idInfos, keycolHints);
    }

    private int handleParams(Map<String, List<String>> updateSqls, Map<String, List<Object[]>> paramGroups, Set<String> qtyCols, Row row, int type) {
        boolean hasParam = false;
        for (Map.Entry<String, List<String>> entry : updateSqls.entrySet()) {
            Object[] param;
            String sql = entry.getKey();
            List<String> paramCols = entry.getValue();
            List<Object[]> params = paramGroups.get(sql);
            if (params == null) {
                params = new ArrayList<Object[]>(this.moveKeycolBatch);
                paramGroups.put(sql, params);
            }
            if ((param = this.parseParamByType(row, paramCols, qtyCols, type)) == null) continue;
            params.add(param);
            hasParam = true;
        }
        return hasParam ? 1 : 0;
    }

    private Object[] parseParamByType(Row row, List<String> paramCols, Set<String> qtyCols, int type) {
        switch (type) {
            case 1: {
                return BalEngineUtil.parseQtyParam(row, paramCols, qtyCols);
            }
            case 2: {
                return this.parseCoverParam(row, paramCols);
            }
            case 3: {
                return this.parseModifyTimeParam(row, paramCols);
            }
            case 4: {
                return this.parseAllColParam(row, paramCols, qtyCols);
            }
        }
        return null;
    }

    private Object[] parseCoverParam(Row row, List<String> paramCols) {
        Object[] params = new Object[paramCols.size()];
        int coverFlag = 0;
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            String col = paramCols.get(i);
            params[i] = row.get(col);
            if (!this.coverCols.contains(col)) continue;
            coverFlag += row.getInteger(BalanceTB.parseCoverFlag(col)).intValue();
        }
        return coverFlag > 0 ? params : null;
    }

    private Object[] parseModifyTimeParam(Row row, List<String> sqlCols) {
        Object[] param = new Object[sqlCols.size()];
        param[0] = this.modifyTime;
        for (int i = 1; i < sqlCols.size(); ++i) {
            param[i] = row.get(sqlCols.get(i));
        }
        return param;
    }

    private Object[] parseAllColParam(Row row, List<String> paramCols, Set<String> qtyCols) {
        Object[] params = new Object[paramCols.size()];
        boolean allZero = true;
        int coverFlag = 0;
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            String col = paramCols.get(i);
            if (qtyCols.contains(col)) {
                BigDecimal qty = row.getBigDecimal(col);
                if (allZero && qty.compareTo(BigDecimal.ZERO) != 0) {
                    allZero = false;
                }
                params[i] = qty;
                continue;
            }
            if (this.coverCols.contains(col)) {
                coverFlag += row.getInteger(BalanceTB.parseCoverFlag(col)).intValue();
                params[i] = row.get(col);
                continue;
            }
            params[i] = col.equals(this.modifyTimeCol) ? this.modifyTime : row.get(col);
        }
        return allZero && (this.ignoreCover4Zero || coverFlag == 0) ? null : params;
    }

    protected void applyTxLock(List<Object[]> params) {
        BalEngineUtil.lockUpdate(this.bal, params);
    }

    static class IDInfos {
        List<Long> idsMove = new ArrayList<Long>();
        List<Long> idsDel = new ArrayList<Long>();

        IDInfos() {
        }

        void clear() {
            this.idsMove.clear();
            this.idsDel.clear();
        }

        List<Long> getAllIds() {
            ArrayList<Long> allTempSpDataIds = new ArrayList<Long>(this.idsMove.size() + this.idsDel.size());
            allTempSpDataIds.addAll(this.idsMove);
            allTempSpDataIds.addAll(this.idsDel);
            return allTempSpDataIds;
        }
    }
}

