/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.SpDataHandle;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

class SpDataHandle4Sync
extends SpDataHandle {
    final boolean isRollback;

    SpDataHandle4Sync(BalanceTB bal, TreeSet<Long> txIds, boolean isRollback) {
        super(bal, txIds);
        this.isRollback = isRollback;
    }

    private void doRollback() {
        try (DataSet spData = this.getAllSpDataByTxs();){
            this.batchUpdateBal(spData, true);
        }
    }

    private void doUpdate() {
        try (DataSet spData = this.getAllSpDataByTxs();){
            this.batchUpdateBal(spData, false);
        }
    }

    private DataSet getAllSpDataByTxs() {
        StringBuilder where = new StringBuilder();
        where.append("fupdatetime").append(this.getTxFs());
        where.append(" AND ").append("fsync").append("='").append("1").append("' ");
        return this.queryTempSpData(where, -1);
    }

    @Override
    protected void batchExecuteUpdate(List<String> updateSqls, Map<String, List<Object[]>> paramGroups, SpDataHandle.IDInfos idInfos, Set<String> keycolHints) {
        block15: {
            if (this.isRollback) {
                try (TXHandle tx = TX.requiresNew((String)"SpDataHandle4Sync.batchExecuteUpdate");){
                    try {
                        super.batchExecuteUpdate(updateSqls, paramGroups, idInfos, keycolHints);
                        break block15;
                    }
                    catch (Throwable e) {
                        this.hasError = true;
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            super.batchExecuteUpdate(updateSqls, paramGroups, idInfos, keycolHints);
        }
    }

    @Override
    protected void handleIDInfos(SpDataHandle.IDInfos idInfos, Row row) {
        if (this.isRollback) {
            this.parseIdsMove(idInfos, row);
            this.parseIdsDel(idInfos, row);
        }
    }

    @Override
    protected void batchMoveSpData(SpDataHandle.IDInfos idInfos) {
        if (this.isRollback) {
            this.clearSnapshotByIds(idInfos.getAllIds());
        }
    }

    public void moveAndUpdate() {
        if (this.isRollback) {
            this.doRollback();
        } else {
            this.doUpdate();
        }
    }
}

