/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.repair;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.bal.common.BalLogUtil;
import org.apache.commons.lang3.StringUtils;

class RepairPoint
implements Serializable {
    private static final long serialVersionUID = 2125619058360519545L;
    private long idPoint;
    private long timePoint;

    public RepairPoint(long idPoint, long timePoint) {
        this.idPoint = idPoint;
        this.timePoint = timePoint;
    }

    public RepairPoint() {
    }

    public long getIdPoint() {
        return this.idPoint;
    }

    public void setIdPoint(long idPoint) {
        this.idPoint = idPoint;
    }

    public long getTimePoint() {
        return this.timePoint;
    }

    public void setTimePoint(long timePoint) {
        this.timePoint = timePoint;
    }

    static RepairPoint buildRepairPoint(String jsonStr) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        try {
            JSONObject object = JSONObject.parseObject((String)jsonStr);
            RepairPoint point = new RepairPoint();
            long idPoint = object.getLongValue("idPoint");
            if (idPoint == 0L) {
                idPoint = object.getLongValue("idPonit");
            }
            point.setIdPoint(idPoint);
            point.setTimePoint(object.getLongValue("timePoint"));
            return point;
        }
        catch (Throwable e) {
            BalLogUtil.error("RepairPoint", jsonStr, "buildRepairPoint", e);
            return null;
        }
    }

    String toJsonStr() {
        JSONObject data = new JSONObject();
        data.put("idPoint", (Object)this.getIdPoint());
        data.put("timePoint", (Object)this.getTimePoint());
        return data.toJSONString();
    }

    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "[idPoint=" + this.idPoint + ", timePoint=" + this.timePoint + "(" + format.format(new Date(this.timePoint)) + ")]";
    }
}

