/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.repair;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import kd.bos.bal.business.archive.BalPerRecordSplitManager;
import kd.bos.bal.business.repair.RepairBase;
import kd.bos.bal.business.repair.RepairTaskUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.balance.BizDataType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;

class RepairSpDataSumBal
extends RepairBase {
    private final BalanceTB bal;
    private final int splitPeriod;

    public RepairSpDataSumBal(DynamicObject taskInfo) {
        super(taskInfo);
        this.bal = BalanceTB.getBalanceTB(this.seqEntityName);
        this.splitPeriod = BalPerRecordSplitManager.getSplitPeriod(this.bal);
        this.checkSplitPeriod();
    }

    private void checkSplitPeriod() {
        if (this.bal.isPerBal() && this.splitPeriod > 0) {
            boolean hasYearCol;
            boolean bl = hasYearCol = !this.bal.getColsByDataType(BizDataType.YEAR_IN, BizDataType.YEAR_OUT).isEmpty();
            if (hasYearCol && this.splitPeriod % 100 != 1) {
                String msg = ResManager.loadKDString((String)"\u5e26\u5e74\u6536\u53d1\u5b57\u6bb5\u7684\u4f59\u989d\u8868\uff0c\u53ea\u80fd\u6309\u5e74\u7b2c\u4e00\u671f\u8bbe\u7f6e\u5f52\u6863\u671f\u95f4\u3002", (String)"BAL-E-0003", (String)"bos-biz-balance", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
        }
    }

    @Override
    public void checkData(TreeSet<Object> balIds) {
        List<String> keyCols = RepairTaskUtil.checkSpDataSumBal(this.bal, new ArrayList<Object>(balIds));
        this.resultId.addAll(keyCols);
    }

    @Override
    protected void repair4Check(List<?> keyCols) {
        RepairTaskUtil.repairSpDataSumBalByKey(this.bal, keyCols);
    }

    @Override
    protected void repairData(TreeSet<Object> balIds) {
        RepairTaskUtil.repairSpDataSumBal(this.bal, balIds);
    }

    @Override
    protected void handleFs() {
        if ("D".equals(this.opRange)) {
            this.appendFs(this.parseBalFs());
        } else if (this.point != null) {
            String modifyTimeCol = this.bal.getModifyTimeCol();
            if (modifyTimeCol != null) {
                this.appendFs(new QFilter(modifyTimeCol, ">=", (Object)new Date(this.point.getTimePoint())));
            } else {
                this.fromId = Math.max(this.point.getIdPoint(), this.fromId);
            }
        }
        if ("B".equals(this.taskMode)) {
            long l = this.fromId = this.lastSuccessId > this.fromId ? this.lastSuccessId : this.fromId;
        }
        if (this.bal.isPerBal()) {
            this.appendFs(new QFilter(this.bal.getEndPeriodCol(), "=", (Object)999999));
        }
    }

    @Override
    protected String getTaskType4Point() {
        return "C";
    }

    @Override
    protected String buildParamMsg() {
        String msg = super.buildParamMsg();
        if (this.bal.isPerBal()) {
            msg = msg + ", splitPeriod = " + this.splitPeriod;
        }
        return msg;
    }
}

