/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.sparse;

import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class SparseDataLoader {
    private final DynamicObject taskInfo;
    private final long fromId;
    private final long toId;
    private Object[] idSet;
    private QFilter otherFs;

    public SparseDataLoader setOtherFs(QFilter otherFs) {
        this.otherFs = otherFs;
        return this;
    }

    public void setIdSet(Object[] idSet) {
        this.idSet = idSet;
    }

    public SparseDataLoader(DynamicObject taskInfo, long fromId, long toId) {
        this.taskInfo = taskInfo;
        this.fromId = fromId;
        this.toId = toId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet<Long> getAllIds() {
        TreeSet<Long> ids = new TreeSet<Long>();
        if (this.fromId >= this.toId) {
            return ids;
        }
        try (DataSet data = null;){
            String dbKey = this.taskInfo.getString("sparseseq.dbkey");
            String tidCol = this.taskInfo.getString("sparseseq.sparsecol");
            String actualTb = this.taskInfo.getString("sparseseq.actualtb");
            String seqEntityName = this.taskInfo.getString("sparseseq.entity.id");
            String seqEntityTb = this.taskInfo.getString("sparseseq.entitytb");
            if (this.otherFs == null) {
                SqlBuilder sql = new SqlBuilder();
                sql.append("SELECT", new Object[0]).append(tidCol, new Object[0]).append("id", new Object[0]).append("FROM", new Object[0]);
                sql.append(actualTb, new Object[0]).append("WHERE", new Object[0]).append(tidCol + ">=?", new Object[]{this.fromId});
                sql.append("AND", new Object[0]).append(tidCol + "<?", new Object[]{this.toId});
                if (this.idSet != null) {
                    sql.append("AND", new Object[0]).appendIn(tidCol, this.idSet);
                }
                data = DB.queryDataSet((String)"getAllIdsById", (DBRoute)DBRoute.of((String)dbKey), (SqlBuilder)sql);
            } else {
                HintCondition hint = null;
                if (!actualTb.equals(seqEntityTb)) {
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("SELECT TOP 1", new Object[0]).append(tidCol, new Object[0]).append("id", new Object[0]).append("FROM", new Object[0]).append(actualTb, new Object[0]).append("WHERE", new Object[0]).append(tidCol, new Object[0]).append("!=0", new Object[0]);
                    long hintId = 0L;
                    try (DataSet idData = DB.queryDataSet((String)"getHintId", (DBRoute)DBRoute.of((String)dbKey), (SqlBuilder)sql);){
                        if (idData.hasNext()) {
                            hintId = idData.next().getLong("id");
                        }
                    }
                    if (hintId > 0L) {
                        hint = new HintCondition(tidCol, FilterType.eq, (Object)hintId);
                    } else {
                        TreeSet<Long> treeSet = ids;
                        return treeSet;
                    }
                }
                QFilter fs = new QFilter("id", ">=", (Object)this.fromId);
                fs.and("id", "<", (Object)this.toId);
                if (this.idSet != null) {
                    fs.and("id", "in", (Object)this.idSet);
                }
                fs.and(this.otherFs);
                if (hint == null) {
                    data = QueryServiceHelper.queryDataSet((String)"getAllIdsByFs", (String)seqEntityName, (String)"id", (QFilter[])fs.toArray(), null);
                } else {
                    BalLogUtil.info("use hint = " + hint, new Object[0]);
                    try (ShardingHintContext shardingHintContext = ShardingHintContext.createAndSet((String)seqEntityTb, (HintCondition[])new HintCondition[]{hint});){
                        data = QueryServiceHelper.queryDataSet((String)"getAllIdsByHint", (String)seqEntityName, (String)"id", (QFilter[])fs.toArray(), null);
                    }
                }
            }
            for (Row row : data) {
                ids.add(row.getLong("id"));
            }
            TreeSet<Long> treeSet = ids;
            return treeSet;
        }
    }
}

