/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.sparse;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.sparse.SparseSeqParam;
import kd.bos.biz.balance.model.IBalance;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SparseSeq
implements AutoCloseable,
Iterator<long[]> {
    private long id;
    private int sparseSize = 10000;
    private String entity;
    private String entityTb;
    private String actualTb;
    private DBRoute dbRoute;
    private String storeTb;
    private String sparseCol;
    private DataSet sparseData;
    private String saveSQL;
    private String selectSQL;
    private volatile long to = Long.MAX_VALUE;
    private volatile long from = 0L;
    private volatile boolean hasVal = true;

    public void setEntityName(String entityName) {
        this.entity = entityName;
        if (this.entity != null) {
            this.entity = this.entity.toLowerCase(Locale.ENGLISH);
        }
    }

    public long getId() {
        return this.id;
    }

    private SparseSeq(SparseSeqParam param) {
        this.entity = param.getEntity();
        this.entityTb = param.getEntityTb();
        this.actualTb = param.getActualTb();
        this.dbRoute = param.getDBRoute();
        this.sparseCol = param.getSparseCol();
        this.from = param.getMinLimit();
        this.to = param.getMaxLimit();
    }

    private SparseSeq() {
    }

    public static SparseSeq getSparseSeq(SparseSeqParam param) {
        SparseSeq seg = new SparseSeq(param);
        seg.buildSparseData();
        return seg;
    }

    public static void reBuildSparseSeq(DynamicObject sparseSeqInfo) {
        block13: {
            try (SparseSeq sparseSeq = new SparseSeq();){
                sparseSeq.dbRoute = DBRoute.of((String)sparseSeqInfo.getString("dbkey"));
                sparseSeq.actualTb = sparseSeqInfo.getString("actualtb");
                sparseSeq.sparseCol = sparseSeqInfo.getString("sparsecol");
                sparseSeq.storeTb = sparseSeqInfo.getString("storetb");
                sparseSeq.id = sparseSeqInfo.getLong("id");
                sparseSeq.initParam();
                if (SparseSeq.isStoreTb(sparseSeq.storeTb)) {
                    sparseSeq.clearStoreTb();
                    sparseSeq.appendSparseData();
                    break block13;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u50a8\u8868{0}\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u6e05\u7406\u3002", (String)"SparseSeq_0", (String)"bos-biz-balance", (Object[])new Object[]{sparseSeq.storeTb}));
            }
        }
    }

    private static boolean isStoreTb(String tb) {
        return (tb = tb.toUpperCase(Locale.ENGLISH)).startsWith("T_BAL") && DB.exitsTable((DBRoute)IBalance.BAL_DB, (String)tb);
    }

    private static void dropTb(String tb) {
        try (TXHandle tx = TX.requiresNew((String)"dropTb");){
            DB.execute((DBRoute)IBalance.BAL_DB, (String)("DROP TABLE " + tb));
        }
    }

    public static void dropStoreTb(String tb) {
        if (SparseSeq.isStoreTb(tb)) {
            SparseSeq.dropTb(tb);
        }
    }

    private void clearStoreTb() {
        try (TXHandle tx = TX.requiresNew((String)"clearStoreTb");){
            DB.execute((DBRoute)IBalance.BAL_DB, (String)("TRUNCATE TABLE " + this.storeTb));
        }
    }

    private void buildSparseData() {
        this.initParam();
        this.appendSparseData();
        this.setSparseData();
    }

    private void initParam() {
        this.storeTb = this.applyStoreTb();
        this.saveSQL = "INSERT " + this.storeTb + "(FSEG) VALUES (?)";
        this.selectSQL = "SELECT TOP 1," + this.sparseSize + " " + this.sparseCol + " FROM " + this.actualTb + " WHERE " + this.sparseCol + " > ? ORDER BY " + this.sparseCol + " ASC ";
    }

    private String applyStoreTb() {
        String dbkey = this.dbRoute.getRouteKey();
        QFilter fs = new QFilter("actualtb", "=", (Object)this.actualTb).and("dbkey", "=", (Object)dbkey).and("sparsecol", "=", (Object)this.sparseCol);
        DynamicObject sparseInfo = QueryServiceHelper.queryOne((String)"bal_sparse_seq", (String)"id,storetb,sparsesize", (QFilter[])fs.toArray());
        if (sparseInfo == null) {
            sparseInfo = BusinessDataServiceHelper.newDynamicObject((String)"bal_sparse_seq");
            sparseInfo.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
            sparseInfo.set("modifydate", (Object)new Date());
            sparseInfo.set("actualtb", (Object)this.actualTb);
            sparseInfo.set("entitytb", (Object)this.entityTb);
            sparseInfo.set("entity", (Object)this.entity);
            sparseInfo.set("sparsecol", (Object)this.sparseCol);
            sparseInfo.set("sparsesize", (Object)this.sparseSize);
            sparseInfo.set("dbkey", (Object)dbkey);
            String storeTb = this.createStoreTb();
            sparseInfo.set("storetb", (Object)storeTb);
            try (TXHandle tx = TX.requiresNew((String)"applyStoreTb");){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sparseInfo});
                }
                catch (Throwable e) {
                    tx.markRollback();
                    SparseSeq.dropTb(storeTb);
                }
            }
        } else {
            String tb = sparseInfo.getString("storetb").toUpperCase(Locale.ENGLISH);
            if (!DB.exitsTable((DBRoute)IBalance.BAL_DB, (String)tb)) {
                this.createTb(tb);
            }
            this.sparseSize = sparseInfo.getInt("sparsesize");
        }
        this.id = sparseInfo.getLong("id");
        return sparseInfo.getString("storetb");
    }

    private String buildName() {
        return "t_bal" + DB.genGlobalLongId();
    }

    private String createStoreTb() {
        String tb = this.buildName().toUpperCase(Locale.ENGLISH);
        this.createTb(tb);
        return tb;
    }

    private void createTb(String tb) {
        try (TXHandle tx = TX.requiresNew((String)"createTb");){
            String[] tbSQLs;
            if (DB.exitsTable((DBRoute)IBalance.BAL_DB, (String)tb)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u50a8\u8868{0}\u5df2\u5b58\u5728\u3002", (String)"SparseSeq_1", (String)"bos-biz-balance", (Object[])new Object[]{tb}));
            }
            for (String tbSQL : tbSQLs = new String[]{"IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + tb + "') CREATE TABLE " + tb + " ( FSEG BIGINT NOT NULL DEFAULT '0' ) ", "EXEC P_ALTERPK 'PK_" + tb + "', '" + tb + "', 'FSEG', '1' "}) {
                SparseSeq.executeSql(tbSQL);
            }
            if (!DB.exitsTable((DBRoute)IBalance.BAL_DB, (String)tb)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u50a8\u8868{0}\u521b\u5efa\u5931\u8d25\u3002", (String)"SparseSeq_2", (String)"bos-biz-balance", (Object[])new Object[]{tb}));
            }
        }
    }

    private static void executeSql(String sql) {
        DB.execute((DBRoute)IBalance.BAL_DB, (String)sql);
    }

    private Long getLastId() {
        try (DataSet data = DB.queryDataSet((String)"getLastId", (DBRoute)IBalance.BAL_DB, (String)("SELECT TOP 1 FSEG FROM " + this.storeTb + " ORDER BY FSEG DESC"));){
            if (data.hasNext()) {
                Long l = data.next().getLong("FSEG");
                return l;
            }
        }
        return 0L;
    }

    private void appendSparseData() {
        int batchSave = 1000;
        Long lastId = this.getLastId();
        ArrayList<Object[]> idSegs = new ArrayList<Object[]>(batchSave);
        while (lastId != null) {
            if ((lastId = this.buildSparseData(lastId)) != null) {
                idSegs.add(new Object[]{lastId});
            }
            if (idSegs.size() <= batchSave) continue;
            this.saveSparseData(idSegs);
            idSegs.clear();
        }
        if (!idSegs.isEmpty()) {
            this.saveSparseData(idSegs);
        }
    }

    private void saveSparseData(List<Object[]> sparseData) {
        try (TXHandle tx = TX.requiresNew((String)"saveSparseData");){
            DB.executeBatch((DBRoute)IBalance.BAL_DB, (String)this.saveSQL, sparseData);
        }
    }

    private Long buildSparseData(Long lastId) {
        try (DataSet data = DB.queryDataSet((String)"buildSparseData", (DBRoute)this.dbRoute, (String)this.selectSQL, (Object[])new Object[]{lastId});){
            Long l = data.hasNext() ? data.next().getLong(this.sparseCol) : null;
            return l;
        }
    }

    private void setSparseData() {
        String sql = "SELECT FSEG FROM " + this.storeTb;
        if (this.from > 0L) {
            sql = sql + " WHERE  FSEG >= " + this.from;
        }
        if (this.to > 0L) {
            sql = sql + (this.from > 0L ? " AND FSEG < " : " WHERE FSEG <") + this.to;
        }
        sql = sql + " ORDER BY FSEG ASC ";
        this.sparseData = DB.queryDataSet((String)"setSparseData", (DBRoute)IBalance.BAL_DB, (String)sql);
    }

    @Override
    public void close() {
        if (this.sparseData != null) {
            this.sparseData.close();
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasVal;
    }

    @Override
    public long[] next() {
        long[] fromTo;
        if (!this.hasVal) {
            throw new RuntimeException("Iterator is empty, SparseSeq can not next");
        }
        if (this.sparseData.hasNext()) {
            Row row = this.sparseData.next();
            long tempTo = row.getLong("FSEG");
            fromTo = new long[]{this.from, tempTo};
            this.from = tempTo;
        } else {
            fromTo = new long[]{this.from, this.to};
            this.hasVal = false;
        }
        return fromTo;
    }
}

