/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.DynamicExecutorService;
import kd.bos.threads.impl.DynamicExecutorServiceImpl;

public class BalPoolUtil {
    public static final int REJECTED_TYPE_ABORT = 0;
    public static final int REJECTED_TYPE_DISCARD = 1;
    private static final String POOL_PUBLIC = "BalPool_update";
    private static final String POOL_CHECK = "BalPool_check";
    private static final String POOL_OTHER = "BalPool_other";
    private static final String POOL_NOTIFY = "BalPool_notify";
    private static final int MAX_POOL_SIZE = 32;
    private static final Map<String, DynamicExecutorService> EXEC_SERS = new HashMap<String, DynamicExecutorService>(8);
    private static final Map<String, ThreadPoolExecutor> POOL_CACHE = new HashMap<String, ThreadPoolExecutor>(8);
    private static final Random RD = new Random();

    public static String showStatus(String poolName) {
        StringBuilder msg = new StringBuilder();
        POOL_CACHE.forEach((name, ser) -> {
            if (poolName == null || poolName.equals(name)) {
                msg.append(String.format("BalPoolName=%s, ActiveCount=%s, PoolSize=%s, TaskCount=%s, CompletedTaskCount=%s", name, ser.getActiveCount(), ser.getPoolSize(), ser.getTaskCount(), ser.getCompletedTaskCount())).append("\n");
            }
        });
        return msg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamicExecutorService getExecutor(final String poolKey, int corePoolSize, int maxPoolSize, int queueSize, int rejectedType) {
        DynamicExecutorService pool = EXEC_SERS.get(poolKey);
        if (pool == null) {
            Map<String, DynamicExecutorService> map = EXEC_SERS;
            synchronized (map) {
                pool = EXEC_SERS.computeIfAbsent(poolKey, k -> {
                    ThreadPoolExecutor tempPool = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)(queueSize > 0 ? new LinkedBlockingQueue(queueSize) : new SynchronousQueue())), new ThreadFactory(){
                        private final AtomicInteger atomicInteger = new AtomicInteger(0);

                        @Override
                        public Thread newThread(Runnable r) {
                            return new Thread(r, poolKey + "-" + this.atomicInteger.incrementAndGet());
                        }
                    }, BalPoolUtil.getRejectedExecutionHandler(rejectedType));
                    tempPool.allowCoreThreadTimeOut(true);
                    POOL_CACHE.put(poolKey, tempPool);
                    return new DynamicExecutorServiceImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)tempPool));
                });
            }
        }
        return pool;
    }

    private static RejectedExecutionHandler getRejectedExecutionHandler(int type) {
        switch (type) {
            case 0: {
                return (r, e) -> {
                    throw new RejectedExecutionException();
                };
            }
        }
        return (r, e) -> {};
    }

    public static DynamicExecutorService getUpdateExecutor() {
        return BalPoolUtil.getExecutor(POOL_PUBLIC, 0, 32, 0, 0);
    }

    public static DynamicExecutorService getUpdateExecutor(String taskType, int corePoolSize, int maxPoolSize, int queueSize, boolean useAccId) {
        String poolKey = "BalPool_update_" + taskType;
        if (useAccId) {
            poolKey = poolKey + "_" + RequestContext.getOrCreate().getAccountId();
        }
        return BalPoolUtil.getExecutor(poolKey, corePoolSize, maxPoolSize, queueSize, 0);
    }

    private static DynamicExecutorService getOtherExecutor() {
        return BalPoolUtil.getExecutor(POOL_OTHER, 8, 8, 256, 0);
    }

    public static <T> Future<T> submitByOtherExecutor(Callable<T> task) {
        DynamicExecutorService executor = BalPoolUtil.getOtherExecutor();
        try {
            Future future = executor.submit(task);
            return future;
        }
        catch (RejectedExecutionException e) {
            FutureTask<T> futureTask = new FutureTask<T>(task);
            futureTask.run();
            return futureTask;
        }
    }

    public static void executeByOtherExecutor(Runnable task) {
        DynamicExecutorService executor = BalPoolUtil.getOtherExecutor();
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
    }

    public static DynamicExecutorService getCheckExecutor() {
        return BalPoolUtil.getExecutor(POOL_CHECK, 8, 8, 5120, 0);
    }

    public static DynamicExecutorService getNotifyExecutor() {
        return BalPoolUtil.getExecutor(POOL_NOTIFY, 4, 8, 256, 0);
    }

    public static DynamicExecutorService getNotifyExecutor(String lock, boolean useAccId) {
        String poolKey = "BalPool_notify_" + lock;
        if (useAccId) {
            poolKey = poolKey + "_" + RequestContext.getOrCreate().getAccountId();
        }
        return BalPoolUtil.getExecutor(poolKey, 1, 1, 1, 1);
    }
}

