/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalPoolUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.bal.servicehelper.BalServiceHelper;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.xdb.XDBConfig;

public class BalTaskUtil {
    public static void clearHistoryTask(String taskEntity) {
        BalTaskUtil.clearHistoryTask(taskEntity, 15);
    }

    public static void clearHistoryTask(String taskEntity, int limitDay) {
        int day = limitDay < 15 ? 15 : Math.min(limitDay, 180);
        BalPoolUtil.executeByOtherExecutor(() -> {
            try {
                long limit = System.currentTimeMillis() - (long)(day * 24) * 3600L * 1000L;
                QFilter fs = new QFilter("createdate", "<", (Object)new Date(limit));
                try (TXHandle tx = TX.requiresNew((String)"clearHistoryTask");){
                    DeleteServiceHelper.delete((String)taskEntity, (QFilter[])fs.toArray());
                }
            }
            catch (Throwable e) {
                BalLogUtil.saveError("BalTaskClearUtil", "entity=" + taskEntity + " limitDay = " + limitDay, "clearHistoryTask", e);
            }
        });
    }

    public static String[] getXdbs(final String tb, DBRoute route) {
        try {
            if (DB.isSharded((String)tb)) {
                return (String[])DB.__setupExtContextForUsingXdbTableManager((DBRoute)route, (boolean)true, (Callable)new Callable<String[]>(){

                    @Override
                    public String[] call() throws Exception {
                        return XDBConfig.getTableManager().getShardingTable(tb);
                    }
                });
            }
            return new String[]{tb};
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void publishTasks(List<TaskMsg> msgs) {
        if (msgs == null || msgs.isEmpty()) {
            return;
        }
        boolean useMQ = BalConfig.isServiceByMQ();
        if (useMQ) {
            BalTaskUtil.publishTaskByMQ(msgs);
        } else {
            BalTaskUtil.publishTaskByService(msgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishTaskByMQ(List<TaskMsg> msgs) {
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createPartitionPublisher("bal_queue", "bal.check", PartitionStrategy.APP_ID);
            for (TaskMsg msg : msgs) {
                pub.publish((Object)msg, msg.getAppId());
                msg.setPubSuccess(true);
            }
        }
    }

    private static void publishTaskByService(List<TaskMsg> msgs) {
        Object result;
        ArrayList<TaskMsg> reTryMsgs = new ArrayList<TaskMsg>(8);
        for (TaskMsg msg : msgs) {
            result = BalServiceHelper.invokeBalService(msg.getAppId(), "mockCheckTaskMsg", msg);
            if ("1".equals(result)) {
                msg.setPubSuccess(true);
                continue;
            }
            reTryMsgs.add(msg);
        }
        if (!reTryMsgs.isEmpty()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (TaskMsg msg : reTryMsgs) {
                result = BalServiceHelper.invokeBalService(msg.getAppId(), "mockCheckTaskMsg", msg);
                msg.setPubSuccess("1".equals(result));
            }
        }
    }
}

