/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bal.common.FormUtil;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.id.IDGenner;
import kd.bos.id.IDRange;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalCheckRepairEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String F_BILL_ID = "bill.id";
    private static final String F_BAL_ID = "bal.number";
    private static final String GRID_BAL_FS = "balfsitem";
    private static final String GRID_BILL_FS = "billfsitem";
    private static final String F_TAG_BAL_FS = "balfsinfo_tag";
    private static final String F_TAG_BILL_FS = "billfsinfo_tag";
    private static final String F_BILL = "bill";
    private static final String F_BAL = "bal";
    private static final String F_RULE = "updaterule";
    private static final String F_TASK_TYPE = "tasktype";
    private static final String F_OP_RANGE = "oprange";
    private static final String F_ID_FROM = "idfrom";
    private static final String F_ID_TO = "idto";
    private static final String F_TIME_FROM = "timefrom";
    private static final String F_TIME_TO = "timeto";
    private static final String F_ID_SET_TAG = "idset_tag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        FormUtil.addF7Listener(this, F_BAL, F_BILL, F_RULE);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = FormUtil.getOpKey(e)) {
            case "publishtask": {
                this.beforePublishTask(e);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        long idTo;
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        long idFrom = data.getLong(F_ID_FROM);
        if (idFrom > 0L) {
            IDGenner gen = new IDGenner(1, 1L);
            data.set(F_TIME_FROM, (Object)gen.getCreateTime(idFrom));
        }
        if ((idTo = data.getLong(F_ID_TO)) > 0L) {
            IDGenner gen = new IDGenner(1, 1L);
            data.set(F_TIME_TO, (Object)gen.getCreateTime(idFrom));
        }
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        String balName = data.getString(F_BAL_ID);
        String billName = data.getString(F_BILL_ID);
        FilterCondition balCondition = this.unParseFs(balName, GRID_BAL_FS, data.getString(F_TAG_BAL_FS));
        FilterCondition billCondition = this.unParseFs(billName, GRID_BILL_FS, data.getString(F_TAG_BILL_FS));
        this.initGrid(balName, GRID_BAL_FS, balCondition);
        this.initGrid(billName, GRID_BILL_FS, billCondition);
        this.getModel().setDataChanged(false);
    }

    private void beforePublishTask(BeforeDoOperationEventArgs e) {
        DynamicObject data = this.getModel().getDataEntity();
        String balName = data.getString(F_BAL_ID);
        String billName = data.getString(F_BILL_ID);
        this.parseFs(balName, GRID_BAL_FS, F_TAG_BAL_FS);
        this.parseFs(billName, GRID_BILL_FS, F_TAG_BILL_FS);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bill": {
                this.billChanged();
                break;
            }
            case "bal": {
                this.balChanged();
                break;
            }
            case "tasktype": {
                this.taskTypeChanged();
                break;
            }
            case "oprange": {
                this.opRangeChanged();
                break;
            }
            case "idfrom": {
                this.idFromChanged();
                break;
            }
            case "idto": {
                this.idToChanged();
                break;
            }
            case "timefrom": {
                this.timeFromChanged();
                break;
            }
            case "timeto": {
                this.timeToChanged();
                break;
            }
        }
    }

    private void timeToChanged() {
        this.timeToId(F_ID_TO, F_TIME_TO, true);
    }

    private void timeFromChanged() {
        this.timeToId(F_ID_FROM, F_TIME_FROM, false);
    }

    private void idToChanged() {
        this.idToTime(F_ID_TO, F_TIME_TO);
    }

    private void idFromChanged() {
        this.idToTime(F_ID_FROM, F_TIME_FROM);
    }

    private void idToTime(String idCol, String timeCol) {
        IDataModel model = this.getModel();
        long id = model.getDataEntity().getLong(idCol);
        Date time = null;
        if (id > 0L) {
            IDGenner gen = new IDGenner(1, 1L);
            time = gen.getCreateTime(id);
        }
        model.beginInit();
        model.setValue(timeCol, time);
        model.endInit();
        this.getView().updateView(timeCol);
    }

    private void timeToId(String idCol, String timeCol, boolean isMax) {
        IDataModel model = this.getModel();
        Date time = model.getDataEntity().getDate(timeCol);
        long id = 0L;
        if (time != null) {
            IDGenner gen = new IDGenner(1, 1L);
            IDRange idRange = gen.getIDRangeOfDay(time);
            id = isMax ? idRange.getMaxId() : idRange.getMinId();
        }
        model.beginInit();
        model.setValue(idCol, (Object)id);
        model.endInit();
        this.getView().updateView(idCol);
    }

    private void opRangeChanged() {
        DynamicObject data = this.getModel().getDataEntity();
        String opRange = data.getString(F_OP_RANGE);
        if (opRange == null) {
            return;
        }
        this.reBuildGrid(data.getString(F_BAL_ID), GRID_BAL_FS);
        this.reBuildGrid(data.getString(F_BILL_ID), GRID_BILL_FS);
    }

    private void taskTypeChanged() {
        IDataModel model = this.getModel();
        String type = model.getDataEntity().getString(F_TASK_TYPE);
        if (StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        model.setValue(F_BAL, null);
        model.setValue(F_BILL, null);
        model.setValue(F_RULE, null);
        model.setValue(F_OP_RANGE, null);
        model.setValue(F_TAG_BAL_FS, null);
        model.setValue(F_TAG_BILL_FS, null);
        this.clearGrid(GRID_BAL_FS, GRID_BAL_FS);
        if (type.equals("E") || type.equals("J")) {
            model.setValue(F_OP_RANGE, (Object)"B");
        }
    }

    private void balChanged() {
        String balName = this.getModel().getDataEntity().getString(F_BAL_ID);
        this.reBuildGrid(balName, GRID_BAL_FS);
        IDataModel model = this.getModel();
        model.setValue(F_BILL, null);
        model.setValue(F_RULE, null);
    }

    private void billChanged() {
        String billName = this.getModel().getDataEntity().getString(F_BILL_ID);
        this.reBuildGrid(billName, GRID_BILL_FS);
        IDataModel model = this.getModel();
        model.setValue(F_RULE, null);
    }

    private void clearGrid(String ... gridNames) {
        for (String gridName : gridNames) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(gridName);
            filterGrid.setFilterColumns(Collections.emptyList());
            this.getView().updateView(gridName);
        }
    }

    private void initGrid(String entityName, String gridName, FilterCondition condition) {
        condition = condition == null ? new FilterCondition() : condition;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(gridName);
        filterGrid.SetValue(condition);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            GetFilterFieldsParameter param = new GetFilterFieldsParameter((IDataEntityType)entityType);
            param.setNeedFieldCompareType(false);
            param.setNeedFlexField(false);
            param.setNeedAliasEmptyFieldProp(false);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)param));
        }
        this.getView().updateView(gridName);
    }

    private void reBuildGrid(String entityName, String gridName) {
        this.initGrid(entityName, gridName, null);
    }

    private void parseFs(String entityName, String gridName, String tagCol) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            this.getModel().setValue(tagCol, null);
        } else {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(gridName);
            FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
            this.getModel().setValue(tagCol, (Object)SerializationUtils.toJsonString((Object)condition));
        }
    }

    private FilterCondition unParseFs(String entityName, String gridName, String conditionStr) {
        return StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{entityName, conditionStr}) ? null : (FilterCondition)SerializationUtils.fromJsonString((String)conditionStr, FilterCondition.class);
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "showtask": {
                this.showTask();
                break;
            }
        }
    }

    private void showTask() {
        Object pk = this.getModel().getDataEntity().getPkValue();
        if (pk == null || pk.equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u53d1\u5e03\u5b50\u4efb\u52a1\u3002", (String)"BalCheckRepairEdit_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            return;
        }
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("bal_check_repair_task");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter param = fsp.getListFilterParameter();
        param.setFilter(new QFilter("parenttask", "=", pk));
        this.getView().showForm((FormShowParameter)fsp);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bal": {
                this.beforeBalSelect(e);
                break;
            }
            case "bill": {
                this.beforeBillSelect(e);
                break;
            }
            case "updaterule": {
                this.beforeRuleSelect(e);
                break;
            }
        }
    }

    private void beforeBalSelect(BeforeF7SelectEvent e) {
        String type = this.getModel().getDataEntity().getString(F_TASK_TYPE);
        if (StringUtils.isBlank((CharSequence)type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4efb\u52a1\u7c7b\u578b\u3002", (String)"BalCheckRepairEdit_1", (String)"bos-biz-balance", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void beforeRuleSelect(BeforeF7SelectEvent evt) {
        DynamicObject data = this.getModel().getDataEntity();
        String balName = data.getString(F_BAL_ID);
        String billName = data.getString(F_BILL_ID);
        if (StringUtils.isBlank((CharSequence)balName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f59\u989d\u8868\u5b9e\u4f53\u3002", (String)"BalCheckRepairEdit_2", (String)"bos-biz-balance", (Object[])new Object[0]));
            evt.setCancel(true);
        } else if (StringUtils.isBlank((CharSequence)billName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u5b9e\u4f53\u3002", (String)"BalCheckRepairEdit_3", (String)"bos-biz-balance", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            RuleFilter filter = new RuleFilter(data.getString(F_TASK_TYPE));
            List<UpdateRule> rules = UpdateRuleCache.getUpdateRuleByBal(balName);
            List ruleId = rules.stream().filter(rule -> billName.equals(rule.getEntityNumber()) && filter.test((UpdateRule)rule)).map(rule -> rule.getId()).collect(Collectors.toList());
            QFilter fs = new QFilter("id", "in", ruleId);
            FormUtil.addF7Filter(evt, fs);
        }
    }

    private void beforeBillSelect(BeforeF7SelectEvent evt) {
        DynamicObject data = this.getModel().getDataEntity();
        String balName = data.getString(F_BAL_ID);
        if (StringUtils.isBlank((CharSequence)balName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f59\u989d\u8868\u5b9e\u4f53\u3002", (String)"BalCheckRepairEdit_2", (String)"bos-biz-balance", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            List<UpdateRule> rules = UpdateRuleCache.getUpdateRuleByBal(balName);
            Set billIds = rules.stream().filter(new RuleFilter(data.getString(F_TASK_TYPE))).map(UpdateRule::getEntityNumber).collect(Collectors.toSet());
            QFilter fs = new QFilter("id", "in", billIds);
            FormUtil.addF7Filter(evt, fs);
        }
    }

    private static class RuleFilter
    implements Predicate<UpdateRule> {
        final String taskType;

        RuleFilter(String taskType) {
            this.taskType = taskType;
        }

        @Override
        public boolean test(UpdateRule rule) {
            if ("J".equals(this.taskType)) {
                return !rule.isEnable();
            }
            if ("B".equals(this.taskType) || "G".equals(this.taskType)) {
                return rule.isEnable();
            }
            return true;
        }
    }
}

