/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin;

import java.time.Year;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import org.apache.commons.lang3.StringUtils;

public class BalPerRecordSplitEdit
extends AbstractBillPlugIn {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("saveandrun".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("period", (Object)this.getDefPeriod());
    }

    private int getDefPeriod() {
        return (Year.now().getValue() - 1) * 100 + 1;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "period": {
                this.periodChanged(e);
                break;
            }
            case "bal": {
                this.balChanged(e);
            }
        }
    }

    private void balChanged(PropertyChangedArgs e) {
        this.checkAndReSetPeriod();
    }

    private void periodChanged(PropertyChangedArgs e) {
        this.checkAndReSetPeriod();
    }

    private void checkAndReSetPeriod() {
        String balName = this.getModel().getDataEntity().getString("bal.id");
        if (StringUtils.isBlank((CharSequence)balName)) {
            return;
        }
        int period = this.getModel().getDataEntity().getInt("period");
        BalanceTB bal = BalanceTB.getBalanceTB(balName);
        if (!bal.getColsByDataType(BizDataType.YEAR_IN, BizDataType.YEAR_OUT).isEmpty() && period % 100 != 1) {
            period = period / 100 * 100 + 1;
            String msg = ResManager.loadKDString((String)"\u5e26\u5e74\u6536\u53d1\u5b57\u6bb5\u7684\u4f59\u989d\u8868\uff0c\u53ea\u80fd\u6309\u5e74\u7b2c\u4e00\u671f\u8bbe\u7f6e\u5f52\u6863\u671f\u95f4\u3002", (String)"BAL-E-0003", (String)"bos-biz-balance", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            this.getModel().setValue("period", (Object)period);
        }
    }
}

