/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.bal.common.FormUtil;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalRecordSplitEdit
extends AbstractBasePlugIn {
    private static final String F_BAL_ID = "bal.id";
    private static final String GRID_BAL_FS = "balfsitem";
    private static final String F_TAG_BAL_FS = "balfsinfo_tag";
    private static final String F_BAL = "bal";
    private static final String F_TASK_TYPE = "tasktype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = FormUtil.getOpKey(e)) {
            case "publishtask": {
                this.beforePublishTask(e);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        String balName = data.getString(F_BAL_ID);
        FilterCondition balCondition = this.unParseFs(balName, GRID_BAL_FS, data.getString(F_TAG_BAL_FS));
        this.initGrid(balName, GRID_BAL_FS, balCondition);
        this.getModel().setDataChanged(false);
    }

    private void beforePublishTask(BeforeDoOperationEventArgs e) {
        DynamicObject data = this.getModel().getDataEntity();
        String balName = data.getString(F_BAL_ID);
        this.parseFs(balName, GRID_BAL_FS, F_TAG_BAL_FS);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bal": {
                this.balChanged();
                break;
            }
            case "tasktype": {
                this.taskTypeChanged();
                break;
            }
        }
    }

    private void taskTypeChanged() {
        String taskType = this.getModel().getDataEntity().getString(F_TASK_TYPE);
        if (!"1".equals(taskType)) {
            this.initGrid(null, GRID_BAL_FS, null);
        } else {
            String balName = this.getModel().getDataEntity().getString(F_BAL_ID);
            this.initGrid(balName, GRID_BAL_FS, null);
        }
    }

    private void balChanged() {
        String balName = this.getModel().getDataEntity().getString(F_BAL_ID);
        this.reBuildGrid(balName, GRID_BAL_FS);
    }

    private void initGrid(String entityName, String gridName, FilterCondition condition) {
        condition = condition == null ? new FilterCondition() : condition;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(gridName);
        filterGrid.SetValue(condition);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            GetFilterFieldsParameter param = new GetFilterFieldsParameter((IDataEntityType)entityType);
            param.setNeedFieldCompareType(false);
            param.setNeedFlexField(false);
            param.setNeedAliasEmptyFieldProp(false);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)param));
        }
        this.getView().updateView(gridName);
    }

    private void reBuildGrid(String entityName, String gridName) {
        this.initGrid(entityName, gridName, null);
    }

    private void parseFs(String entityName, String gridName, String tagCol) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            this.getModel().setValue(tagCol, null);
        } else {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(gridName);
            FilterCondition condition = filterGrid.getFilterGridState().getFilterCondition();
            this.getModel().setValue(tagCol, (Object)SerializationUtils.toJsonString((Object)condition));
        }
    }

    private FilterCondition unParseFs(String entityName, String gridName, String conditionStr) {
        return StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{entityName, conditionStr}) ? null : (FilterCondition)SerializationUtils.fromJsonString((String)conditionStr, FilterCondition.class);
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "showtask": {
                this.showTask();
                break;
            }
        }
    }

    private void showTask() {
        Object pk = this.getModel().getDataEntity().getPkValue();
        if (pk == null || pk.equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u53d1\u5e03\u5b50\u4efb\u52a1\u3002", (String)"BalRecordSplitEdit_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            return;
        }
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("bal_record_split_task");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter param = fsp.getListFilterParameter();
        param.setFilter(new QFilter("parenttask", "=", pk));
        this.getView().showForm((FormShowParameter)fsp);
    }
}

