/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.FormUtil;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class BalSpDataSplitEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String F_BAL_ID = "bal.id";
    private static final String F_BAL = "bal";
    private static final String F_BILL = "bill";
    private static final String F_TIME_POINT = "timepoint";
    private static final String F_ID_POINT = "idpoint";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        FormUtil.addF7Listener(this, F_BILL);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bal": {
                this.balChanged();
                break;
            }
            case "timepoint": {
                this.timePointChanged();
                break;
            }
        }
    }

    private void timePointChanged() {
        this.reSetPointInfo();
    }

    private void balChanged() {
        this.getModel().setValue(F_BILL, null);
        this.reSetPointInfo();
    }

    private void reSetPointInfo() {
        DynamicObject data = this.getModel().getDataEntity();
        String balId = data.getString(F_BAL_ID);
        if (StringUtils.isBlank((CharSequence)balId)) {
            return;
        }
        BalConfig config = BalConfig.loadBalConfig(balId);
        int limitDay = config.getSpDataSpiltLimitDay();
        Date limitDate = BalUtil.getDateByDays(limitDay);
        Date timePoint = data.getDate(F_TIME_POINT);
        if (timePoint == null) {
            timePoint = limitDate;
            this.getModel().setValue(F_TIME_POINT, (Object)limitDate);
        } else if (limitDate.before(timePoint)) {
            String dayStr = DateFormatUtils.format((Date)limitDate, (String)"yyyy-MM-dd");
            String msg = ResManager.loadKDString((String)"ID\u5206\u754c\u70b9\u8d85\u51fa\u4e86\u53c2\u6570\u914d\u7f6e\uff0c\u65f6\u95f4\u5206\u754c\u70b9\u4e0d\u80fd\u5927\u4e8e\uff1a{0}\uff0c\u5df2\u81ea\u52a8\u8c03\u6574\u3002", (String)"BalSpDataSplitEdit_0", (String)"bos-biz-balance", (Object[])new Object[]{dayStr});
            this.getView().showTipNotification(msg);
            timePoint = limitDate;
            this.getModel().setValue(F_TIME_POINT, (Object)limitDate);
        }
        this.getModel().setValue(F_ID_POINT, (Object)BalUtil.getIdByDate(timePoint));
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "showtask": {
                this.showTask();
                break;
            }
        }
    }

    private void showTask() {
        Object pk = this.getModel().getDataEntity().getPkValue();
        if (pk == null || pk.equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u53d1\u5e03\u5b50\u4efb\u52a1\u3002", (String)"BalSpDataSplitEdit_1", (String)"bos-biz-balance", (Object[])new Object[0]));
            return;
        }
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("bal_spdata_split_task");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter param = fsp.getListFilterParameter();
        param.setFilter(new QFilter("parenttask", "=", pk));
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void beforeBillSelect(BeforeF7SelectEvent evt) {
        DynamicObject data = this.getModel().getDataEntity();
        String balName = data.getString(F_BAL_ID);
        if (StringUtils.isBlank((CharSequence)balName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f59\u989d\u8868\u5b9e\u4f53\u3002", (String)"BalSpDataSplitEdit_2", (String)"bos-biz-balance", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            List<UpdateRule> rules = UpdateRuleCache.getUpdateRuleByBal(balName);
            Set billIds = rules.stream().map(UpdateRule::getEntityNumber).collect(Collectors.toSet());
            QFilter fs = new QFilter("id", "in", billIds);
            FormUtil.addF7Filter(evt, fs);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bill": {
                this.beforeBillSelect(e);
                break;
            }
        }
    }
}

