/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin.updaterule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.formplugin.updaterule.RuleUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.policy.BalanceCondition;
import kd.bos.metadata.balance.policy.BalanceDataFilterPolicy;
import kd.bos.metadata.balance.policy.BalanceFieldMapItem;
import kd.bos.metadata.balance.policy.BalanceFieldMapPolicy;
import kd.bos.metadata.balance.policy.BalanceFormula;
import kd.bos.metadata.balance.policy.BalanceLogicConf;
import kd.bos.metadata.balance.policy.BalanceSortCol;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

class RuleBindHandler {
    RuleBindHandler() {
    }

    public static void init(IFormView view, BalanceUpdateRuleMetadata metaData) {
        BalanceUpdateRuleElement rule = metaData.getRuleElement();
        RuleBindHandler.setBase(view, metaData);
        RuleBindHandler.setOpTime(view, rule);
        RuleBindHandler.setFilters(view, rule);
        RuleBindHandler.setDimValtypes(view);
        RuleBindHandler.setEntryConfig(view, rule);
    }

    public static void setDimValtypes(IFormView view) {
        DynamicObject bal = view.getModel().getDataEntity().getDynamicObject("bal");
        boolean isPeriodBal = bal != null && "period".equals(bal.getString("balancetype"));
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(3);
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u53d6\u6e90\u5355\u5b57\u6bb5", (String)"RuleBindHandler_0", (String)"bos-biz-balance", (Object[])new Object[0])), "0"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7cfb\u7edf\u9ed8\u8ba4\u503c", (String)"RuleBindHandler_1", (String)"bos-biz-balance", (Object[])new Object[0])), "4"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8ba1\u7b97", (String)"RuleBindHandler_2", (String)"bos-biz-balance", (Object[])new Object[0])), "6"));
        if (!isPeriodBal) {
            ComboItem item = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5339\u914d", (String)"RuleBindHandler_3", (String)"bos-biz-balance", (Object[])new Object[0])), "5");
            item.setItemVisible(false);
            combos.add(item);
        }
        ComboEdit edit = (ComboEdit)view.getControl("dimvaltype");
        edit.setComboItems(combos);
    }

    private static void setBase(IFormView view, BalanceUpdateRuleMetadata metaData) {
        BalanceUpdateRuleElement rule = metaData.getRuleElement();
        IDataModel model = view.getModel();
        model.setValue("devtype", (Object)metaData.getDevType());
        model.setValue("masterid", (Object)metaData.getMasterId());
        model.setValue("isv", (Object)metaData.getIsv());
        model.setValue("id", (Object)rule.getId());
        model.setValue("number", (Object)rule.getNumber());
        model.setValue("name", (Object)rule.getName());
        model.setValue("bal", (Object)rule.getBalanceTableNumber());
        model.setValue("bill", (Object)rule.getSourceEntityNumber());
        String updateType = rule.getUpdateType();
        if (StringUtils.isBlank((CharSequence)updateType)) {
            updateType = "0";
        }
        model.setValue("updatetype", (Object)updateType);
        model.setValue("sysstatus", (Object)rule.getSysStatus());
        model.setValue("custstatus", (Object)rule.getCustStatus());
        model.setValue("enable", (Object)"1".equals(rule.getCustStatus()));
        model.setValue("periodpolicy", (Object)rule.getPeriodFilterType());
        model.setValue("periodqtytype", (Object)rule.getPeriodQtyType());
        model.setValue("readabletype", (Object)rule.getReadableType());
        DynamicObject bill = (DynamicObject)model.getValue("bill");
        MainEntityType billEntity = null;
        if (bill != null) {
            billEntity = MetadataServiceHelper.getDataEntityType((String)bill.getString("id"));
        }
        RuleBindHandler.setFieldValue(model, billEntity, rule.getPeriodField(), "periodfield");
        RuleBindHandler.setFieldValue(model, billEntity, rule.getSrcMainField(), "billmaincol");
        RuleBindHandler.setYearMonthFieldValue(model, billEntity, rule.getYearField(), "yearfield");
        RuleBindHandler.setYearMonthFieldValue(model, billEntity, rule.getMonthField(), "monthfield");
        RuleBindHandler.setFieldValue(model, billEntity, rule.getBizDateField(), "bizdatefield");
    }

    private static void setYearMonthFieldValue(IDataModel model, MainEntityType billEntity, String field, String key) {
        String policy = (String)model.getValue("periodpolicy");
        if ("2".equals(policy)) {
            billEntity = RuleUtil.getPeriodEntityType(model);
        }
        RuleBindHandler.setFieldValue(model, billEntity, field, key);
    }

    private static void setFieldValue(IDataModel model, MainEntityType billEntity, String field, String key) {
        if (field != null && billEntity != null) {
            model.setValue(key, (Object)field);
            model.setValue(key + "name", (Object)RuleUtil.getColFullName(billEntity, field));
        }
    }

    private static void setOpTime(IFormView view, BalanceUpdateRuleElement rule) {
        RuleUtil.reSetOpSelect(view);
        IDataModel model = view.getModel();
        if (StringUtils.isNotBlank((CharSequence)rule.getUpdate())) {
            model.setValue("update", (Object)rule.getUpdate());
        }
        if (StringUtils.isNotBlank((CharSequence)rule.getRollback())) {
            model.setValue("rollback", (Object)rule.getRollback());
        }
    }

    private static void setFilters(IFormView view, BalanceUpdateRuleElement rule) {
        BalanceDataFilterPolicy policy = rule.getDfPolicy();
        BalanceCondition condition = policy.getBalanceCondition();
        if (condition == null) {
            return;
        }
        IDataModel model = view.getModel();
        model.setValue("datafilter", (Object)condition.getExprDesc());
        model.setValue("datafilterformula_tag", (Object)SerializationUtils.toJsonString((Object)condition));
    }

    public static void setEntryConfig(IFormView view, BalanceUpdateRuleElement rule) {
        IDataModel model = view.getModel();
        model.deleteEntryData("dimentry");
        model.deleteEntryData("occentry");
        model.deleteEntryData("sortentry");
        model.deleteEntryData("logicentry");
        DynamicObject bal = model.getDataEntity().getDynamicObject("bal");
        if (bal == null) {
            return;
        }
        String balName = bal.getString("id");
        MainEntityType balEntity = MetadataServiceHelper.getDataEntityType((String)balName);
        BalanceTB tb = BalanceTB.getBalanceTB(balName);
        Map<String, BizDataType> colTypes = RuleBindHandler.getColTypes(tb);
        Set<String> dimEntryCols = tb.getColsByDataType(BizDataType.MAIN, BizDataType.DIM);
        Set<String> occEntyCols = tb.getColsByDataType(BizDataType.OCC, BizDataType.COVER, BizDataType.RDD, BizDataType.INIT, BizDataType.IN, BizDataType.OUT);
        BalUtil.handleCompatible(rule, dimEntryCols, occEntyCols);
        Map<String, BalanceFieldMapItem> itemMap = RuleBindHandler.getRuleEntryConfig(rule);
        RuleBindHandler.initDimEntry(model, itemMap, colTypes, dimEntryCols, balEntity);
        RuleBindHandler.setUpdatePolicy(model, dimEntryCols, itemMap);
        RuleBindHandler.initOccEntry(model, itemMap, colTypes, occEntyCols, balEntity);
        RuleBindHandler.periodQtyTypeChanged(view);
        RuleBindHandler.initSortEntry(model, balEntity, rule);
        RuleBindHandler.initLogicEntry(model, rule);
    }

    private static void initLogicEntry(IDataModel model, BalanceUpdateRuleElement rule) {
        if (rule == null) {
            return;
        }
        List logicConfs = rule.getLogicConfs();
        if (logicConfs.isEmpty()) {
            return;
        }
        int[] indexs = model.batchCreateNewEntryRow("logicentry", logicConfs.size());
        int i = 0;
        String srcCol = null;
        String srcColFullName = null;
        MainEntityType billEntity = null;
        for (BalanceLogicConf conf : logicConfs) {
            int index = indexs[i++];
            model.setItemValueByNumber("logiccol", conf.getLogicCol(), index);
            srcCol = conf.getLogicSrc();
            if (billEntity == null) {
                DynamicObject bill = (DynamicObject)model.getValue("bill");
                billEntity = MetadataServiceHelper.getDataEntityType((String)bill.getString("id"));
            }
            srcColFullName = RuleUtil.getColFullName(billEntity, srcCol);
            model.setValue("logicsrc", (Object)srcCol, index);
            model.setValue("logicsrcname", (Object)srcColFullName, index);
        }
    }

    private static Map<String, BizDataType> getColTypes(BalanceTB tb) {
        Map<BizDataType, Set<String>> colType = tb.getColType();
        HashMap<String, BizDataType> colTypes = new HashMap<String, BizDataType>(32);
        Set<String> cols = null;
        BizDataType type = null;
        for (Map.Entry<BizDataType, Set<String>> entry : colType.entrySet()) {
            cols = entry.getValue();
            type = entry.getKey();
            for (String col : cols) {
                colTypes.put(col, type);
            }
        }
        return colTypes;
    }

    private static void initSortEntry(IDataModel model, MainEntityType balEntity, BalanceUpdateRuleElement rule) {
        if (rule == null) {
            return;
        }
        List rows = rule.getSortEntryRows();
        if (rows.isEmpty()) {
            return;
        }
        int[] indexs = model.batchCreateNewEntryRow("sortentry", rows.size());
        int i = 0;
        String col = null;
        String colFullName = null;
        for (BalanceSortCol row : rows) {
            int index = indexs[i++];
            col = row.getCol();
            colFullName = RuleUtil.getColFullName(balEntity, col);
            model.setValue("sortcol", (Object)col, index);
            model.setValue("sortcolname", (Object)colFullName, index);
            model.setValue("sorttype", (Object)row.getSortType(), index);
        }
    }

    private static void setUpdatePolicy(IDataModel model, Collection<String> entryCols, Map<String, BalanceFieldMapItem> itemMap) {
        BalanceFieldMapItem item = null;
        for (String entryCol : entryCols) {
            item = itemMap.get(entryCol);
            if (item == null || !"5".equals(item.getValType())) continue;
            model.setValue("updatepolicy", (Object)"1");
            return;
        }
        model.setValue("updatepolicy", (Object)"0");
    }

    private static void initDimEntry(IDataModel model, Map<String, BalanceFieldMapItem> itemMap, Map<String, BizDataType> balConfigCols, Collection<String> entryCols, MainEntityType balEntity) {
        if (entryCols.isEmpty()) {
            return;
        }
        int[] indexs = model.batchCreateNewEntryRow("dimentry", entryCols.size());
        int i = 0;
        MainEntityType billEntity = null;
        BalanceFieldMapItem tempItem = null;
        for (String col : entryCols) {
            int index = indexs[i++];
            model.setValue("dimbalcol", (Object)col, index);
            String fullName = RuleUtil.getColFullName(balEntity, col);
            model.setValue("dimbalcolname", (Object)fullName, index);
            model.setValue("dimcoltype", (Object)balConfigCols.get(col).getNumber(), index);
            model.setValue("dimcoltypename", (Object)balConfigCols.get(col).getName(), index);
            tempItem = itemMap.get(col);
            if (tempItem != null) {
                BalanceFormula formula;
                if (billEntity == null) {
                    DynamicObject bill = (DynamicObject)model.getValue("bill");
                    billEntity = MetadataServiceHelper.getDataEntityType((String)bill.getString("id"));
                }
                String valType = tempItem.getValType();
                model.setValue("dimvaltype", (Object)valType, index);
                if ("0".equals(valType)) {
                    String sourceFieldKey = tempItem.getSourceField();
                    model.setValue("dimbillcol", (Object)sourceFieldKey, index);
                    String sourceFieldKeyName = RuleUtil.getColFullName(billEntity, sourceFieldKey);
                    model.setValue("dimbillcolname", (Object)sourceFieldKeyName, index);
                    continue;
                }
                if (!"6".equals(valType) || (formula = tempItem.getExpr()) == null) continue;
                model.setValue("dimexpr", (Object)formula.getExprDesc(), index);
                model.setValue("dimexprformula_tag", (Object)SerializationUtils.toJsonString((Object)formula), index);
                continue;
            }
            model.setValue("dimvaltype", (Object)"0", index);
        }
    }

    private static void initOccEntry(IDataModel model, Map<String, BalanceFieldMapItem> itemMap, Map<String, BizDataType> balConfigCols, Collection<String> entryCols, MainEntityType balEntity) {
        if (entryCols.isEmpty()) {
            return;
        }
        int[] indexs = model.batchCreateNewEntryRow("occentry", entryCols.size());
        int i = 0;
        MainEntityType billEntity = null;
        BalanceFieldMapItem tempItem = null;
        for (String col : entryCols) {
            String sourceFieldKey;
            int index = indexs[i++];
            model.setValue("occbalcol", (Object)col, index);
            String fullName = RuleUtil.getColFullName(balEntity, col);
            model.setValue("occbalcolname", (Object)fullName, index);
            model.setValue("occcoltype", (Object)balConfigCols.get(col).getNumber(), index);
            model.setValue("occcoltypename", (Object)balConfigCols.get(col).getName(), index);
            tempItem = itemMap.get(col);
            if (tempItem == null) continue;
            if (billEntity == null) {
                DynamicObject bill = (DynamicObject)model.getValue("bill");
                billEntity = MetadataServiceHelper.getDataEntityType((String)bill.getString("id"));
            }
            if (StringUtils.isNotBlank((CharSequence)(sourceFieldKey = tempItem.getSourceField()))) {
                model.setValue("occbillcol", (Object)sourceFieldKey, index);
                String sourceFieldKeyName = RuleUtil.getColFullName(billEntity, sourceFieldKey);
                model.setValue("occbillcolname", (Object)sourceFieldKeyName, index);
            }
            String valType = tempItem.getValType();
            model.setValue("occvaltype", (Object)valType, index);
            BalanceFormula occAvbQtyFormula = tempItem.getOccAvbQtyFormula();
            if (occAvbQtyFormula == null) continue;
            model.setValue("occavbqty", (Object)occAvbQtyFormula.getExprDesc(), index);
            model.setValue("occavbqtyformula", (Object)SerializationUtils.toJsonString((Object)occAvbQtyFormula), index);
        }
    }

    private static Map<String, BalanceFieldMapItem> getRuleEntryConfig(BalanceUpdateRuleElement rule) {
        HashMap<String, BalanceFieldMapItem> itemMap = new HashMap<String, BalanceFieldMapItem>(16);
        if (rule == null) {
            return itemMap;
        }
        BalanceFieldMapPolicy policy = rule.getFieldMapPolicy();
        List items = policy.getBalanceFieldMapItems();
        for (BalanceFieldMapItem item : items) {
            itemMap.put(item.getTargetField(), item);
        }
        return itemMap;
    }

    public static void periodQtyTypeChanged(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject bal = model.getDataEntity().getDynamicObject("bal");
        if (bal == null || !"period".equals(bal.getString("balancetype"))) {
            return;
        }
        String periodQtyType = model.getDataEntity().getString("periodqtytype");
        int count = model.getEntryRowCount("occentry");
        String type = null;
        for (int i = 0; i < count; ++i) {
            type = (String)model.getValue("occcoltype", i);
            boolean canEdit = RuleBindHandler.isEdit(type, periodQtyType);
            view.setEnable(Boolean.valueOf(canEdit), i, new String[]{"occvaltype"});
            if (canEdit) continue;
            model.setValue("occvaltype", (Object)"5", i);
            model.setValue("occbillcol", null, i);
            model.setValue("occbillcolname", null, i);
        }
        RuleBindHandler.handleCalPeriodPolicy(view, "1".equals(periodQtyType));
    }

    private static void handleCalPeriodPolicy(IFormView view, boolean isUpdateInitQty) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(3);
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u6e90\u5355\u671f\u95f4\u5e74\u6708\u5b57\u6bb5\u8ba1\u7b97", (String)"RuleBindHandler_4", (String)"bos-biz-balance", (Object[])new Object[0])), "0"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u6e90\u5355\u671f\u95f4\u5b57\u6bb5\u8ba1\u7b97", (String)"RuleBindHandler_5", (String)"bos-biz-balance", (Object[])new Object[0])), "2"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u6e90\u5355\u65e5\u671f\u5b57\u6bb5\u8ba1\u7b97", (String)"RuleBindHandler_6", (String)"bos-biz-balance", (Object[])new Object[0])), "1"));
        ComboEdit edit = (ComboEdit)view.getControl("periodpolicy");
        if (isUpdateInitQty) {
            combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7edf\u4e00\u8bb0\u4e3a0\u671f", (String)"RuleBindHandler_7", (String)"bos-biz-balance", (Object[])new Object[0])), "3"));
        }
        edit.setComboItems(combos);
    }

    private static boolean isEdit(String type, String policy) {
        return "1".equals(policy) || BizDataType.COVER.getNumber().equals(type) || BizDataType.RDD.getNumber().equals(type) || "2".equals(policy) && BizDataType.IN.getNumber().equals(type) || "3".equals(policy) && BizDataType.OUT.getNumber().equals(type);
    }
}

