/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin.updaterule;

import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.balance.policy.BalancePlugin;

class RulePluginHandler {
    RulePluginHandler() {
    }

    public static void showAddPlugForm(IFormView view, AbstractFormPlugin plugin) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "ide_registerplugin");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "addplugin"));
        view.showForm(showParameter);
    }

    public static void showModifyPlugForm(IFormView view, AbstractFormPlugin plugin) {
        int row = view.getModel().getEntryCurrentRowIndex("pluginentry");
        String json = (String)view.getModel().getValue("plugin_desc", row);
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        BalancePlugin balPlugin = (BalancePlugin)SerializationUtils.fromJsonString((String)json, BalancePlugin.class);
        boolean enabled = (Boolean)view.getModel().getValue("plugin_enabled", row);
        balPlugin.setEnabled(enabled);
        if (balPlugin.getType() == 1) {
            BaseShowParameter param = new BaseShowParameter();
            param.setFormId("ide_pluginscript");
            param.setPkId((Object)balPlugin.getScriptId());
            param.setStatus(OperationStatus.EDIT);
            param.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm((FormShowParameter)param);
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_registerplugin");
            Map<String, Object> currentPlugin = RulePluginHandler.convertToParams(balPlugin);
            parameter.setCustomParam("rowKey", (Object)row);
            parameter.setCustomParam("plugin", currentPlugin);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "modifyplugin"));
            view.showForm(parameter);
        }
    }

    private static Map<String, Object> convertToParams(BalancePlugin plugin) {
        HashMap<String, Object> plugParams = new HashMap<String, Object>();
        plugParams.put("_Type_", "Plugin");
        plugParams.put("ClassName", plugin.getClassName());
        plugParams.put("Enabled", plugin.isEnabled());
        return plugParams;
    }
}

