/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin.updaterule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

class RuleUtil {
    RuleUtil() {
    }

    public static String notExistCol(String col) {
        return ResManager.loadKDString((String)"\u5b57\u6bb5{0}\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u3002", (String)"RuleUtil_0", (String)"bos-biz-balance", (Object[])new Object[]{col});
    }

    public static void reSetOpSelect(IFormView view) {
        IDataModel model = view.getModel();
        List<ComboItem> ops = RuleUtil.getOperationItems(model);
        ComboEdit edit = (ComboEdit)view.getControl("update");
        edit.setComboItems(ops);
        edit = (ComboEdit)view.getControl("rollback");
        edit.setComboItems(ops);
        model.setValue("update", null);
        model.setValue("rollback", null);
    }

    private static List<ComboItem> getOperationItems(IDataModel model) {
        DynamicObject sourceEntity = (DynamicObject)model.getValue("bill");
        if (sourceEntity == null) {
            return null;
        }
        String formId = (String)sourceEntity.get("number");
        List ops = EntityMetadataCache.getDataEntityOperate((String)formId);
        ArrayList<ComboItem> operationItems = new ArrayList<ComboItem>();
        for (Map op : ops) {
            String opType = (String)op.get("type");
            if (!OperationTypeCache.isEntityOperation((String)opType)) continue;
            operationItems.add(new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), (String)op.get("key")));
        }
        return operationItems;
    }

    public static String getColFullName(MainEntityType entity, String col) {
        if (StringUtils.isBlank((CharSequence)col)) {
            return null;
        }
        String[] proCols = col.split("\\.");
        IDataEntityProperty pro = entity.findProperty(proCols[0]);
        if (pro == null) {
            return RuleUtil.notExistCol(col);
        }
        StringBuilder name = new StringBuilder(RuleUtil.getFullName(pro.getParent(), pro.getDisplayName().getLocaleValue()));
        if (proCols.length > 1) {
            BasedataProp basePro = null;
            for (int i = 1; i < proCols.length && pro instanceof BasedataProp; ++i) {
                basePro = (BasedataProp)pro;
                MainEntityType type = MetadataServiceHelper.getDataEntityType((String)basePro.getBaseEntityId());
                pro = type.findProperty(proCols[i]);
                String subName = null;
                subName = pro.getDisplayName() == null ? ("id".equals(pro.getName()) ? ResManager.loadKDString((String)"\u5185\u7801", (String)"RuleUtil_1", (String)"bos-biz-balance", (Object[])new Object[0]) : "") : pro.getDisplayName().getLocaleValue();
                name.append('.').append(subName);
            }
        }
        return name.toString();
    }

    private static String getFullName(IDataEntityType parent, String colName) {
        if (parent instanceof MainEntityType) {
            return colName;
        }
        return RuleUtil.getFullName(parent.getParent(), parent.getDisplayName().getLocaleValue() + "." + colName);
    }

    public static MainEntityType getMainEntityType(IDataModel model, String fieldName) {
        DynamicObject entity = model.getDataEntity().getDynamicObject(fieldName);
        if (entity == null) {
            IDataEntityProperty pro = model.getDataEntityType().findProperty(fieldName);
            throw new KDBizException(ResManager.loadKDString((String)"\u5148\u9009\u62e9{0}\u3002", (String)"RuleUtil_2", (String)"bos-biz-balance", (Object[])new Object[]{pro.getDisplayName().getLocaleValue()}));
        }
        String number = entity.getString("id");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)number);
        if (type == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e{0}\u4e0d\u5b58\u5728\u3002", (String)"RuleUtil_3", (String)"bos-biz-balance", (Object[])new Object[]{fieldName}));
        }
        return type;
    }

    public static MainEntityType getPeriodEntityType(IDataModel model) {
        String periodCol = model.getDataEntity().getString("periodfield");
        if (StringUtils.isBlank((CharSequence)periodCol)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u671f\u95f4\u5b57\u6bb5\u3002", (String)"RuleUtil_4", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
        IDataEntityProperty pro = RuleUtil.getMainEntityType(model, "bill").findProperty(periodCol);
        if (pro instanceof BasedataProp) {
            return MetadataServiceHelper.getDataEntityType((String)((BasedataProp)pro).getBaseEntityId());
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u5b57\u6bb5\u5fc5\u987b\u662f\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5b57\u6bb5\u3002", (String)"RuleUtil_5", (String)"bos-biz-balance", (Object[])new Object[0]));
    }
}

