/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.consumer.NotifyMsg;
import kd.bos.bal.business.core.BalManager;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalOccurredDBNotifyMqOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List cols = e.getFieldKeys();
        cols.add("db");
        cols.add("app");
        cols.add("bal");
        cols.add("type");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        this.checkAndFillApp(datas);
        Collection<NotifyMsg> msgs = NotifyMsg.buildNotifyMsg(datas);
        BalManager.notifyMQConsumer(msgs);
    }

    private void checkAndFillApp(DynamicObject[] datas) {
        ArrayList<DynamicObject> noAppDatas = new ArrayList<DynamicObject>(datas.length);
        for (DynamicObject data : datas) {
            if (!StringUtils.isBlank((CharSequence)data.getString("app"))) continue;
            noAppDatas.add(data);
        }
        if (!noAppDatas.isEmpty()) {
            Map<String, String> allDBApps = this.getAllDBApps();
            for (DynamicObject data : noAppDatas) {
                data.set("app", (Object)allDBApps.get(data.getString("db")));
            }
            SaveServiceHelper.save((DynamicObject[])noAppDatas.toArray(new DynamicObject[0]));
        }
    }

    private Map<String, String> getAllDBApps() {
        HashSet<String> billEntitys = new HashSet<String>(128);
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)"getAllDBApps", (String)"bal_balanceupdaterule", (String)"sourceentitynumber", null, null);){
            for (Row row : datas) {
                String billName = row.getString("sourceentitynumber");
                if (!StringUtils.isNotBlank((CharSequence)billName)) continue;
                billEntitys.add(billName);
            }
        }
        HashMap<String, String> appMaps = new HashMap<String, String>(16);
        MainEntityType type = null;
        for (String bill : billEntitys) {
            type = this.getMainEntityType(bill);
            if (type == null) continue;
            appMaps.put(type.getDBRouteKey(), type.getAppId());
        }
        return appMaps;
    }

    private MainEntityType getMainEntityType(String billEntity) {
        try {
            return MetadataServiceHelper.getDataEntityType((String)billEntity);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

