/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.opplugin;

import java.util.Date;
import kd.bos.bal.business.archive.BalRecordSplitManager;
import kd.bos.bal.common.BalTaskUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import org.apache.commons.lang3.StringUtils;

public class BalRecordSplitPublishOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        BalTaskUtil.clearHistoryTask("bal_record_split_task");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] data = e.getDataEntities();
        if (data.length > 0) {
            BalRecordSplitManager.buildTask(data[0]);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PublishTaskValidator());
    }

    private static class PublishTaskValidator
    extends AbstractValidator {
        private PublishTaskValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataExts = this.getDataEntities();
            if (dataExts.length > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u64cd\u4f5c\u3002", (String)"BalRecordSplitPublishOp_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
            ExtendedDataEntity dataExt = dataExts[0];
            long limit = new Date().getTime() - 604800000L;
            Date createTime = dataExt.getDataEntity().getDate("createdate");
            if (createTime == null || createTime.getTime() < limit) {
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"7\u5929\u524d\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u518d\u6b21\u6267\u884c\uff0c\u53ef\u521b\u5efa\u65b0\u4efb\u52a1\u3002", (String)"BalRecordSplitPublishOp_1", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            if (this.hasTasks(dataExt)) {
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4efb\u52a1\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u5e03\uff0c\u70b9\u51fb\u67e5\u770b\u5b50\u4efb\u52a1\u3002", (String)"BalRecordSplitPublishOp_2", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            String bal = dataExt.getDataEntity().getString("bal.id");
            if (StringUtils.isBlank((CharSequence)bal)) {
                return;
            }
            int ver = BalRecordSplitManager.applyVer4ColList(bal);
            if (ver == -1) {
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u9501\u6682\u65f6\u65e0\u6cd5\u83b7\u53d6\u5230\uff0c\u53ef\u7a0d\u540e\u518d\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"BalRecordSplitPublishOp_3", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            dataExt.getDataEntity().set("ver", (Object)ver);
            dataExt.getDataEntity().set("traceid", (Object)TraceIdUtil.getCurrentTraceIdString());
        }

        private boolean hasTasks(ExtendedDataEntity data) {
            Object id = data.getDataEntity().getPkValue();
            if (id == null || id.equals(0L)) {
                return false;
            }
            return QueryServiceHelper.exists((String)"bal_record_split_task", (QFilter[])new QFilter("parenttask", "=", id).toArray());
        }
    }
}

