/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.opplugin;

import java.util.Date;
import kd.bos.bal.business.archive.BalSpDataSplitManager;
import kd.bos.bal.common.BalTaskUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;

public class BalSpDataSplitPublishOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        BalTaskUtil.clearHistoryTask("bal_spdata_split_task");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] data = e.getDataEntities();
        if (data != null && data.length > 0) {
            BalSpDataSplitManager.buildTask(data[0]);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PublishTaskValidator());
    }

    private static class PublishTaskValidator
    extends AbstractValidator {
        private PublishTaskValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataExts = this.getDataEntities();
            if (dataExts.length > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u64cd\u4f5c\u3002", (String)"BalSpDataSplitPublishOp_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
            ExtendedDataEntity dataExt = dataExts[0];
            long limit = new Date().getTime() - 604800000L;
            DynamicObject data = dataExt.getDataEntity();
            Date createTime = data.getDate("createdate");
            if (createTime == null || createTime.getTime() < limit) {
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"7\u5929\u524d\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u518d\u6b21\u6267\u884c\uff0c\u53ef\u521b\u5efa\u65b0\u4efb\u52a1\u3002", (String)"BalSpDataSplitPublishOp_1", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            if (this.hasTasks(dataExt)) {
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4efb\u52a1\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u5e03\uff0c\u70b9\u51fb\u67e5\u770b\u5b50\u4efb\u52a1\u3002", (String)"BalSpDataSplitPublishOp_2", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            data.set("traceid", (Object)TraceIdUtil.getCurrentTraceIdString());
        }

        private boolean hasTasks(ExtendedDataEntity data) {
            Object id = data.getDataEntity().getPkValue();
            if (id == null || id.equals(0L)) {
                return false;
            }
            return QueryServiceHelper.exists((String)"bal_spdata_split_task", (QFilter[])new QFilter("parenttask", "=", id).toArray());
        }
    }
}

