/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.OccDBInfo;
import kd.bos.bal.report.BalAllAsyncBillRptParam;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.StringUtils;

public class BalAllAsyncBillRpt
extends AbstractReportListDataPlugin {
    private BalAllAsyncBillRptParam param;

    private DataSet getEmpty() {
        return Algo.create((String)"BalAllAsyncBillRpt.getEmpty").createDataSet(Collections.emptyList(), new RowMeta(new Field[0]));
    }

    private String buildWhere() {
        String op;
        ArrayList<String> wheres = new ArrayList<String>();
        String bill = this.param.getBill();
        if (StringUtils.isNotBlank((CharSequence)bill)) {
            wheres.add(" FBILLENTITY = '" + bill + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)(op = this.param.getOp()))) {
            wheres.add(" FOP = '" + bill + "' ");
        }
        if (wheres.isEmpty()) {
            return " ";
        }
        return " WHERE " + String.join((CharSequence)" AND ", wheres);
    }

    public DataSet query(ReportQueryParam rqp, Object o) throws Throwable {
        Set<OccDBInfo> infos;
        this.param = (BalAllAsyncBillRptParam)rqp.getCustomParam().get(BalAllAsyncBillRptParam.class.getName());
        String balName = this.param.getBal();
        String[] dbKeys = this.param.getDbKeys();
        QFilter fs = new QFilter("type", "=", (Object)"1");
        if (StringUtils.isNotBlank((CharSequence)balName)) {
            fs.and("bal", "=", (Object)balName);
        }
        if (dbKeys != null) {
            fs.and("db", "in", (Object)dbKeys);
            infos = BalUtil.getOccDBInfo(fs);
        } else {
            infos = BalUtil.getOccDBInfoWithBalDb(fs);
        }
        return this.buildDataSet(infos, this.buildWhere(), this.param.getTbStatus());
    }

    private DataSet buildDataSet(Set<OccDBInfo> infos, String where, String tbStatus) {
        if (infos.isEmpty()) {
            return this.getEmpty();
        }
        DataSet data = null;
        int idx = -1;
        DataSet[] datas = new DataSet[infos.size() + idx];
        for (OccDBInfo info : infos) {
            if (idx == -1) {
                data = this.getDataSet(BalanceTB.getBalanceTB(info.balName), info.occDb, where, tbStatus);
            } else {
                datas[idx] = this.getDataSet(BalanceTB.getBalanceTB(info.balName), info.occDb, where, tbStatus);
            }
            ++idx;
        }
        if (data == null) {
            data = this.getEmpty();
        }
        return datas.length > 0 ? data.union(datas) : data;
    }

    private DataSet getDataSet(BalanceTB bal, String dbKey, String where, String tbStatus) {
        DBRoute db = DBRoute.of((String)dbKey);
        String selectStr = "SELECT TOP 10000 FID ID,FBILLID BILLID,FRULEID UPDATERULE,FBILLENTITY BILLENTITY,FOP OP,FXDBFLAG XDBFLAG,FCREATERID CREATER,FCREATETIME CREATETIME,FPUBLISHTIME PUBLISHTIME";
        if ("1".equals(tbStatus)) {
            String sql = selectStr + " , '" + dbKey + "' dbkey , '1' tbstatus FROM " + bal.getOrCreateAsyncInfoTb(db) + where + " ORDER BY FID ASC";
            return DB.queryDataSet((String)"getDataSet", (DBRoute)db, (String)sql);
        }
        if ("2".equals(tbStatus)) {
            String sql = selectStr + " , '" + dbKey + "' dbkey , '2' tbstatus FROM " + bal.getOrCreateTempAsyncInfoTb(db) + where + " ORDER BY FID ASC";
            return DB.queryDataSet((String)"getDataSet", (DBRoute)db, (String)sql);
        }
        String sql01 = selectStr + " , '" + dbKey + "' dbkey , '1' tbstatus FROM " + bal.getOrCreateAsyncInfoTb(db) + where + " ORDER BY FID ASC";
        String sql02 = selectStr + " , '" + dbKey + "' dbkey , '2' tbstatus FROM " + bal.getOrCreateTempAsyncInfoTb(db) + where + " ORDER BY FID ASC";
        return DB.queryDataSet((String)"getDataSet_01", (DBRoute)db, (String)sql01).union(DB.queryDataSet((String)"getDataSet_02", (DBRoute)db, (String)sql02));
    }
}

