/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.FormUtil;
import kd.bos.bal.common.OccDBInfo;
import kd.bos.bal.report.BalAllAsyncBillRptParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;

public class BalAllAsyncBillRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String FS_COL_BAL = "balancetb_s";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtil.addF7Listener(this, FS_COL_BAL);
    }

    public void afterCreateNewData(EventObject e) {
        this.initDBKeys();
    }

    private void initDBKeys() {
        String[] dbKeys;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        for (String dbKey : dbKeys = this.getDbKeys()) {
            combos.add(new ComboItem(new LocaleString(dbKey), dbKey));
        }
        ComboEdit item = (ComboEdit)this.getView().getControl("db_s");
        item.setComboItems(combos);
    }

    private String[] getDbKeys() {
        String dbStrs = this.getPageCache().get("db_keys");
        if (dbStrs == null) {
            CharSequence[] dbkeys = this.getOccDBInfo().toArray(new String[0]);
            dbStrs = String.join((CharSequence)",", dbkeys);
            this.getPageCache().put("db_keys", dbStrs);
            return dbkeys;
        }
        return "".equals(dbStrs) ? new String[]{} : dbStrs.split(",");
    }

    private Collection<String> getOccDBInfo() {
        QFilter fs = new QFilter("type", "=", (Object)"1");
        Set<OccDBInfo> occInfos = BalUtil.getOccDBInfoWithBalDb(fs);
        return occInfos.stream().map(v -> v.occDb).collect(Collectors.toSet());
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        BalAllAsyncBillRptParam param = new BalAllAsyncBillRptParam();
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject entity = data.getDynamicObject(FS_COL_BAL);
        if (entity != null) {
            param.setBal(entity.getString("id"));
        }
        if ((entity = data.getDynamicObject("billentity_s")) != null) {
            param.setBill(entity.getString("id"));
        }
        param.setOp(data.getString("op_s"));
        String dbs = data.getString("db_s");
        param.setDbKeys(dbs == null ? this.getDbKeys() : BalUtil.splitCombColToList(dbs).toArray(new String[0]));
        param.setTbStatus(data.getString("tbstatus_s"));
        queryParam.getCustomParam().put(BalAllAsyncBillRptParam.class.getName(), param);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (name.equals(FS_COL_BAL)) {
            this.beforeSelectBal(event);
        }
    }

    private void beforeSelectBal(BeforeF7SelectEvent event) {
        QFilter fs = new QFilter("type", "=", (Object)"2");
        Set<OccDBInfo> occInfos = BalUtil.getOccDBInfo(fs);
        List balNames = occInfos.stream().map(v -> v.balName).collect(Collectors.toList());
        FormUtil.addF7Filter(event, balNames.isEmpty() ? new QFilter("1", "=", (Object)2) : new QFilter("id", "in", balNames));
    }
}

