/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.bal.report.AddUpdateBalTime;
import kd.bos.bal.report.BalSpRptParam;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.entity.report.ReportColumnFactory;
import kd.bos.servicehelper.MetadataServiceHelper;

public class BalSpRpt
extends AbstractReportListDataPlugin {
    private static final String AS = " ";
    private BalSpRptParam rptParam;
    private BalanceTB tempTb;
    private StringBuilder whereCache;

    public DataSet query(ReportQueryParam report, Object param) throws Throwable {
        this.rptParam = (BalSpRptParam)report.getCustomParam().get(BalSpRptParam.class.getName());
        String sptb = this.rptParam.getSptb();
        DataSet spData = null;
        spData = "sp".equals(sptb) ? this.getSpData(false) : ("tp".equals(sptb) ? this.getSpData(true) : this.getSpData(false).union(this.getSpData(true)));
        spData = spData.orderBy(new String[]{"id DESC"});
        spData = spData.addNullField("updatebaltime");
        spData = spData.map((MapFunction)new AddUpdateBalTime(spData.getRowMeta()));
        return spData;
    }

    private DataSet getSpData(boolean isTempData) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT TOP 10000 ").append("fid").append(AS).append("id");
        sql.append(',').append("fbillid").append(AS).append("billid");
        sql.append(',').append("fbillno").append(AS).append("billno");
        sql.append(',').append("fentryseq").append(AS).append("entryseq");
        sql.append(',').append("fkeycol").append(AS).append("keycol");
        sql.append(',').append("fentryid").append(AS).append("entryid");
        sql.append(',').append("fbillname").append(AS).append("billname");
        sql.append(',').append("fstatus").append(AS).append("status");
        sql.append(',').append("fupdatetype").append(AS).append("updatetype");
        sql.append(',').append("fupdatetime").append(AS).append("updatetime");
        sql.append(',').append("fupdateruleid").append(AS).append("updaterule");
        sql.append(',').append("fcreatetime").append(AS).append("createtime");
        sql.append(',').append("fmovetime").append(AS).append("movetime");
        if (isTempData) {
            sql.append(',').append("'tp'").append(AS).append("sptb");
            sql.append(',').append("fcoverflag").append(AS).append("coverflag");
            sql.append(',').append("freadtype").append(AS).append("readtype");
            sql.append(',').append("fmovetype").append(AS).append("movetype");
            sql.append(',').append("fsync").append(AS).append("sync");
        } else {
            sql.append(',').append("'sp'").append(AS).append("sptb");
            sql.append(',').append("''").append(AS).append("coverflag");
            sql.append(',').append("''").append(AS).append("readtype");
            sql.append(',').append("''").append(AS).append("movetype");
            sql.append(',').append("''").append(AS).append("sync");
        }
        BalanceTB tb = this.getBalanceTb();
        Set<String> spCols = tb.getColsByDataType(BizDataType.OCC, BizDataType.IN, BizDataType.OUT, BizDataType.INIT);
        Map<String, String> colFieldMap = tb.getColFieldMap();
        for (String string : spCols) {
            sql.append(',').append(BalanceTB.parse2SnapName(colFieldMap.get(string))).append(AS).append(BalanceTB.parse2SnapName(string));
        }
        Set<String> notSpCols = tb.getColsByDataType(BizDataType.COVER, BizDataType.PER);
        for (String notSpCol : notSpCols) {
            sql.append(',').append(colFieldMap.get(notSpCol)).append(AS).append(notSpCol);
        }
        sql.append(" FROM ").append(isTempData ? tb.getTmpSnapshotTb() : tb.getSnapshotTb());
        StringBuilder stringBuilder = this.getFs();
        if (stringBuilder.length() != 0) {
            sql.append(" WHERE ").append((CharSequence)stringBuilder);
        }
        return DB.queryDataSet((String)BalSpRpt.class.getName(), (DBRoute)tb.getDbRoute(), (String)sql.toString());
    }

    private BalanceTB getBalanceTb() {
        if (this.tempTb == null) {
            ReportQueryParam report = this.getQueryParam();
            String tbName = null;
            FilterItemInfo filterItem = report.getFilter().getFilterItem("balancetb_s");
            if (filterItem.getValue() != null) {
                tbName = ((DynamicObject)filterItem.getValue()).getPkValue().toString();
            }
            if (StringUtils.isBlank(tbName)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u4f59\u989d\u8868\u540e\u518d\u67e5\u8be2\u3002", (String)"BalSpRpt_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
            this.tempTb = BalanceTB.getBalanceTB(tbName);
        }
        return this.tempTb;
    }

    private StringBuilder getFs() {
        if (this.whereCache == null) {
            List<Object> entryIds;
            List<Object> billIds;
            BalanceTB balTb;
            StringBuilder where = new StringBuilder();
            boolean appendAnd = false;
            Object val = this.rptParam.getKeycol();
            if (val != null) {
                where.append("fkeycol").append("='").append(val).append("' ");
                appendAnd = true;
            }
            if ((val = this.rptParam.getBillName()) != null) {
                if (appendAnd) {
                    where.append(" AND ");
                }
                where.append("fbillname").append("='").append(val).append("' ");
                appendAnd = true;
            }
            if ((val = this.rptParam.getBillno()) != null) {
                if (appendAnd) {
                    where.append(" AND ");
                }
                where.append("fbillno").append("='").append(val).append("' ");
                appendAnd = true;
            }
            if ((val = this.rptParam.getStatus()) != null) {
                if (appendAnd) {
                    where.append(" AND ");
                }
                where.append("fstatus").append("='").append(val).append("' ");
                appendAnd = true;
            }
            if ((val = this.rptParam.getUpdatetype()) != null) {
                if (appendAnd) {
                    where.append(" AND ");
                }
                where.append("fupdatetype").append("=").append(val);
                appendAnd = true;
            }
            if ((val = this.rptParam.getEntryseq()) != null) {
                if (appendAnd) {
                    where.append(" AND ");
                }
                where.append("fentryseq").append("=").append(val);
                appendAnd = true;
            }
            if ((balTb = this.getBalanceTb()).isPerBal() && (val = this.rptParam.getPeriod()) != null) {
                if (appendAnd) {
                    where.append(" AND ");
                }
                where.append(balTb.getColFieldMap().get(balTb.getPeriodCol())).append("=").append(val);
                appendAnd = true;
            }
            if ((billIds = this.rptParam.getBillIds()) != null && billIds.size() > 0) {
                if (appendAnd) {
                    where.append(" AND ");
                }
                where.append("fbillid").append(this.getIdsFilter(billIds));
                appendAnd = true;
            }
            if ((entryIds = this.rptParam.getEntryIds()) != null && entryIds.size() > 0) {
                if (appendAnd) {
                    where.append(" AND ");
                }
                where.append("fentryid").append(this.getIdsFilter(entryIds));
                appendAnd = true;
            }
            this.whereCache = where;
        }
        return this.whereCache;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List<ReportColumn> occColumns = this.getOccColumns();
        columns.addAll(occColumns);
        return columns;
    }

    private String getIdsFilter(Collection<Object> ids) {
        StringBuilder idStr = new StringBuilder();
        int i = 0;
        for (Object billid : ids) {
            if (i != 0) {
                idStr.append(',');
            }
            idStr.append(billid);
            ++i;
        }
        if (ids.size() == 1) {
            return String.format(" = %s", idStr);
        }
        return String.format(" IN (%s)", idStr);
    }

    private List<ReportColumn> getOccColumns() {
        ReportColumn column;
        LocaleString localeStr;
        IDataEntityProperty pro;
        BalanceTB tb = this.getBalanceTb();
        String name = tb.getName();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)name);
        Set<String> spCols = tb.getColsByDataType(BizDataType.OCC, BizDataType.IN, BizDataType.OUT, BizDataType.INIT);
        Set<String> notSpCols = tb.getColsByDataType(BizDataType.COVER, BizDataType.PER);
        ArrayList<ReportColumn> colList = new ArrayList<ReportColumn>(spCols.size() + notSpCols.size());
        for (String col : spCols) {
            pro = type.findProperty(col);
            localeStr = new LocaleString(pro.getDisplayName().getLocaleValue());
            column = ReportColumnFactory.createDecimalColumn((LocaleString)localeStr, (String)BalanceTB.parse2SnapName(col), (int)10);
            colList.add(column);
            column.setNoDisplayScaleZero(true);
            column.setZeroShow(true);
        }
        for (String col : notSpCols) {
            pro = type.findProperty(col);
            column = new ReportColumn();
            localeStr = new LocaleString(pro.getDisplayName().getLocaleValue());
            column.setCaption(localeStr);
            column.setFieldKey(col);
            column.setFieldType("text");
            colList.add(column);
            column.setZeroShow(false);
        }
        return colList;
    }
}

