/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.biz.balance.model.IDataTransform;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MasterIdTrans
implements IDataTransform {
    private final String[] typeCols;
    private final String[] cols;
    private final Set<String> supportTypes;

    public MasterIdTrans(String[] typeCols, String[] cols, Set<String> supportTypes) {
        if (typeCols == null || typeCols.length == 0) {
            throw new IllegalArgumentException("MasterIdTrans constructor args: typeCols cannot be empty.");
        }
        if (cols == null || cols.length == 0) {
            throw new IllegalArgumentException("MasterIdTrans constructor args: cols cannot be empty.");
        }
        if (supportTypes == null || supportTypes.isEmpty()) {
            throw new IllegalArgumentException("MasterIdTrans constructor args: supportTypes cannot be empty.");
        }
        if (typeCols.length != cols.length) {
            throw new IllegalArgumentException("MasterIdTrans constructor args: typeCols and cols mismatch.");
        }
        this.typeCols = typeCols;
        this.cols = cols;
        this.supportTypes = supportTypes;
    }

    @Override
    public DataSet doTransform(DataSet srcData) {
        RowMeta rowMeta = srcData.getRowMeta();
        int len = this.cols.length;
        ArrayList<Integer> existColIdx = new ArrayList<Integer>(len * 2);
        for (int i = 0; i < len; ++i) {
            int colIdx = rowMeta.getFieldIndex(this.cols[i], false);
            int typeColIdx = rowMeta.getFieldIndex(this.typeCols[i], false);
            if (colIdx < 0 || typeColIdx < 0) continue;
            existColIdx.add(colIdx);
            existColIdx.add(typeColIdx);
        }
        if (existColIdx.isEmpty()) {
            BalLogUtil.info("MasterIdTrans.doTransform existColIdx is empty", new Object[0]);
            return srcData;
        }
        return srcData.reduceGroup((ReduceGroupFunctionWithCollector)new MidReduceGroupFunc(rowMeta, existColIdx, this.supportTypes));
    }

    static class MidCache
    extends LinkedHashMap<Long, Long> {
        private static final Map<String, MidCache> LOCAL_CACHE = new ConcurrentHashMap<String, MidCache>();
        private static final int MAX_ID_LEN = 10000;
        private final String entityName;
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();

        static MidCache create(String entityName) {
            String cacheKey = RequestContext.getOrCreate().getAccountId() + "_" + entityName;
            return LOCAL_CACHE.computeIfAbsent(cacheKey, k -> new MidCache(entityName));
        }

        private MidCache(String entityName) {
            this.entityName = entityName;
        }

        Map<Long, Long> getIdMasterIds(Set<Long> ids) {
            Map<Long, Long> result = this.loadFromCache(ids);
            ArrayList<Long> notExistId = new ArrayList<Long>();
            for (Long id : ids) {
                if (result.containsKey(id)) continue;
                notExistId.add(id);
            }
            if (!notExistId.isEmpty()) {
                Map<Long, Long> resultFromDB = this.loadFromDB(notExistId);
                this.putCache(resultFromDB);
                result.putAll(resultFromDB);
            }
            return result;
        }

        private Map<Long, Long> loadFromDB(List<Long> notExistId) {
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            try (DataSet data = QueryServiceHelper.queryDataSet((String)"loadFromDB", (String)this.entityName, (String)"id,masterid", (QFilter[])new QFilter("id", "in", notExistId).toArray(), null);){
                RowMeta rowMeta = data.getRowMeta();
                int idxId = rowMeta.getFieldIndex("id");
                int idxMid = rowMeta.getFieldIndex("masterid");
                for (Row row : data) {
                    result.put(row.getLong(idxId), row.getLong(idxMid));
                }
            }
            return result;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
            return this.size() > 10000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<Long, Long> loadFromCache(Collection<Long> ids) {
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            this.readLock.lock();
            try {
                for (Long id : ids) {
                    Long val = (Long)this.get(id);
                    if (val == null) continue;
                    result.put(id, val);
                }
            }
            finally {
                this.readLock.unlock();
            }
            return result;
        }

        void putCache(Map<Long, Long> idMasterIds) {
            this.writeLock.lock();
            try {
                this.putAll(idMasterIds);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void clear() {
            this.writeLock.lock();
            try {
                super.clear();
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MidCache that = (MidCache)o;
            return this.entityName.equals(that.entityName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.entityName);
        }
    }

    private static class MidReduceGroupFunc
    extends ReduceGroupFunctionWithCollector {
        static final int QUERY_BATCH = 1000;
        RowMeta rowMeta;
        int[] dataTypeIdxs;
        int[] dataIdxs;
        Set<String> types;

        MidReduceGroupFunc(RowMeta rowMeta, List<Integer> existColIdx, Set<String> supportTypes) {
            this.rowMeta = rowMeta;
            this.types = supportTypes;
            int len = existColIdx.size() / 2;
            this.dataTypeIdxs = new int[len];
            this.dataIdxs = new int[len];
            for (int i = 0; i < len; ++i) {
                int idx = 2 * i;
                this.dataIdxs[i] = existColIdx.get(idx);
                this.dataTypeIdxs[i] = existColIdx.get(idx + 1);
            }
        }

        public RowMeta getResultRowMeta() {
            return this.rowMeta;
        }

        public void reduce(Iterator<Row> iterator, Collector collector) {
            ArrayList<Object[]> datas = new ArrayList<Object[]>(256);
            HashMap<String, Set<Long>> idMap = new HashMap<String, Set<Long>>();
            while (iterator.hasNext()) {
                Row row = iterator.next();
                this.collectorId(idMap, row);
                datas.add(RowUtil.toArray((Row)row));
                if (datas.size() <= 1000) continue;
                this.batchPutMasterId(idMap, datas);
                this.outData(collector, datas);
                datas.clear();
            }
            if (datas.size() > 0) {
                this.batchPutMasterId(idMap, datas);
                this.outData(collector, datas);
                datas.clear();
            }
        }

        private void collectorId(Map<String, Set<Long>> idMap, Row row) {
            int len = this.dataTypeIdxs.length;
            for (int i = 0; i < len; ++i) {
                String type = row.getString(this.dataTypeIdxs[i]);
                if (!this.types.contains(type)) continue;
                idMap.computeIfAbsent(type, k -> new HashSet()).add(row.getLong(this.dataIdxs[i]));
            }
        }

        private void outData(Collector collector, List<Object[]> datas) {
            for (Object[] data : datas) {
                collector.collect(data);
            }
        }

        private void batchPutMasterId(Map<String, Set<Long>> idCache, List<Object[]> datas) {
            Map<String, Map<Long, Long>> cacheIds = this.getMasterIdFromCache(idCache);
            for (Object[] data : datas) {
                int len = this.dataTypeIdxs.length;
                for (int i = 0; i < len; ++i) {
                    String type = (String)data[this.dataTypeIdxs[i]];
                    if (!this.types.contains(type)) continue;
                    Long id = (Long)data[this.dataIdxs[i]];
                    id = cacheIds.get(type).get(id);
                    data[this.dataIdxs[i]] = id;
                }
            }
        }

        private Map<String, Map<Long, Long>> getMasterIdFromCache(Map<String, Set<Long>> idCache) {
            HashMap<String, Map<Long, Long>> result = new HashMap<String, Map<Long, Long>>(8);
            for (Map.Entry<String, Set<Long>> entry : idCache.entrySet()) {
                String entityName = entry.getKey();
                result.put(entityName, MidCache.create(entityName).getIdMasterIds(entry.getValue()));
            }
            return result;
        }
    }
}

