/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;

class PerBalQtyReduceFunc
extends ReduceGroupFunctionWithCollector {
    static final String DATA_TYPE_FLAG = "balorspdataflag";
    static final int DATA_BAL = 1;
    static final int DATA_SP = 2;
    private RowMeta rowMeta;
    private int[] qtyIdxs;
    private int[] qtyInIdxs;
    private int[] qtyOutIdxs;
    private int[] qtyBalIdxs;
    private int periodColIdx;
    private int dataTypeIdx;
    private boolean onlyBalQty;

    public PerBalQtyReduceFunc(RowMeta rowMeta, List<String> qtyCols, String periodCol, boolean onlyBalQty) {
        this.onlyBalQty = onlyBalQty;
        this.rowMeta = rowMeta;
        this.periodColIdx = rowMeta.getFieldIndex(periodCol);
        this.dataTypeIdx = rowMeta.getFieldIndex(DATA_TYPE_FLAG);
        int len = qtyCols.size();
        this.qtyIdxs = new int[len];
        this.qtyInIdxs = new int[len];
        this.qtyOutIdxs = new int[len];
        this.qtyBalIdxs = new int[len];
        for (int i = 0; i < len; ++i) {
            String col = qtyCols.get(i);
            this.qtyIdxs[i] = rowMeta.getFieldIndex(col);
            this.qtyInIdxs[i] = rowMeta.getFieldIndex(col + "_in");
            this.qtyOutIdxs[i] = rowMeta.getFieldIndex(col + "_out");
            this.qtyBalIdxs[i] = rowMeta.getFieldIndex(col + "_bal");
        }
    }

    public void reduce(Iterator<Row> rows, Collector ct) {
        HashMap<Integer, Object[]> periodRows = new HashMap<Integer, Object[]>(8);
        while (rows.hasNext()) {
            Row row = rows.next();
            int period = row.getInteger(this.periodColIdx);
            Object[] data = (Object[])periodRows.get(period);
            data = data == null ? this.initFirstRow(row) : this.mergeSpData(data, row);
            data[this.periodColIdx] = period;
            periodRows.put(period, data);
        }
        List<Object[]> results = this.calBalQty(periodRows);
        for (Object[] result : results) {
            ct.collect(result);
        }
    }

    private Object[] initFirstRow(Row row) {
        Object[] data = RowUtil.toArray((Row)row);
        this.cast2BigDecimal(data, this.qtyIdxs);
        this.cast2BigDecimal(data, this.qtyInIdxs);
        this.cast2BigDecimal(data, this.qtyOutIdxs);
        this.cast2BigDecimal(data, this.qtyBalIdxs);
        return data;
    }

    private void cast2BigDecimal(Object[] data, int[] qtyIdxs) {
        for (int idx : qtyIdxs) {
            data[idx] = data[idx] == null ? BigDecimal.ZERO : DataType.convertValue((DataType)DataType.BigDecimalType, (Object)data[idx]);
        }
    }

    private BigDecimal[] sumSpQtyBeforePeriod(List<Object[]> spRows, List<Object[]> sortedBalRows) {
        if (spRows.isEmpty() || sortedBalRows.isEmpty()) {
            return null;
        }
        int firstPeriod = (Integer)sortedBalRows.get(0)[this.periodColIdx];
        BigDecimal[] tempQtys = this.initTempQtys();
        for (Object[] spRow : spRows) {
            if ((Integer)spRow[this.periodColIdx] >= firstPeriod) continue;
            this.calTempQtys(spRow, tempQtys);
        }
        return tempQtys;
    }

    private List<Object[]> calBalQty(Map<Integer, Object[]> periodRows) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(periodRows.size());
        ArrayList<Object[]> spRows = new ArrayList<Object[]>();
        for (Object[] row : periodRows.values()) {
            if (1 == (Integer)DataType.convertValue((DataType)DataType.IntegerType, (Object)row[this.dataTypeIdx])) {
                rows.add(row);
                continue;
            }
            spRows.add(row);
        }
        rows.sort((row1, row2) -> (Integer)row1[this.periodColIdx] - (Integer)row2[this.periodColIdx]);
        BigDecimal[] spSumQty = this.sumSpQtyBeforePeriod(spRows, rows);
        if (this.onlyBalQty) {
            BigDecimal[] tempQtys = this.initTempQtys();
            for (Object[] row : rows) {
                this.calTempQtys(row, tempQtys);
                this.addBalQty2Row(row, tempQtys);
            }
        } else {
            int len = rows.size();
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    this.calAllQty4Row((Object[])rows.get(i));
                    continue;
                }
                this.calAllQty4Row((Object[])rows.get(i - 1), (Object[])rows.get(i));
            }
        }
        if (spSumQty != null) {
            this.addSpSumQty(spSumQty, rows);
        }
        return rows;
    }

    private void addSpSumQty(BigDecimal[] spSumQty, List<Object[]> rows) {
        if (this.onlyBalQty) {
            for (Object[] row : rows) {
                this.addBalQty2Row(row, spSumQty);
            }
        } else {
            for (Object[] row : rows) {
                this.addBalAndInitQty2Row(row, spSumQty);
            }
        }
    }

    private void calAllQty4Row(Object[] currentRow) {
        int len = this.qtyIdxs.length;
        for (int i = 0; i < len; ++i) {
            currentRow[this.qtyBalIdxs[i]] = ((BigDecimal)currentRow[this.qtyIdxs[i]]).add((BigDecimal)currentRow[this.qtyInIdxs[i]]).subtract((BigDecimal)currentRow[this.qtyOutIdxs[i]]);
        }
    }

    private void calAllQty4Row(Object[] preRow, Object[] currentRow) {
        int len = this.qtyIdxs.length;
        for (int i = 0; i < len; ++i) {
            currentRow[this.qtyIdxs[i]] = preRow[this.qtyBalIdxs[i]];
        }
        this.calAllQty4Row(currentRow);
    }

    private void addBalQty2Row(Object[] row, BigDecimal[] tempQtys) {
        int len = this.qtyIdxs.length;
        for (int i = 0; i < len; ++i) {
            row[this.qtyBalIdxs[i]] = tempQtys[i].add((BigDecimal)row[this.qtyBalIdxs[i]]);
        }
    }

    private void addBalAndInitQty2Row(Object[] row, BigDecimal[] tempQtys) {
        int len = this.qtyIdxs.length;
        for (int i = 0; i < len; ++i) {
            row[this.qtyBalIdxs[i]] = tempQtys[i].add((BigDecimal)row[this.qtyBalIdxs[i]]);
            row[this.qtyIdxs[i]] = tempQtys[i].add((BigDecimal)row[this.qtyIdxs[i]]);
        }
    }

    private void calTempQtys(Object[] row, BigDecimal[] tempQtys) {
        int len = this.qtyIdxs.length;
        for (int i = 0; i < len; ++i) {
            tempQtys[i] = tempQtys[i].add((BigDecimal)row[this.qtyIdxs[i]]).add((BigDecimal)row[this.qtyInIdxs[i]]).subtract((BigDecimal)row[this.qtyOutIdxs[i]]);
        }
    }

    private BigDecimal[] initTempQtys() {
        BigDecimal[] tempQtys = new BigDecimal[this.qtyIdxs.length];
        int len = tempQtys.length;
        for (int i = 0; i < len; ++i) {
            tempQtys[i] = BigDecimal.ZERO;
        }
        return tempQtys;
    }

    private Object[] mergeSpData(Object[] data, Row row) {
        int dataType = (Integer)DataType.convertValue((DataType)DataType.IntegerType, (Object)data[this.dataTypeIdx]);
        int rowType = row.getInteger(this.dataTypeIdx);
        if (rowType == 1) {
            Object[] newData = RowUtil.toArray((Row)row);
            if (dataType == 2) {
                int len = this.qtyIdxs.length;
                for (int i = 0; i < len; ++i) {
                    this.mergeQty2Row(newData, data, this.qtyIdxs, i);
                    this.mergeQty2Row(newData, data, this.qtyInIdxs, i);
                    this.mergeQty2Row(newData, data, this.qtyOutIdxs, i);
                }
                data = newData;
            }
        } else if (rowType == 2) {
            int len = this.qtyIdxs.length;
            for (int i = 0; i < len; ++i) {
                this.mergeQty2Data(data, row, this.qtyIdxs, i);
                this.mergeQty2Data(data, row, this.qtyInIdxs, i);
                this.mergeQty2Data(data, row, this.qtyOutIdxs, i);
            }
        }
        return data;
    }

    private void mergeQty2Data(Object[] data, Row row, int[] idx, int i) {
        BigDecimal dataQty = row.getBigDecimal(idx[i]);
        if (dataQty != null) {
            data[idx[i]] = dataQty.add((BigDecimal)data[idx[i]]);
        }
    }

    private void mergeQty2Row(Object[] newData, Object[] data, int[] idx, int i) {
        BigDecimal newDataQty = (BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)newData[idx[i]]);
        if (newDataQty == null) {
            newDataQty = BigDecimal.ZERO;
        }
        newData[idx[i]] = newDataQty.add((BigDecimal)data[idx[i]]);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

