/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.biz.balance.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.biz.balance.model.IRuleFilter;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.metadata.balance.BalanceRuleCacheUtils;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class UpdateRuleCache {
    private static final Map<String, Set<String>> CACHE_ENTITY_RULE_IDS = new ConcurrentHashMap<String, Set<String>>();
    private static final Map<String, UpdateRule> CAHCE_RULE = new ConcurrentHashMap<String, UpdateRule>();
    private static final Map<String, Long> CACHE_ENTITY_RULE_IDS_VERSION = new ConcurrentHashMap<String, Long>();

    public static UpdateRule getUpdateRuleFromCache(String ruleId) {
        String acctId = CacheKeyUtil.getAcctId();
        String key = acctId + ruleId;
        UpdateRule rule = CAHCE_RULE.get(key);
        if (rule != null) {
            String billName = rule.getEntityNumber();
            Long version = BalanceRuleCacheUtils.getRuleVersion((String)billName);
            String entityNameKey = acctId + billName;
            if (version != null && version.equals(CACHE_ENTITY_RULE_IDS_VERSION.get(entityNameKey))) {
                return rule;
            }
            UpdateRuleCache.getUpdateRuleByBill(billName);
            rule = CAHCE_RULE.get(key);
        } else {
            rule = UpdateRuleCache.loadSingleRule(ruleId);
            if (rule != null) {
                CAHCE_RULE.put(key, rule);
            }
        }
        return rule;
    }

    public static List<UpdateRule> getUpdateRuleByBal(String balName) {
        return UpdateRuleCache.getUpdateRule(balName, false, null);
    }

    public static List<UpdateRule> getUpdateRuleByBal(String balName, IRuleFilter filter) {
        return UpdateRuleCache.getUpdateRule(balName, false, filter);
    }

    public static List<UpdateRule> getUpdateRuleByBill(String billName) {
        return UpdateRuleCache.getUpdateRule(billName, true, null);
    }

    public static List<UpdateRule> getUpdateRuleByBill(String billName, IRuleFilter filter) {
        return UpdateRuleCache.getUpdateRule(billName, true, filter);
    }

    public static List<UpdateRule> getUpdateRule(String balName, String billName) {
        Set<String> balMatchIds = UpdateRuleCache.getUpdateRuleIds(balName, false);
        Set<String> billMatchIds = UpdateRuleCache.getUpdateRuleIds(billName, true);
        HashSet<String> ids = new HashSet<String>(4);
        for (String id : balMatchIds) {
            if (!billMatchIds.contains(id)) continue;
            ids.add(id);
        }
        return UpdateRuleCache.getRules(ids, null);
    }

    private static Set<String> getUpdateRuleIds(String entityName, boolean loadByBill) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return new HashSet<String>();
        }
        String accId = CacheKeyUtil.getAcctId();
        String entityNameKey = accId + entityName;
        Long version = BalanceRuleCacheUtils.getRuleVersion((String)entityName);
        if (version == null) {
            CACHE_ENTITY_RULE_IDS.remove(entityNameKey);
            CACHE_ENTITY_RULE_IDS_VERSION.put(entityNameKey, BalanceRuleCacheUtils.updateRuleVersion((String)entityName));
        } else if (!version.equals(CACHE_ENTITY_RULE_IDS_VERSION.get(entityNameKey))) {
            CACHE_ENTITY_RULE_IDS.remove(entityNameKey);
            CACHE_ENTITY_RULE_IDS_VERSION.put(entityNameKey, version);
        }
        Set<String> rules = CACHE_ENTITY_RULE_IDS.get(entityNameKey);
        if (rules == null || UpdateRuleCache.isTbVersionChanged(rules)) {
            List ruleElements = loadByBill ? BalanceUpdateRuleReader.loadRulesBySrcBill((String)entityName) : BalanceUpdateRuleReader.loadRulesByBalance((String)entityName);
            rules = new HashSet<String>(ruleElements.size());
            for (BalanceUpdateRuleElement ruleElement : ruleElements) {
                if (!UpdateRuleCache.checkEntityExist(ruleElement)) continue;
                UpdateRule rule = UpdateRule.getUpdateRule(ruleElement);
                CAHCE_RULE.put(accId + rule.getId(), rule);
                rules.add(rule.getId());
            }
            CACHE_ENTITY_RULE_IDS.put(entityNameKey, rules);
        }
        return rules;
    }

    private static boolean checkEntityExist(BalanceUpdateRuleElement ruleElement) {
        StringBuilder msg = new StringBuilder();
        String billEntity = ruleElement.getSourceEntityNumber();
        String balEntity = ruleElement.getBalanceTableNumber();
        try {
            MetadataServiceHelper.getDataEntityType((String)billEntity);
        }
        catch (Exception e) {
            msg.append("sourcebill entity: ").append(billEntity).append(" not exist");
        }
        try {
            MetadataServiceHelper.getDataEntityType((String)balEntity);
        }
        catch (Exception e) {
            if (msg.length() > 0) {
                msg.append(", ");
            }
            msg.append("balance entity: ").append(balEntity).append(" not exist");
        }
        if (msg.length() > 0) {
            BalLogUtil.saveWarn("UpdateRuleCache", "ruleNo=" + ruleElement.getNumber(), "checkEntityExist", msg.toString());
            return false;
        }
        return true;
    }

    private static UpdateRule loadSingleRule(String ruleId) {
        BalanceUpdateRuleElement rule = BalanceUpdateRuleReader.loadRules((String)ruleId);
        if (rule == null || !UpdateRuleCache.checkEntityExist(rule)) {
            return null;
        }
        return UpdateRule.getUpdateRule(rule);
    }

    private static boolean isTbVersionChanged(Set<String> ruleIds) {
        HashMap<String, Long> versions = new HashMap<String, Long>(8);
        String tb = null;
        List<UpdateRule> rules = UpdateRuleCache.getRules(ruleIds, null);
        for (UpdateRule rule : rules) {
            tb = rule.getBalanceNo();
            Long version = (Long)versions.get(tb);
            if (version == null) {
                version = BalanceRuleCacheUtils.getBalTBVersion((String)tb);
                versions.put(tb, version);
            }
            if (rule.getBalanceTB().getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }

    private static List<UpdateRule> getUpdateRule(String entityName, boolean loadByBill, IRuleFilter filter) {
        Set<String> ids = UpdateRuleCache.getUpdateRuleIds(entityName, loadByBill);
        return UpdateRuleCache.getRules(ids, filter);
    }

    private static List<UpdateRule> getRules(Set<String> ids, IRuleFilter filter) {
        ArrayList<UpdateRule> rules = new ArrayList<UpdateRule>(ids.size());
        String accId = CacheKeyUtil.getAcctId();
        UpdateRule rule = null;
        for (String id : ids) {
            rule = CAHCE_RULE.get(accId + id);
            if (filter != null && !filter.filter(rule)) continue;
            rules.add(rule);
        }
        return rules;
    }
}

